/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.frame;

import com.ibm.etools.webedit.frame.FrameManager;
import com.ibm.etools.webedit.frame.FrameManagerListener;
import com.ibm.etools.webedit.frame.FrameNode;
import com.ibm.etools.webedit.frame.FramePageNode;
import com.ibm.etools.webedit.frame.FrameSetNode;
import com.ibm.etools.webedit.viewer.internal.frame.FrameNodeImpl;
import com.ibm.etools.webedit.viewer.internal.frame.FrameSetNodeImpl;
import com.ibm.etools.webedit.viewer.utils.HTMLModelChangeAdapter;
import com.ibm.etools.webedit.viewer.utils.IHTMLModelChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class FrameManagerImpl
implements FrameManager {
    private IDOMModel model;
    private FrameSetNodeImpl top;
    private FrameNodeImpl parent;
    private ListenerList listeners = null;
    private boolean waitUpdateStructure = false;
    private boolean waitFiringUpdateStructure = false;
    private boolean waitUpdateBounds = false;
    private boolean waitFiringUpdateBounds = false;
    private boolean waitUpdateMargins = false;
    private boolean waitFiringUpdateMargins = false;
    private boolean active = true;
    private IHTMLModelChangeListener listener = new ModelListener();

    public FrameManagerImpl() {
    }

    public FrameManagerImpl(FrameNodeImpl parent) {
        this();
        this.parent = parent;
    }

    @Override
    public void activate(boolean isActive) {
        if (this.active == isActive) {
            return;
        }
        this.active = isActive;
        if (isActive) {
            this.refresh();
        }
    }

    private void addListener() {
        if (this.model == null) {
            return;
        }
        HTMLModelChangeAdapter adapter = (HTMLModelChangeAdapter)this.model.getDocument().getAdapterFor(HTMLModelChangeAdapter.class);
        if (adapter != null) {
            adapter.addListener(this.listener);
        }
    }

    @Override
    public void addListener(FrameManagerListener frameListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)frameListener);
    }

    private void attrChangedOrRemoved(Node node, String attrName, boolean removed) {
        FrameNode n;
        if (!this.active) {
            return;
        }
        if (node == null) {
            return;
        }
        String nodeName = node.getNodeName();
        if (node.getNodeType() == 1 && (nodeName.equalsIgnoreCase("FRAMESET") || nodeName.equalsIgnoreCase("FRAME")) && (n = this.find((Element)node)) != null && n instanceof FrameNodeImpl) {
            int ret;
            int n2 = ret = removed ? ((FrameNodeImpl)n).attrRemoved(attrName) : ((FrameNodeImpl)n).updateAttr(attrName);
            if (ret == 2) {
                if (!this.waitUpdateStructure && !this.waitFiringUpdateStructure) {
                    this.waitFiringUpdateStructure = true;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FrameManagerImpl.this.fireStructureChanged();
                        }
                    });
                }
            } else if (ret == 1) {
                if (!this.waitUpdateBounds && !this.waitFiringUpdateBounds) {
                    this.waitFiringUpdateBounds = true;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FrameManagerImpl.this.fireBoundsChanged();
                        }
                    });
                }
            } else if (ret == 3 && !this.waitUpdateMargins && !this.waitFiringUpdateMargins) {
                this.waitFiringUpdateMargins = true;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FrameManagerImpl.this.fireMarginsChanged();
                    }
                });
            }
        }
    }

    void boundsChanged(boolean sync) {
        if (!this.isFrame() || !this.active) {
            return;
        }
        if (!this.waitUpdateBounds) {
            this.waitUpdateBounds = true;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    FrameManagerImpl.this.waitUpdateBounds = false;
                    FrameManagerImpl.this.fireBoundsChanged();
                }
            };
            if (sync) {
                runner.run();
            } else {
                Display.getDefault().asyncExec(runner);
            }
        }
    }

    void marginsChanged(boolean sync) {
        if (!this.active) {
            return;
        }
        if (!this.waitUpdateMargins) {
            this.waitUpdateMargins = true;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    FrameManagerImpl.this.waitUpdateMargins = false;
                    FrameManagerImpl.this.fireMarginsChanged();
                }
            };
            if (sync) {
                runner.run();
            } else {
                Display.getDefault().asyncExec(runner);
            }
        }
    }

    @Override
    public void dispose() {
        this.removeListener();
        if (this.top != null) {
            this.top.dispose();
            this.top = null;
        }
    }

    private FrameNode find(FrameNode node, Object modelId, IStructuredModel model) {
        FrameNode[] children;
        IDOMModel m;
        if (node == null) {
            return null;
        }
        if (node.getType() == 2 && (m = ((FramePageNode)node).getModel()) != null && model.equals(m)) {
            return node;
        }
        if (!node.hasChildren()) {
            return null;
        }
        if (node.getType() == 2) {
            node = ((FramePageNode)node).getNestedFrameSet();
        }
        if (node.getType() == 1 && (children = ((FrameSetNode)node).getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                FrameNode n = this.find(children[i], modelId, model);
                if (n != null) {
                    return n;
                }
                ++i;
            }
        }
        return null;
    }

    private FrameNode find(FrameNode node, Element elm) {
        FrameNode[] children;
        if (node == null) {
            return null;
        }
        if (node.getElement() == elm) {
            return node;
        }
        if (!node.hasChildren()) {
            return null;
        }
        if (node.getType() == 2) {
            node = ((FramePageNode)node).getNestedFrameSet();
        }
        if (node.getType() == 1 && (children = ((FrameSetNode)node).getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                FrameNode n = this.find(children[i], elm);
                if (n != null) {
                    return n;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public FrameNode find(Object modelID, IStructuredModel model) {
        if (this.waitUpdateStructure) {
            this.updateFrameTree();
        }
        if (this.top == null) {
            return null;
        }
        return this.find(this.top, modelID, model);
    }

    @Override
    public FrameNode find(Element elm) {
        if (this.waitUpdateStructure) {
            this.updateFrameTree();
        }
        if (this.top == null) {
            return null;
        }
        return this.find(this.top, elm);
    }

    private FramePageNode getFirstFramePageNode(FrameNode node) {
        FrameNode[] children;
        if (node == null) {
            return null;
        }
        if (node.getType() == 2) {
            FrameSetNode nest = ((FramePageNode)node).getNestedFrameSet();
            if (nest == null) {
                return (FramePageNode)node;
            }
            node = nest;
        }
        if ((children = ((FrameSetNode)node).getChildren()).length == 0) {
            return null;
        }
        int i = 0;
        while (i < children.length) {
            FrameNode n = children[i];
            FramePageNode nn = this.getFirstFramePageNode(n);
            if (nn != null) {
                return nn;
            }
            ++i;
        }
        return null;
    }

    private FramePageNode getLastFramePageNode(FrameNode node) {
        FrameNode[] children;
        if (node == null) {
            return null;
        }
        if (node.getType() == 2) {
            FrameSetNode nest = ((FramePageNode)node).getNestedFrameSet();
            if (nest == null) {
                return (FramePageNode)node;
            }
            node = nest;
        }
        if ((children = ((FrameSetNode)node).getChildren()).length == 0) {
            return null;
        }
        int i = children.length - 1;
        while (i >= 0) {
            FrameNode n = children[i];
            FramePageNode nn = this.getLastFramePageNode(n);
            if (nn != null) {
                return nn;
            }
            --i;
        }
        return null;
    }

    private FramePageNode getNext(FrameNode node, boolean next) {
        if (node == null) {
            return null;
        }
        FrameSetNode p = null;
        while (node != null) {
            FrameNode n = node.getParentFrameNode();
            if (n != null && n.getType() == 1) {
                p = (FrameSetNode)n;
                break;
            }
            node = n;
        }
        if (p == null) {
            return null;
        }
        FrameNode[] children = p.getChildren();
        int index = p.getChildIndex(node);
        if (next) {
            if (index + 1 < children.length) {
                FrameNode n = children[index + 1];
                FramePageNode nn = this.getFirstFramePageNode(n);
                if (nn != null) {
                    return nn;
                }
                return this.getNext(n, next);
            }
        } else if (index - 1 >= 0) {
            FrameNode n = p.getChildren()[index - 1];
            FramePageNode nn = this.getLastFramePageNode(n);
            if (nn != null) {
                return nn;
            }
            return this.getNext(n, next);
        }
        return null;
    }

    @Override
    public FramePageNode findNext(FrameNode node, boolean next) {
        do {
            FramePageNode n;
            if ((n = this.getNext(node, next)) == null) continue;
            return n;
        } while ((node = node.getParentFrameNode()) != null);
        if (next) {
            return this.getFirstFramePageNode(this.top);
        }
        return this.getLastFramePageNode(this.top);
    }

    private void fireBoundsChanged() {
        this.waitFiringUpdateBounds = false;
        if (this.listeners != null) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                ((FrameManagerListener)l[i]).boundsChanged();
                ++i;
            }
        }
    }

    private void fireStructureChanged() {
        this.waitFiringUpdateStructure = false;
        if (this.listeners != null) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                ((FrameManagerListener)l[i]).structureChanged();
                ++i;
            }
        }
    }

    private void fireMarginsChanged() {
        this.waitFiringUpdateMargins = false;
        if (this.listeners != null) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                ((FrameManagerListener)l[i]).marginsChanged();
                ++i;
            }
        }
    }

    @Override
    public FrameSetNode getTop() {
        return this.top;
    }

    @Override
    public boolean isFrame() {
        return this.top != null;
    }

    private void modelChanged(Node node) {
        if (node == null) {
            return;
        }
        String nodeName = node.getNodeName();
        if (nodeName.equalsIgnoreCase("FRAMESET") || nodeName.equalsIgnoreCase("FRAME")) {
            this.structureChanged(false);
        }
    }

    @Override
    public void refresh() {
        this.structureChanged(true);
        this.boundsChanged(true);
        this.marginsChanged(true);
    }

    private void removeListener() {
        if (this.model == null) {
            return;
        }
        HTMLModelChangeAdapter adapter = (HTMLModelChangeAdapter)this.model.getDocument().getAdapterFor(HTMLModelChangeAdapter.class);
        if (adapter != null) {
            adapter.removeListener(this.listener);
        }
    }

    @Override
    public void removeListener(FrameManagerListener frameListener) {
        if (this.listeners != null && frameListener != null) {
            this.listeners.remove((Object)frameListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    @Override
    public void setModel(IDOMModel model) {
        this.removeListener();
        this.model = model;
        this.updateFrameTree();
        this.addListener();
    }

    void structureChanged(boolean sync) {
        if (!this.active) {
            return;
        }
        if (!this.waitUpdateStructure) {
            this.waitUpdateStructure = true;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    FrameManagerImpl.this.updateFrameTree();
                    FrameManagerImpl.this.fireStructureChanged();
                }
            };
            if (sync) {
                runner.run();
            } else {
                Display.getDefault().asyncExec(runner);
            }
        }
    }

    private void updateFrameTree() {
        if (!this.active) {
            return;
        }
        this.waitUpdateStructure = false;
        Node node = null;
        if (this.model != null) {
            IDOMDocument doc = this.model.getDocument();
            DocumentTraversal docTraversal = (DocumentTraversal)doc;
            NodeIterator iter = docTraversal.createNodeIterator((Node)doc, 1, null, false);
            while ((node = iter.nextNode()) != null) {
                String nodeName = node.getNodeName();
                if (nodeName == null) continue;
                if (nodeName.equalsIgnoreCase("FRAMESET")) break;
                if (!nodeName.equalsIgnoreCase("BODY")) continue;
                node = null;
                break;
            }
        }
        if (node != null) {
            if (this.top == null) {
                this.top = new FrameSetNodeImpl(this.parent, this);
            }
            this.top.setElement((Element)node);
        } else if (this.top != null) {
            this.top.dispose();
            this.top = null;
        }
    }

    private class ModelListener
    implements IHTMLModelChangeListener {
        private ModelListener() {
        }

        @Override
        public void beginNotification() {
        }

        @Override
        public void attributeChanged(Node node, String attrName) {
            FrameManagerImpl.this.attrChangedOrRemoved(node, attrName, false);
        }

        @Override
        public void attributeRemoved(Node node, String attrName) {
            FrameManagerImpl.this.attrChangedOrRemoved(node, attrName, true);
        }

        @Override
        public void nodeAdded(Node node) {
            FrameManagerImpl.this.modelChanged(node);
        }

        @Override
        public void nodeRemoved(Node node) {
            FrameManagerImpl.this.modelChanged(node);
        }

        @Override
        public void endNotification() {
        }
    }
}

