/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal;

import com.ibm.etools.webedit.viewer.HTMLViewPartFactoryContributor;
import com.ibm.etools.webedit.viewer.WebEditViewerPlugin;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class HTMLViewPartFactoryContributorRegistry {
    private static HTMLViewPartFactoryContributorRegistry instance;
    private static HTMLViewPartFactoryContributor[] EMPTY_CONTRIBUTOR;
    private static String EXTENSION_POINT_ID;
    private static String EL_CONTRIBUTOR;
    private static String AT_CLASS_NAME;
    private static String AT_DEFAULT;
    private static String AT_EMBEDDED_DOC;
    private List contributors;
    private List defaultContributors;
    private List embeddedDocContributors;

    static {
        EMPTY_CONTRIBUTOR = new HTMLViewPartFactoryContributor[0];
        EXTENSION_POINT_ID = "htmlViewPartFactoryContributor";
        EL_CONTRIBUTOR = "contributor";
        AT_CLASS_NAME = "class";
        AT_DEFAULT = "default";
        AT_EMBEDDED_DOC = "embeddedDoc";
    }

    private HTMLViewPartFactoryContributorRegistry() {
        this.readRegistry();
    }

    public static HTMLViewPartFactoryContributorRegistry getInstance() {
        if (instance == null) {
            instance = new HTMLViewPartFactoryContributorRegistry();
        }
        return instance;
    }

    public HTMLViewPartFactoryContributor[] getContributors() {
        if (this.contributors != null) {
            HTMLViewPartFactoryContributor[] array = new HTMLViewPartFactoryContributor[this.contributors.size()];
            this.contributors.toArray(array);
            return array;
        }
        return EMPTY_CONTRIBUTOR;
    }

    public HTMLViewPartFactoryContributor[] getDefaultContributors() {
        if (this.defaultContributors != null) {
            HTMLViewPartFactoryContributor[] array = new HTMLViewPartFactoryContributor[this.defaultContributors.size()];
            this.defaultContributors.toArray(array);
            return array;
        }
        return EMPTY_CONTRIBUTOR;
    }

    public HTMLViewPartFactoryContributor[] getEmbeddedDocContributors() {
        if (this.embeddedDocContributors != null) {
            HTMLViewPartFactoryContributor[] array = new HTMLViewPartFactoryContributor[this.embeddedDocContributors.size()];
            this.embeddedDocContributors.toArray(array);
            return array;
        }
        return EMPTY_CONTRIBUTOR;
    }

    private void readRegistry() {
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extRegistry.getExtensionPoint(WebEditViewerPlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    private void readElement(IConfigurationElement element) {
        if (element == null || !element.getName().equals(EL_CONTRIBUTOR)) {
            return;
        }
        String className = element.getAttribute(AT_CLASS_NAME);
        if (className == null) {
            return;
        }
        String defaultValue = element.getAttribute(AT_DEFAULT);
        boolean isDefault = Boolean.TRUE.toString().equalsIgnoreCase(defaultValue);
        String embeddedDocValue = element.getAttribute(AT_EMBEDDED_DOC);
        boolean isEmbeddedDoc = Boolean.TRUE.toString().equalsIgnoreCase(embeddedDocValue);
        try {
            Object ret;
            Class cls;
            Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
            if (bundle != null && (cls = bundle.loadClass(className)) != null && (ret = cls.newInstance()) != null) {
                if (isEmbeddedDoc) {
                    this.internalGetEmbeddedDocContributors().add(ret);
                } else if (isDefault) {
                    this.internalGetDefaultContributors().add(ret);
                } else {
                    this.internalGetContributors().add(ret);
                }
            }
        }
        catch (ClassNotFoundException e) {
            Logger.log(e);
        }
        catch (IllegalAccessException e) {
            Logger.log(e);
        }
        catch (InstantiationException e) {
            Logger.log(e);
        }
    }

    private List internalGetContributors() {
        if (this.contributors == null) {
            this.contributors = new ArrayList();
        }
        return this.contributors;
    }

    private List internalGetDefaultContributors() {
        if (this.defaultContributors == null) {
            this.defaultContributors = new ArrayList();
        }
        return this.defaultContributors;
    }

    private List internalGetEmbeddedDocContributors() {
        if (this.embeddedDocContributors == null) {
            this.embeddedDocContributors = new ArrayList();
        }
        return this.embeddedDocContributors;
    }
}

