/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal;

import com.ibm.etools.webedit.editparts.adapter.SubModelOwner;
import com.ibm.etools.webedit.frame.FrameLayoutNode;
import com.ibm.etools.webedit.frame.FrameNode;
import com.ibm.etools.webedit.frame.FramePageNode;
import com.ibm.etools.webedit.frame.FrameView;
import com.ibm.etools.webedit.viewer.HTMLViewerController;
import com.ibm.etools.webedit.viewer.internal.HTMLViewPaneImpl;
import com.ibm.etools.webedit.viewer.internal.frame.FrameViewOwner;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FrameViewImpl
implements FrameView {
    private Canvas canvas;
    private HTMLViewPaneImpl canvasGenerator;
    private HTMLViewPaneImpl viewer;
    private Sash[] rowSashes;
    private Sash[] colSashes;
    private PaintListener vSashPainter = new VSashPainter();
    private PaintListener hSashPainter = new HSashPainter();
    private SashHandler sashHandler = new SashHandler();
    private FrameView parentFrameView;
    private Canvas parentCanvas;
    private FrameLayoutNode frameNode;
    private HTMLViewerController controller;
    private FrameViewOwner owner;
    private String clientName = "PageDesigner";
    private SubModelOwner subModelOwner;

    public FrameViewImpl(FrameView parent, HTMLViewerController controller) {
        this.parentFrameView = parent;
        this.controller = controller;
    }

    public FrameViewImpl(Canvas parent, HTMLViewerController controller) {
        this.parentCanvas = parent;
        this.controller = controller;
    }

    private void createCanvas(boolean addmenu) {
        if (this.canvas != null) {
            return;
        }
        if (this.canvasGenerator == null) {
            this.canvasGenerator = new HTMLViewPaneImpl(this.clientName);
            this.canvasGenerator.setSubModelOwner(this.subModelOwner);
        }
        if (this.parentFrameView != null && this.parentFrameView instanceof FrameViewImpl) {
            this.parentCanvas = ((FrameViewImpl)this.parentFrameView).getCanvas();
        }
        this.canvasGenerator.createControl((Composite)this.parentCanvas);
        this.canvasGenerator.setViewerController(this.controller);
        this.canvas = (Canvas)this.canvasGenerator.getControl();
        this.canvas.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!FrameViewImpl.this.isFrameSet()) {
                    FrameViewImpl.this.owner.setActiveFrame(FrameViewImpl.this);
                    if (FrameViewImpl.this.canvas != null && !FrameViewImpl.this.canvas.isDisposed()) {
                        FrameViewImpl.this.canvas.redraw();
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                if (FrameViewImpl.this.canvas != null && !FrameViewImpl.this.canvas.isDisposed()) {
                    FrameViewImpl.this.canvas.redraw();
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Canvas frameCanvas = FrameViewImpl.this.getCanvas();
                if (frameCanvas != null && !frameCanvas.isDisposed()) {
                    frameCanvas.setFocus();
                }
            }
        });
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (FrameViewImpl.this.canvas != null && !FrameViewImpl.this.canvas.isDisposed()) {
                    FrameViewImpl.this.canvas.redraw();
                }
            }
        });
    }

    private Sash[] createSashes(Rectangle[] rects, Sash[] original, int orientation) {
        if (this.canvas == null) {
            this.createCanvas(true);
        }
        Sash[] newSashes = null;
        int r = 0;
        if (rects != null && rects.length > 0) {
            newSashes = original;
            if (original == null || rects.length != original.length) {
                newSashes = new Sash[rects.length];
            }
            r = 0;
            while (r < rects.length) {
                newSashes[r] = original != null && r < original.length ? original[r] : new Sash((Composite)this.canvas, orientation);
                PaintListener painter = orientation == 256 ? this.hSashPainter : this.vSashPainter;
                newSashes[r].removePaintListener(painter);
                newSashes[r].addPaintListener(painter);
                newSashes[r].removeSelectionListener((SelectionListener)this.sashHandler);
                newSashes[r].addSelectionListener((SelectionListener)this.sashHandler);
                newSashes[r].setBounds(rects[r].x, rects[r].y, Math.max(rects[r].width, 1), Math.max(rects[r].height, 1));
                newSashes[r].redraw();
                ++r;
            }
        }
        if (original != null) {
            while (r < original.length) {
                original[r].dispose();
                ++r;
            }
        }
        return newSashes;
    }

    private void createViewer() {
        if (this.viewer != null) {
            return;
        }
        if (this.canvasGenerator == null) {
            this.canvasGenerator = new HTMLViewPaneImpl(this.clientName);
        }
        this.viewer = this.canvasGenerator;
        this.createCanvas(false);
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setLayout(null);
        }
    }

    @Override
    public void dispose() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
        this.canvas = null;
    }

    public Canvas getCanvas() {
        if (this.canvas == null) {
            this.createCanvas(true);
        }
        return this.canvas;
    }

    @Override
    public Rectangle getClientArea() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            return this.canvas.getClientArea();
        }
        return null;
    }

    public FrameNode getFrameNode() {
        if (this.frameNode == null) {
            return null;
        }
        return this.frameNode.getFrameNode();
    }

    private IDOMModel getModel() {
        if (this.frameNode == null) {
            return null;
        }
        FrameNode n = this.frameNode.getFrameNode();
        if (n == null) {
            return null;
        }
        if (n.getType() == 1) {
            return null;
        }
        FramePageNode fpn = (FramePageNode)n;
        return fpn.getModel();
    }

    public HTMLViewPaneImpl getViewer() {
        return this.viewer;
    }

    private boolean isFrameSet() {
        if (this.frameNode == null) {
            return false;
        }
        FrameNode n = this.frameNode.getFrameNode();
        if (n == null) {
            return false;
        }
        return n.hasChildren();
    }

    private void paintSash(Sash sash, GC gc, int orientation) {
        Point size = sash.getSize();
        gc.setForeground(Display.getDefault().getSystemColor(20));
        if (orientation == 256) {
            gc.drawLine(0, 0, size.x, 0);
            gc.drawLine(0, 1, size.x, 1);
        } else {
            gc.drawLine(0, 0, 0, size.y);
            gc.drawLine(1, 0, 1, size.y);
        }
        gc.setForeground(Display.getDefault().getSystemColor(17));
        if (orientation == 256) {
            gc.drawLine(0, size.y - 1, size.x, size.y - 1);
            gc.drawLine(0, size.y - 2, size.x, size.y - 2);
        } else {
            gc.drawLine(size.x - 1, 0, size.x - 1, size.y);
            gc.drawLine(size.x - 2, 0, size.x - 2, size.y);
        }
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.createCanvas(true);
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setBounds(bounds);
        }
    }

    @Override
    public void setMargins(int h, boolean hs, int v, boolean vs) {
        if (this.viewer != null) {
            this.viewer.updateMargins(h, hs, v, vs);
        }
    }

    @Override
    public void setFrameLayoutNode(FrameLayoutNode node) {
        IDOMModel model;
        this.frameNode = node;
        if (this.viewer == null && (model = this.getModel()) != null) {
            this.createViewer();
            if (this.viewer != null) {
                this.viewer.setModel(model);
            }
        }
    }

    public void setOwner(FrameViewOwner owner) {
        this.owner = owner;
    }

    @Override
    public void setSashes(Rectangle[] rows, Rectangle[] cols) {
        if (this.canvas == null) {
            this.createCanvas(true);
        }
        this.rowSashes = this.createSashes(rows, this.rowSashes, 256);
        this.colSashes = this.createSashes(cols, this.colSashes, 512);
    }

    int getIndex() {
        if (this.frameNode == null) {
            return -1;
        }
        return this.frameNode.getIndex();
    }

    FrameNode getParentFrameNode() {
        if (this.parentFrameView == null || !(this.parentFrameView instanceof FrameViewImpl)) {
            return null;
        }
        return ((FrameViewImpl)this.parentFrameView).getFrameNode();
    }

    void setSubModelManager(SubModelOwner subModelOwner) {
        this.subModelOwner = subModelOwner;
    }

    class HSashPainter
    implements PaintListener {
        HSashPainter() {
        }

        public void paintControl(PaintEvent e) {
            FrameViewImpl.this.paintSash((Sash)e.widget, e.gc, 256);
        }
    }

    class SashHandler
    implements SelectionListener {
        SashHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.detail != 1) {
                e.doit = false;
            }
        }
    }

    class VSashPainter
    implements PaintListener {
        VSashPainter() {
        }

        public void paintControl(PaintEvent e) {
            FrameViewImpl.this.paintSash((Sash)e.widget, e.gc, 512);
        }
    }
}

