/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.design.DesignTimeTagManager;
import com.ibm.etools.webedit.editparts.visualizer.IVisualizerContext;
import com.ibm.etools.webedit.viewer.HTMLViewPartFactoryContributorExtended;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class AbstractHTMLDocumentPartFactory
implements HTMLViewPartFactoryContributorExtended.InitializationData {
    private IDOMModel model;
    private boolean isManagedModel;
    private DesignTimeTagManager designTimeTagManager;
    private IVisualizerContext visualizerContext;
    protected DocumentEditPart editPart;

    public void dispose() {
        this.reset();
        this.designTimeTagManager = null;
    }

    public void setFile(String filename) {
        this.reset();
        this.setupModel(filename);
    }

    public void setURL(URL url) {
        this.reset();
        this.setupModel(url);
    }

    public void setModel(IDOMModel orgmodel) {
        String id;
        this.reset();
        String string = id = orgmodel != null ? orgmodel.getId() : null;
        if (id != null) {
            this.model = (IDOMModel)orgmodel.getModelManager().getExistingModelForRead((IDocument)orgmodel.getStructuredDocument());
            if (this.model != null) {
                this.isManagedModel = true;
            } else {
                this.setupModel(ModelManagerUtil.getBaseLocation((IStructuredModel)orgmodel));
            }
        }
        if (this.model == null) {
            this.model = orgmodel;
            this.isManagedModel = false;
        }
    }

    public void replaceModel(IDOMModel newModel) {
        this.reset();
        this.setModel(newModel);
    }

    public EditPart getViewPart() {
        if (this.editPart != null) {
            return this.editPart;
        }
        this.editPart = this.createDocumentEditPart();
        if (this.editPart == null) {
            this.editPart = this.createDefaultDocumentEditPart();
        }
        return this.editPart;
    }

    protected abstract DocumentEditPart createDocumentEditPart();

    protected abstract DocumentEditPart createDefaultDocumentEditPart();

    public IDOMModel getModel() {
        return this.model;
    }

    public void setDesignTimeTagManager(DesignTimeTagManager designTimeTagManager) {
        this.designTimeTagManager = designTimeTagManager;
    }

    public void setVisualizerContext(IVisualizerContext visualizerContext) {
        this.visualizerContext = visualizerContext;
    }

    protected void setupModel(String id) {
        Path fullIPath = new Path(id);
        IFile file = WebComponent.getFileForLocation((IPath)fullIPath);
        ModelManagerUtil mmu = new ModelManagerUtil(null, null);
        this.model = file != null ? (IDOMModel)mmu.getModelForRead(file) : (IDOMModel)mmu.getModelForRead((IPath)fullIPath);
        if (this.model != null) {
            this.isManagedModel = true;
        }
    }

    protected void setupModel(URL url) {
        ModelManagerUtil mmu = new ModelManagerUtil(null, null);
        this.model = (IDOMModel)mmu.getModelForRead(url);
        if (this.model != null) {
            this.isManagedModel = true;
        }
    }

    protected void releaseModel() {
        if (this.model != null) {
            if (this.isManagedModel) {
                this.model.releaseFromRead();
            }
            this.model = null;
        }
    }

    @Override
    public DesignTimeTagManager getDesignTimeTagManager() {
        return this.designTimeTagManager;
    }

    @Override
    public IVisualizerContext getVisualizerContext() {
        return this.visualizerContext;
    }

    protected void releaseEditParts() {
        if (this.editPart != null) {
            this.editPart.removeNotify();
            this.editPart = null;
        }
    }

    protected void reset() {
        this.releaseEditParts();
        this.releaseModel();
    }
}

