/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer;

import com.ibm.etools.webedit.viewer.HTMLViewerModelContainer;
import com.ibm.etools.webedit.viewer.internal.submodel.ISubModelCollector;
import com.ibm.etools.webedit.viewer.internal.submodel.ISubModelKey;
import com.ibm.etools.webedit.viewer.internal.submodel.SubModelCollectorRegistry;
import com.ibm.etools.webedit.viewer.internal.submodel.SubModelManager;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ModelCollectorsContext {
    private final HTMLViewerModelContainer container;
    private List linkedFileNameList = new ArrayList();
    private List exceptionFileNameList;

    public ModelCollectorsContext(HTMLViewerModelContainer container, List exceptionFileNameList) {
        this.container = container;
        this.exceptionFileNameList = exceptionFileNameList;
    }

    public List collectModels(Object modelId, IDOMModel model) {
        ISubModelCollector[] collector = SubModelCollectorRegistry.getInstance().getCollectors();
        int i = 0;
        while (i < collector.length) {
            ISubModelKey[] keys = collector[i].collectChildTargets(this, model);
            int j = 0;
            while (keys != null && j < keys.length) {
                String filename = collector[i].getChildFileName(this, model, keys[j]);
                Object id = collector[i].getChildId(this, model, keys[j]);
                if (filename != null) {
                    this.register(id, filename, modelId, keys[j]);
                }
                ++j;
            }
            ++i;
        }
        return this.linkedFileNameList;
    }

    public IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    public SubModelManager getSubModelManager() {
        return this.container.getSubModelManager();
    }

    private boolean isStoredFileName(String fileName) {
        return this.linkedFileNameList.contains(fileName) || this.container.isStoredFileName(fileName);
    }

    public void clearList() {
        this.linkedFileNameList.clear();
    }

    private void addToList(Object fileName) {
        this.linkedFileNameList.add(fileName);
    }

    private void removeFromList(Object fileName) {
        if (this.linkedFileNameList.contains(fileName)) {
            this.linkedFileNameList.remove(fileName);
        }
    }

    private boolean isInIgnoreList(Object fileName) {
        return this.exceptionFileNameList != null && this.exceptionFileNameList.contains(fileName);
    }

    private void register(Object modelId, String fileName, Object parentId, ISubModelKey key) {
        ModelManagerUtil mmu;
        if (fileName == null) {
            return;
        }
        Path path = new Path(fileName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)path);
        if (file == null && path.segmentCount() > 1) {
            file = root.getFile((IPath)path);
        }
        if (file == null) {
            return;
        }
        String linkedFileName = null;
        linkedFileName = file.getLocation() != null ? file.getLocation().toString() : path.toString();
        if (this.isInIgnoreList(linkedFileName)) {
            return;
        }
        boolean newStore = false;
        if (!this.isStoredFileName(linkedFileName)) {
            this.addToList(linkedFileName);
            newStore = true;
        }
        String sseId = ModelManagerUtil.calculateSSEModelId(file);
        IStructuredModel managedModel = this.getModelManager().getExistingModelForRead((Object)sseId);
        if (managedModel == null && (managedModel = (mmu = new ModelManagerUtil(null, null)).getModelForRead((IPath)new Path(linkedFileName))) == null) {
            return;
        }
        if (managedModel != null && !managedModel.isNew() && file != null && !file.exists()) {
            managedModel.releaseFromEdit();
            return;
        }
        if (!ModelManagerUtil.isHTMLFamily(managedModel)) {
            managedModel.releaseFromRead();
            this.removeFromList(linkedFileName);
            return;
        }
        if (this.container.isManagedModel(modelId)) {
            managedModel.releaseFromRead();
            if (newStore) {
                this.collectModels(modelId, (IDOMModel)managedModel);
            }
        } else {
            this.container.manageSingleModel(modelId, (IDOMModel)managedModel);
            this.collectModels(modelId, (IDOMModel)managedModel);
        }
    }
}

