/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer;

import com.ibm.etools.webedit.frame.FrameLayoutNode;
import com.ibm.etools.webedit.frame.FrameLayouter;
import com.ibm.etools.webedit.frame.FrameLayouterImpl;
import com.ibm.etools.webedit.frame.FrameManager;
import com.ibm.etools.webedit.frame.FrameNode;
import com.ibm.etools.webedit.frame.FramePageNode;
import com.ibm.etools.webedit.frame.FrameView;
import com.ibm.etools.webedit.viewer.HTMLViewPane;
import com.ibm.etools.webedit.viewer.HTMLViewerController;
import com.ibm.etools.webedit.viewer.HTMLViewerModelContainer;
import com.ibm.etools.webedit.viewer.HTMLViewerSubModelManager;
import com.ibm.etools.webedit.viewer.internal.FrameViewFactoryImpl;
import com.ibm.etools.webedit.viewer.internal.FrameViewImpl;
import com.ibm.etools.webedit.viewer.internal.HTMLViewPaneImpl;
import com.ibm.etools.webedit.viewer.internal.frame.FrameViewOwner;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class HTMLViewer {
    private FrameLayouter frameLayouter;
    private FrameViewOwner frameViewOwner = new FrameViewManager();
    private FrameViewImpl activeView;
    private HTMLViewPaneImpl viewer;
    private Canvas normalCanvas;
    private Canvas frameCanvas;
    private Composite topCanvas;
    private HTMLViewerController controller;
    private String clientName;
    private HTMLViewerModelContainer viewModelManager;
    private HTMLViewerSubModelManager subModelManager;

    public HTMLViewer(String clientName) {
        this.clientName = clientName;
    }

    public HTMLViewer(Composite parent, HTMLViewerController controller, String clientName) {
        this(clientName);
        this.init(parent, controller);
    }

    public void init(Composite parent, HTMLViewerController control) {
        this.init(parent, control, false);
    }

    public void init(Composite parent, HTMLViewerController control, boolean manageSubModel) {
        if (manageSubModel) {
            this.subModelManager = new HTMLViewerSubModelManager(this);
        }
        this.viewModelManager = new HTMLViewerModelContainer(this.subModelManager);
        this.topCanvas = new Canvas(parent, 0);
        this.viewer = new HTMLViewPaneImpl(this.clientName);
        this.normalCanvas = (Canvas)this.viewer.createControl(this.topCanvas);
        this.viewer.setViewerController(control);
        this.viewer.setSubModelOwner(this.subModelManager);
        StackLayout stackLayout = new StackLayout();
        this.topCanvas.setLayout((Layout)stackLayout);
        stackLayout.topControl = this.normalCanvas;
        this.frameCanvas = new Canvas(this.topCanvas, 0);
        this.frameLayouter = new FrameLayouterImpl();
        this.frameLayouter.setBounds(this.topCanvas.getBounds());
        this.frameLayouter.setViewFactory(new FrameViewFactoryImpl(this.frameCanvas, this.frameViewOwner, control, this.subModelManager));
        this.frameCanvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Control c = (Control)e.widget;
                Rectangle rect = c.getBounds();
                rect.y = 0;
                rect.x = 0;
                HTMLViewer.this.frameLayouter.setBounds(rect);
            }
        });
        this.controller = control;
        if (control != null) {
            control.initialize();
        }
        if (this.subModelManager != null) {
            this.subModelManager.activate(true);
        }
    }

    public void dispose() {
        if (this.controller != null) {
            this.controller.dispose();
            this.controller = null;
        }
        if (this.viewer != null) {
            this.viewer.setModel(null);
            Control control = this.viewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.dispose();
            }
            this.viewer = null;
        }
        if (this.frameLayouter != null) {
            this.frameLayouter.setModel(null);
            this.frameLayouter = null;
        }
        if (this.viewModelManager != null) {
            this.viewModelManager.dispose();
            this.viewModelManager = null;
        }
        if (this.subModelManager != null) {
            this.subModelManager.dispose();
            this.subModelManager = null;
        }
    }

    public Control getControl() {
        return this.topCanvas;
    }

    public void setFile(String filename) {
        Path fullIPath = new Path(filename);
        IFile file = WebComponent.getFileForLocation((IPath)fullIPath);
        ModelManagerUtil mmu = new ModelManagerUtil(null, null);
        IDOMModel newModel = null;
        newModel = file != null ? (IDOMModel)mmu.getModelForRead(file) : (IDOMModel)mmu.getModelForRead((IPath)fullIPath);
        this.setModel(newModel, filename);
        if (newModel != null) {
            newModel.releaseFromRead();
        }
    }

    public IDOMModel getModel() {
        return this.viewModelManager != null ? this.viewModelManager.getTopModel() : null;
    }

    public void setModel(IDOMModel model, String filename) {
        if (this.viewer != null) {
            this.viewer.setModel(model);
        }
        if (this.frameLayouter != null) {
            this.frameLayouter.setModel(model);
            this.updateFrameView();
        } else {
            Control ctrl = this.viewer.getControl();
            if (!ctrl.isDisposed()) {
                ctrl.setFocus();
            }
        }
        this.viewModelManager.setTopModel(model, filename);
    }

    public FrameManager getFrameManager() {
        if (this.frameLayouter == null) {
            return null;
        }
        return this.frameLayouter.getFrameManager();
    }

    public boolean isFrame() {
        if (this.frameLayouter == null) {
            return false;
        }
        FrameManager fm = this.frameLayouter.getFrameManager();
        return fm.isFrame();
    }

    public HTMLViewPane getActiveViewPane() {
        if (!this.isFrame()) {
            return this.viewer;
        }
        if (this.activeView != null) {
            return this.activeView.getViewer();
        }
        return null;
    }

    private void updateFrameView() {
        FrameLayoutNode fln = this.frameLayouter.getTopLayoutNode();
        if (fln != null) {
            this.setActive(fln, true);
        }
        this.setActiveCanvas(fln == null);
    }

    private boolean setActive(FrameLayoutNode frameNode, boolean excludeFrameSet) {
        FrameLayoutNode[] childs;
        FrameView view = frameNode.getView();
        if (view instanceof FrameViewImpl) {
            Canvas control;
            FrameViewImpl v = (FrameViewImpl)view;
            HTMLViewPaneImpl hv = v.getViewer();
            if (hv != null) {
                Control ctrl = hv.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.setFocus();
                }
                return true;
            }
            FrameNode node = frameNode.getFrameNode();
            if (!(excludeFrameSet && node != null && node.hasChildren() || (control = v.getCanvas()) == null)) {
                control.setFocus();
                return true;
            }
        }
        if ((childs = frameNode.getChildPanes()) != null) {
            int i = 0;
            while (i < childs.length) {
                if (this.setActive(childs[i], excludeFrameSet)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void setActiveCanvas(boolean noframe) {
        if (this.topCanvas == null || this.topCanvas.isDisposed()) {
            return;
        }
        Layout l = this.topCanvas.getLayout();
        if (!(l instanceof StackLayout)) {
            return;
        }
        StackLayout sl = (StackLayout)l;
        sl.topControl = noframe ? this.normalCanvas : this.frameCanvas;
        this.topCanvas.layout();
    }

    private void internalSetActiveFrame(FrameView view) {
        if (this.activeView == view) {
            return;
        }
        this.activeView = null;
        if (view instanceof FrameViewImpl) {
            this.activeView = (FrameViewImpl)view;
        }
        if (this.activeView == null) {
            return;
        }
        FrameNode activeFrame = this.activeView.getFrameNode();
        if (activeFrame == null || activeFrame.getType() != 2) {
            return;
        }
        IDOMModel activeModel = ((FramePageNode)activeFrame).getModel();
        if (activeModel == null) {
            return;
        }
    }

    public void navigate(boolean next) {
        if (!this.isFrame() || this.activeView == null) {
            return;
        }
        FrameNode fnode = this.activeView.getFrameNode();
        FrameManager fm = this.getFrameManager();
        if (fm == null) {
            return;
        }
        FramePageNode nextNode = fm.findNext(fnode, next);
        if (nextNode == null) {
            return;
        }
        FrameLayoutNode fln = this.frameLayouter.find(nextNode);
        if (fln == null) {
            return;
        }
        this.setActive(fln, false);
    }

    public EditPartViewer[] getAllViewers(boolean frameOnly) {
        FrameView[] views;
        ArrayList<HTMLViewPaneImpl> wysiwygviews = new ArrayList<HTMLViewPaneImpl>();
        if (this.frameLayouter != null && (views = this.frameLayouter.getAllViews()) != null) {
            int i = views.length - 1;
            while (i >= 0) {
                FrameViewImpl fvi = (FrameViewImpl)views[i];
                HTMLViewPaneImpl v = fvi.getViewer();
                if (v != null) {
                    wysiwygviews.add(0, v);
                }
                --i;
            }
        }
        if (this.viewer != null && !frameOnly) {
            wysiwygviews.add(this.viewer);
        }
        if (wysiwygviews.size() > 0) {
            return wysiwygviews.toArray(new EditPartViewer[wysiwygviews.size()]);
        }
        return null;
    }

    HTMLViewerModelContainer getHTMLViewerModelManager() {
        return this.viewModelManager;
    }

    class FrameViewManager
    implements FrameViewOwner {
        FrameViewManager() {
        }

        @Override
        public void setActiveFrame(FrameView view) {
            HTMLViewer.this.internalSetActiveFrame(view);
        }

        @Override
        public void frameDisposed(FrameView view) {
            if (HTMLViewer.this.activeView == view) {
                HTMLViewer.this.activeView = null;
            }
        }
    }
}

