/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.style.extended;

import com.ibm.etools.xve.renderer.style.CSSFont;
import com.ibm.etools.xve.renderer.style.ColorPool;
import com.ibm.etools.xve.renderer.style.Length;
import com.ibm.etools.xve.renderer.style.RenderOption;
import com.ibm.etools.xve.renderer.style.html.HTMLStyleImpl;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class WMLStyleSELECT
extends HTMLStyleImpl {
    private static final Length ZERO_PIXEL = new Length(0.0f, 0);
    private static final Length wml_border_width = new Length(1.0f, 0);
    private static final Length default_vpadding = new Length(1.0f, 0);
    private boolean fMultiple = false;
    private String fIValue;
    private Color systemFg = null;
    private Color systemBg = null;
    private Color systemBorder = null;

    public void dispose() {
        ColorPool.getInstance().releaseColor(this.systemFg);
        ColorPool.getInstance().releaseColor(this.systemBg);
        ColorPool.getInstance().releaseColor(this.systemBorder);
        this.systemFg = null;
        this.systemBg = null;
        this.systemBorder = null;
        super.dispose();
    }

    protected int doUpdateAttr(boolean force) {
        int result = 0;
        Element element = this.getDomElement();
        if (element == null) {
            return result;
        }
        boolean oldValue = this.fMultiple;
        Attr mul = element.getAttributeNode("multiple");
        this.fMultiple = mul != null ? "true".equals(mul.getValue()) : false;
        if (oldValue != this.fMultiple) {
            result |= 0x12;
        }
        String oldIValue = this.fIValue;
        Attr ivalue = element.getAttributeNode("ivalue");
        this.fIValue = ivalue != null ? ivalue.getValue() : null;
        if (oldIValue != this.fIValue && this.fMultiple) {
            result |= 0x10;
        }
        return result;
    }

    protected int getBorderStyleByDefault(int prop) {
        return 8;
    }

    protected Color getColorByDefault(int prop) {
        Color c = null;
        switch (prop) {
            case 10: {
                c = ColorPool.getInstance().getDefaultColor(0);
                ColorPool.getInstance().releaseColor(this.systemFg);
                this.systemFg = c;
                break;
            }
            case 12: {
                c = ColorPool.getInstance().getDefaultColor(1);
                ColorPool.getInstance().releaseColor(this.systemBg);
                this.systemBg = c;
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                c = ColorPool.getInstance().getDefaultColor(5);
                ColorPool.getInstance().releaseColor(this.systemBorder);
                this.systemBorder = c;
            }
        }
        return c;
    }

    protected Length getLengthByDefault(int prop) {
        Length len = null;
        switch (prop) {
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                len = wml_border_width;
                break;
            }
            case 27: {
                len = default_vpadding;
                break;
            }
            case 28: {
                break;
            }
            case 31: {
                len = new Length(100.0f, 1);
            }
        }
        return len;
    }

    protected int getUITypeFromElement(int prop) {
        int i = 12345678;
        switch (prop) {
            case 110: {
                i = 49;
                break;
            }
            case 103: 
            case 191: {
                break;
            }
            case 193: {
                if (!this.fMultiple) break;
                i = 1;
            }
        }
        return i;
    }

    protected String getTextFromElement(int prop) {
        switch (prop) {
            case 100: {
                Element element = this.getDomElement();
                if (element == null) {
                    return null;
                }
                Attr ivalue = element.getAttributeNode("ivalue");
                return ivalue != null ? ivalue.getValue() : null;
            }
        }
        return super.getTextFromElement(prop);
    }

    protected int getDisplayTypeByDefault() {
        return 23;
    }

    public CSSFont createFont(CSSFont feed, boolean ignore_size, int mode) {
        CSSFont f = this.getSystemCSSFont();
        return super.createFont(feed, ignore_size, mode);
    }

    protected int getAlignByDefault(int prop) {
        int i = 12345678;
        switch (prop) {
            case 71: {
                break;
            }
            case 70: {
                i = 11;
            }
        }
        return i;
    }

    protected int getWhiteSpaceByDefault() {
        return 2;
    }

    protected final void doIgnoreStyle() {
        RenderOption vo = this.getRenderOption();
        if (vo != null && vo.getRenderingOption() == 0 && this.cssStyle != null) {
            this.cssStyle.setLength(20, ZERO_PIXEL);
            this.cssStyle.setLength(39, ZERO_PIXEL);
            this.cssStyle.setBorderStyle(50, 12345678);
            this.cssStyle.setBorderStyle(51, 12345678);
            this.cssStyle.setBorderStyle(52, 12345678);
            this.cssStyle.setBorderStyle(53, 12345678);
            this.cssStyle.setLength(50, null);
            this.cssStyle.setLength(51, null);
            this.cssStyle.setLength(52, null);
            this.cssStyle.setLength(53, null);
            this.cssStyle.setColor(50, null);
            this.cssStyle.setColor(51, null);
            this.cssStyle.setColor(52, null);
            this.cssStyle.setColor(53, null);
            this.cssStyle.setLength(27, null);
            this.cssStyle.setLength(28, null);
            this.cssStyle.setLength(29, null);
            this.cssStyle.setLength(30, null);
            this.cssStyle.setAlign(71, 1);
            this.cssStyle.setUri(12, null);
        }
    }
}

