/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.style.extended;

import com.ibm.etools.webedit.render.internal.style.HTMLStyleOwner;
import com.ibm.etools.webedit.render.internal.style.extended.ViewOptionUtil;
import com.ibm.etools.xve.renderer.style.CSSFont;
import com.ibm.etools.xve.renderer.style.ColorPool;
import com.ibm.etools.xve.renderer.style.ImageObject;
import com.ibm.etools.xve.renderer.style.ImageObjectFactory;
import com.ibm.etools.xve.renderer.style.ImageObjectUtil;
import com.ibm.etools.xve.renderer.style.Length;
import com.ibm.etools.xve.renderer.style.RenderOption;
import com.ibm.etools.xve.renderer.style.StyleOwner;
import com.ibm.etools.xve.renderer.style.XMLStyle;
import com.ibm.etools.xve.renderer.style.html.HTMLStyleImpl;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Element;

public final class HTMLStyleTABLE
extends HTMLStyleImpl {
    private static final Length cellspacing = new Length(2.0f, 0);
    private static final Length defaultPosX = new Length(0.0f, 1);
    private static final Length defaultPosY = new Length(0.0f, 1);
    private static final Length default_padding_width = new Length(1.0f, 0);
    private static final Length default_spacing_width = new Length(2.0f, 0);
    private Color fBGColor = null;
    private Color borderColor = null;
    private Color flmBorderColor = null;
    private Color flmGridColor = null;
    private int flmGridStep;
    private Length fWidth = null;
    private Length fHeight = null;
    private Length fCellSpacing = null;
    private Length fCellPadding = null;
    private Length fBorderWidth = null;
    private int fAlign = 12345678;
    private int fOwnAlign = 12345678;
    private String url;
    private ImageObject object = null;
    private Color systemBorder = null;
    private Color bodyColor = null;
    private boolean isLayoutTable = false;

    public void dispose() {
        ColorPool.getInstance().releaseColor(this.systemBorder);
        ColorPool.getInstance().releaseColor(this.fBGColor);
        ColorPool.getInstance().releaseColor(this.borderColor);
        ColorPool.getInstance().releaseColor(this.bodyColor);
        ColorPool.getInstance().releaseColor(this.flmBorderColor);
        ColorPool.getInstance().releaseColor(this.flmGridColor);
        this.systemBorder = null;
        this.fBGColor = null;
        this.borderColor = null;
        this.flmBorderColor = null;
        this.flmGridColor = null;
        if (this.object != null) {
            this.object.releaseRef();
            this.object = null;
        }
        super.dispose();
    }

    protected int doUpdateFreeLayout() {
        RenderOption vo;
        int result = 0;
        StyleOwner owner = this.getStyleOwner();
        if (owner != null) {
            boolean freelayoutTable;
            boolean bl = freelayoutTable = owner instanceof HTMLStyleOwner && ((HTMLStyleOwner)owner).isLayoutTable();
            if (this.isLayoutTable != freelayoutTable) {
                this.isLayoutTable = freelayoutTable;
                result |= 8;
            }
        }
        if ((vo = this.getRenderOption()) != null) {
            int step;
            RGB rgb = ViewOptionUtil.getColor(vo, 1);
            if (this.flmBorderColor == null) {
                if (rgb != null) {
                    this.flmBorderColor = ColorPool.getInstance().createColor(rgb.red, rgb.green, rgb.blue);
                    result |= 2;
                }
            } else if (rgb != null) {
                if (!rgb.equals((Object)this.flmBorderColor.getRGB())) {
                    ColorPool.getInstance().releaseColor(this.flmBorderColor);
                    this.flmBorderColor = ColorPool.getInstance().createColor(rgb.red, rgb.green, rgb.blue);
                    result |= 2;
                }
            } else {
                ColorPool.getInstance().releaseColor(this.flmBorderColor);
                this.flmBorderColor = null;
                result |= 2;
            }
            rgb = ViewOptionUtil.getColor(vo, 3);
            if (this.flmGridColor == null) {
                if (rgb != null) {
                    this.flmGridColor = ColorPool.getInstance().createColor(rgb.red, rgb.green, rgb.blue);
                    result |= 2;
                }
            } else if (rgb != null) {
                if (!rgb.equals((Object)this.flmGridColor.getRGB())) {
                    ColorPool.getInstance().releaseColor(this.flmGridColor);
                    this.flmGridColor = ColorPool.getInstance().createColor(rgb.red, rgb.green, rgb.blue);
                    result |= 2;
                }
            } else {
                ColorPool.getInstance().releaseColor(this.flmGridColor);
                this.flmGridColor = null;
                result |= 2;
            }
            if ((step = ViewOptionUtil.getFreeLayoutGridInterval(vo)) != this.flmGridStep) {
                this.flmGridStep = step;
                result |= 2;
            }
        }
        return result;
    }

    protected int doUpdateAttr(boolean refresh) {
        XMLStyle rootStyle;
        int result = 0;
        Element element = this.getDomElement();
        if (element == null) {
            return result;
        }
        result |= this.doUpdateBidi(element);
        result |= this.doUpdateFreeLayout();
        Color oldColor = this.fBGColor;
        String attr = element.getAttribute("bgcolor");
        this.fBGColor = attr != null && attr.length() > 0 ? ColorPool.getInstance().createColor(attr, false) : null;
        if (oldColor != this.fBGColor) {
            result |= 2;
        }
        ColorPool.getInstance().releaseColor(oldColor);
        oldColor = null;
        RenderOption vo = this.getRenderOption();
        if (vo != null && vo.getRenderingOption() == 0) {
            oldColor = this.borderColor;
            attr = element.getAttribute("borderColor");
            this.borderColor = attr != null && attr.length() > 0 ? ColorPool.getInstance().createColor(attr, false) : null;
            if (oldColor != this.borderColor) {
                result |= 8;
            }
            ColorPool.getInstance().releaseColor(oldColor);
            oldColor = null;
        }
        Length oldLength = this.fWidth;
        attr = element.getAttribute("width");
        this.fWidth = attr != null && attr.length() > 0 ? new Length(attr, 0) : null;
        if (oldLength == null) {
            if (this.fWidth != null) {
                result |= 1;
            }
        } else if (!oldLength.equals((Object)this.fWidth)) {
            result |= 1;
        }
        oldLength = this.fHeight;
        attr = element.getAttribute("height");
        this.fHeight = attr != null && attr.length() > 0 ? new Length(attr, 0) : null;
        if (oldLength == null) {
            if (this.fHeight != null) {
                result |= 1;
            }
        } else if (!oldLength.equals((Object)this.fHeight)) {
            result |= 1;
        }
        oldLength = this.fCellSpacing;
        attr = element.getAttribute("cellspacing");
        this.fCellSpacing = attr != null && attr.length() > 0 ? new Length(attr, 0) : null;
        if (oldLength == null) {
            if (this.fCellSpacing != null) {
                result |= 0x10;
            }
        } else if (!oldLength.equals((Object)this.fCellSpacing)) {
            result |= 0x10;
        }
        oldLength = this.fCellPadding;
        attr = element.getAttribute("cellpadding");
        this.fCellPadding = attr != null && attr.length() > 0 ? new Length(attr, 0) : null;
        if (oldLength == null) {
            if (this.fCellPadding != null) {
                result |= 8;
            }
        } else if (!oldLength.equals((Object)this.fCellPadding)) {
            result |= 8;
        }
        oldLength = this.fBorderWidth;
        attr = element.getAttribute("border");
        if (attr != null) {
            if (attr.length() > 0) {
                this.fBorderWidth = new Length(attr, 1.0f, 0);
                if (this.fBorderWidth.value < 0.0f) {
                    this.fBorderWidth.value = vo != null && vo.getRenderingOption() == 0 ? 1.0f : 0.0f;
                }
            } else {
                this.fBorderWidth = new Length(1.0f, 0);
            }
        } else {
            this.fBorderWidth = null;
        }
        if (oldLength == null) {
            if (this.fBorderWidth != null) {
                result |= 8;
            }
        } else if (!oldLength.equals((Object)this.fBorderWidth)) {
            result |= 8;
        }
        int ownAlign = this.fOwnAlign;
        int oldValue = this.fAlign;
        attr = element.getAttribute("align");
        if (attr != null && attr.length() > 0) {
            if (attr.equalsIgnoreCase("left")) {
                this.fAlign = 1;
                this.fOwnAlign = 12345678;
            } else if (attr.equalsIgnoreCase("center")) {
                this.fAlign = 12345678;
                this.fOwnAlign = 3;
            } else if (attr.equalsIgnoreCase("right")) {
                this.fAlign = 2;
                this.fOwnAlign = 12345678;
            } else {
                this.fAlign = 12345678;
                this.fOwnAlign = 12345678;
            }
        } else {
            this.fAlign = 12345678;
            this.fOwnAlign = 12345678;
        }
        if (oldValue != this.fAlign || ownAlign != this.fOwnAlign) {
            result |= 1;
        }
        String oldString = this.url;
        this.url = element.getAttribute("background");
        if (oldString == null) {
            if (this.url != null) {
                result |= 1;
            }
        } else if (refresh || !oldString.equals(this.url)) {
            if (this.object != null) {
                this.object.releaseRef();
                this.object = null;
            }
            result |= 1;
        }
        if ((rootStyle = this.getRootStyle()) != null) {
            Color c = ColorPool.getInstance().cloneColor(rootStyle.getColor(10));
            if (this.bodyColor != c) {
                result |= 2;
            }
            ColorPool.getInstance().releaseColor(this.bodyColor);
            this.bodyColor = c;
        } else {
            ColorPool.getInstance().releaseColor(this.bodyColor);
            this.bodyColor = null;
        }
        return result;
    }

    protected int getAlignFromElement(int prop) {
        int align = 12345678;
        switch (prop) {
            case 71: {
                break;
            }
            case 70: {
                break;
            }
            case 74: {
                align = this.fOwnAlign;
                break;
            }
        }
        return align;
    }

    protected int getBorderStyleByDefault(int prop) {
        if (this.fBorderWidth == null) {
            if (this.isLayoutTable) {
                return 1;
            }
            return this.extraBorderType;
        }
        if (this.borderColor != null && this.cssStyle != null && this.cssStyle.getColor(prop) == null) {
            return 2;
        }
        return 5;
    }

    final Length getCellPadding() {
        return this.fCellPadding == null ? default_padding_width : this.fCellPadding;
    }

    final Length getCellSpacing() {
        return this.fCellSpacing == null ? default_spacing_width : this.fCellSpacing;
    }

    final boolean isLayoutTable() {
        return this.isLayoutTable;
    }

    final Length getBorderAttribute() {
        return this.fBorderWidth;
    }

    final Color getBorderColor() {
        return this.borderColor;
    }

    protected Color getColorFromElement(int prop) {
        switch (prop) {
            case 12: {
                return this.fBGColor;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                if (this.fBorderWidth == null) break;
                return this.borderColor;
            }
        }
        return null;
    }

    protected Color getColorByDefault(int prop) {
        switch (prop) {
            case 10: {
                return this.bodyColor;
            }
            case 230: {
                if (!this.isLayoutTable) break;
                return this.flmBorderColor;
            }
            case 231: {
                break;
            }
            case 240: {
                if (!this.isLayoutTable) break;
                return this.flmGridColor;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                if (this.fBorderWidth == null) {
                    return this.extraBorderColor;
                }
                Color c = ColorPool.getInstance().getDefaultColor(5);
                ColorPool.getInstance().releaseColor(this.systemBorder);
                this.systemBorder = c;
                return c;
            }
        }
        return null;
    }

    protected int getDisplayTypeByDefault() {
        return 4;
    }

    protected Image getImageFromElement(int prop) {
        Image image = null;
        switch (prop) {
            case 12: {
                if (this.object == null) {
                    Element element = this.getDomElement();
                    String tagName = element.getTagName();
                    this.object = ImageObjectUtil.getImageObject((ImageObjectFactory)this.getObjectFactory(), (StyleOwner)this.getStyleOwner(), (String)this.url, (String)tagName, (String)"background");
                    if (this.object == null) {
                        return null;
                    }
                    this.object.addRef();
                }
                image = this.object.getStaticImage();
                break;
            }
        }
        return image;
    }

    protected int getIntegerFromElement(int prop) {
        int i = 12345678;
        switch (prop) {
            case 240: {
                i = this.flmGridStep;
                break;
            }
            default: {
                i = super.getIntegerFromElement(prop);
            }
        }
        return i;
    }

    protected Length getLengthFromElement(int prop) {
        Length len = null;
        switch (prop) {
            case 31: {
                len = this.fWidth;
                break;
            }
            case 32: {
                len = this.fHeight;
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                len = this.fBorderWidth;
                break;
            }
            case 43: {
                len = this.fCellSpacing;
            }
        }
        return len;
    }

    protected Length getLengthByDefault(int prop) {
        Length len = null;
        switch (prop) {
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                len = this.extraBorderWidth;
                break;
            }
            case 43: {
                len = cellspacing;
                break;
            }
            case 21: {
                len = defaultPosX;
                break;
            }
            case 22: {
                len = defaultPosY;
            }
        }
        return len;
    }

    protected int getPositionTypeFromElement() {
        int pos = 12345678;
        switch (this.fAlign) {
            case 1: {
                pos = 5;
                break;
            }
            case 2: {
                pos = 6;
            }
        }
        return pos;
    }

    protected int getTypeByDefault(int prop) {
        int type = 12345678;
        switch (prop) {
            case 130: {
                type = 1;
                break;
            }
            case 131: {
                type = 1;
                break;
            }
        }
        return type;
    }

    protected int doUpdateExtraBorder(boolean force) {
        int result = 0;
        int newType = 12345678;
        Color newColor = null;
        Length newWidth = null;
        RenderOption option = this.getRenderOption();
        if (option != null && (!option.isExtraBorder(10) || this.getMaskType() != 2) && option.isExtraBorder(0)) {
            newType = 15;
            newWidth = new Length(0.0f, 0);
            newColor = this.getExtraBorderColor();
        }
        if (this.extraBorderType != newType) {
            this.extraBorderType = newType;
            result |= 2;
        }
        if (!this.isSameColor(this.extraBorderColor, newColor)) {
            this.extraBorderColor = newColor;
            result |= 2;
        }
        if (!this.isSameLength(this.extraBorderWidth, newWidth)) {
            this.extraBorderWidth = newWidth;
            result |= 1;
        }
        return result;
    }

    public CSSFont createFont(CSSFont feed, boolean ignore_size, int mode) {
        CSSFont cssFont;
        String family = null;
        XMLStyle pstyle = this.getParentStyle();
        if (pstyle != null && (cssFont = pstyle.getCSSFont()) != null) {
            family = cssFont.getFamily();
        }
        return this.createFont(feed, family, 12345678, null, null, false, mode);
    }

    protected final void doIgnoreStyle() {
        RenderOption vo = this.getRenderOption();
        if (vo != null && vo.getRenderingOption() == 0 && this.cssStyle != null) {
            this.cssStyle.setLength(27, null);
            this.cssStyle.setLength(28, null);
            this.cssStyle.setLength(29, null);
            this.cssStyle.setLength(30, null);
        }
    }

    public boolean showVisualCue(int prop) {
        boolean show = false;
        try {
            switch (prop) {
                case 230: {
                    show = this.isLayoutTable && ViewOptionUtil.isVisualCue(this.getRenderOption(), 1);
                    break;
                }
                case 231: {
                    break;
                }
                case 240: {
                    show = this.isLayoutTable && ViewOptionUtil.isVisualCue(this.getRenderOption(), 3);
                    break;
                }
                case 260: {
                    if (this.getRenderOption() != null && this.getRenderOption().showIcon(6)) {
                        show = false;
                        break;
                    }
                    show = !this.isLayoutTable;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            show = false;
        }
        return show;
    }

    public boolean isEditMode() {
        if (this.isLayoutTable) {
            return false;
        }
        return super.isEditMode();
    }
}

