/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.layout;

import com.ibm.etools.webedit.render.internal.layout.IWmlListBoxContext;
import com.ibm.etools.webedit.render.internal.layout.IWmlListBoxItem;
import com.ibm.etools.xve.renderer.figures.IElementFigure;
import com.ibm.etools.xve.renderer.figures.IFlowFigure;
import com.ibm.etools.xve.renderer.internal.figures.FlowUtilities;
import com.ibm.etools.xve.renderer.internal.figures.LengthUtil;
import com.ibm.etools.xve.renderer.layout.html.BlockFlowLayout;
import com.ibm.etools.xve.renderer.style.Length;
import com.ibm.etools.xve.renderer.style.XMLStyle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.graphics.Font;

public class WMLListBoxItemLayout
extends BlockFlowLayout
implements IWmlListBoxItem {
    private int labelWidth;
    private boolean fMultiple;
    private boolean isRadioButton;
    int index;

    @Override
    public int getListBoxItemCount(IFigure figure) {
        return 1;
    }

    protected void setupBlock() {
        super.setupBlock();
        XMLStyle style = (XMLStyle)this.flowFigure.getStyle();
        if (style == null) {
            return;
        }
        XMLStyle parentStyle = style.getParentStyle();
        while (parentStyle != null) {
            if (parentStyle.getUIType(193) == 1) {
                this.fMultiple = true;
                return;
            }
            parentStyle = parentStyle.getParentStyle();
        }
        this.fMultiple = false;
        IFigure parent = this.flowFigure.getParent();
        LayoutManager layout = parent.getLayoutManager();
        if (layout instanceof IWmlListBoxContext) {
            if (this.isRadioButton) {
                this.index = this.flowFigure != null ? ((IWmlListBoxContext)layout).getListBoxItemIndexOf(this.flowFigure) : -1;
                return;
            }
            this.labelWidth = ((IWmlListBoxContext)layout).getRecommendedBulletPointSize();
            if (this.labelWidth != -1) {
                Length offset = style.getLength(37);
                int spacing = LengthUtil.getLengthByPixel((int)37, (int)0, (int)0, (Length)offset, null);
                this.labelWidth += spacing;
                this.blockBox.setRecommendedX(this.blockBox.x + this.labelWidth);
                this.blockBox.setRecommendedWidth(this.blockBox.getInnerWidth() - this.labelWidth);
            }
        }
    }

    @Override
    public int getBulletPointSize(IFigure figure) {
        this.index = -1;
        IFigure parent = figure.getParent();
        LayoutManager layout = parent.getLayoutManager();
        if (layout instanceof IWmlListBoxContext) {
            this.index = ((IWmlListBoxContext)layout).getListBoxItemIndexOf((IFlowFigure)figure);
            return FlowUtilities.getStringWidth((String)String.valueOf(this.index), (Font)figure.getFont());
        }
        return this.index;
    }

    protected int getLabelWidth() {
        if (!this.fMultiple) {
            return this.labelWidth;
        }
        return 0;
    }

    protected final boolean checkLayout() {
        return true;
    }

    protected final void endBlock() {
        IElementFigure cssFigure;
        IWmlListBoxContext lbContext;
        try {
            lbContext = (IWmlListBoxContext)this.context.getListBoxContext();
        }
        catch (NullPointerException nullPointerException) {
            lbContext = null;
        }
        catch (ClassCastException classCastException) {
            lbContext = null;
        }
        if (lbContext != null) {
            lbContext.addListBoxItem(this);
        }
        try {
            cssFigure = (IElementFigure)this.flowFigure;
        }
        catch (ClassCastException classCastException) {
            cssFigure = null;
        }
        if (cssFigure != null) {
            LayoutManager layout;
            IElementFigure parent = null;
            try {
                parent = (IElementFigure)cssFigure.getParent();
            }
            catch (ClassCastException classCastException) {
                parent = null;
            }
            if (parent != null && (layout = parent.getLayoutManager()) instanceof IWmlListBoxContext && ((IWmlListBoxContext)layout).askSelected(this.index)) {
                lbContext.requestSelectedOption(this);
            }
            cssFigure.setSelectedOption(false);
        }
        super.endBlock();
    }

    public void expandListBoxItem(int width) {
        if (this.blockBox != null) {
            this.blockBox.width = width;
        }
    }

    public void setInversed() {
        IElementFigure cssFigure;
        try {
            cssFigure = (IElementFigure)this.flowFigure;
        }
        catch (ClassCastException classCastException) {
            cssFigure = null;
        }
        if (cssFigure != null) {
            cssFigure.setInversed(true);
        }
    }

    @Override
    public void setSelectedOption(boolean preSelected) {
        IElementFigure cssFigure;
        try {
            cssFigure = (IElementFigure)this.flowFigure;
        }
        catch (ClassCastException classCastException) {
            cssFigure = null;
        }
        if (cssFigure != null) {
            cssFigure.setSelectedOption(preSelected);
        }
    }
}

