/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.layout;

import com.ibm.etools.webedit.render.internal.figures.CssScrollingFigure;
import com.ibm.etools.xve.renderer.layout.box.LayoutBox;
import com.ibm.etools.xve.renderer.layout.html.ObjectLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class WMLCardLayout
extends ObjectLayout {
    private Dimension minimumSize = null;
    private Dimension cachedPreferredHint = new Dimension(-1, -1);
    private Dimension cachedMinimumHint = new Dimension(-1, -1);
    int tabHeight = 30;

    public Dimension getMinimumSize(IFigure container, int w, int h) {
        boolean flush = this.cachedMinimumHint.width != w && this.isSensitiveHorizontally(container);
        if (flush |= this.cachedMinimumHint.height != h && this.isSensitiveVertically(container)) {
            this.minimumSize = null;
            this.cachedMinimumHint.width = w;
            this.cachedMinimumHint.height = h;
        }
        if (this.minimumSize == null) {
            this.minimumSize = this.calculateMinimumSize(container, w, h);
        }
        return this.minimumSize;
    }

    public final Dimension getPreferredSize(IFigure container, int w, int h) {
        boolean flush = this.cachedPreferredHint.width != w && this.isSensitiveHorizontally(container);
        if (flush |= this.cachedPreferredHint.height != h && this.isSensitiveVertically(container)) {
            this.preferredSize = null;
            this.cachedPreferredHint.width = w;
            this.cachedPreferredHint.height = h;
        }
        return super.getPreferredSize(container, w, h);
    }

    public void invalidate() {
        this.minimumSize = null;
        super.invalidate();
    }

    protected boolean isSensitiveHorizontally(IFigure container) {
        return true;
    }

    protected boolean isSensitiveVertically(IFigure container) {
        return true;
    }

    public Dimension calculateMinimumSize(IFigure figure, int w, int h) {
        Dimension d = this.flowFigure.getMinimumSize();
        return d.getExpanded(this.flowFigure.getInsets().getWidth(), this.flowFigure.getInsets().getHeight());
    }

    public Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        if (!(this.flowFigure instanceof CssScrollingFigure)) {
            return super.calculatePreferredSize(container, wHint, hHint);
        }
        Insets insets = this.flowFigure.getInsets();
        int reservedWidth = insets.getWidth() + this.getVScrollWidth();
        int reservedHeight = insets.getHeight() + this.getHScrollHeight();
        if (wHint > -1) {
            wHint = Math.max(0, wHint - reservedWidth);
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - reservedHeight);
        }
        return this.flowFigure.getViewport().getPreferredSize(wHint, hHint).getExpanded(reservedWidth, reservedHeight);
    }

    private int getVScrollWidth() {
        if (!(this.flowFigure instanceof CssScrollingFigure)) {
            return 0;
        }
        CssScrollingFigure fig = (CssScrollingFigure)this.flowFigure;
        ScrollBar vBar = fig.getVerticalScrollBar();
        if (fig.getVerticalScrollBarVisibility() == 0) {
            return 0;
        }
        return vBar.getPreferredSize().width;
    }

    private int getHScrollHeight() {
        if (!(this.flowFigure instanceof CssScrollingFigure)) {
            return 0;
        }
        CssScrollingFigure fig = (CssScrollingFigure)this.flowFigure;
        ScrollBar hBar = fig.getHorizontalScrollBar();
        if (fig.getHorizontalScrollBarVisibility() == 0) {
            return 0;
        }
        return hBar.getPreferredSize().height;
    }

    public void layout(IFigure parent) {
        super.layout(parent);
        if (!(this.flowFigure instanceof CssScrollingFigure)) {
            return;
        }
        CssScrollingFigure fig = (CssScrollingFigure)this.flowFigure;
        LayoutBox rect = this.contentBox;
        Label label = fig.getLabel();
        if (label != null) {
            label.setLocation(rect.getLocation());
            Dimension size = label.getPreferredSize().getCopy();
            if (size.width < 20) {
                size.width = 20;
            }
            if (size.width > rect.width) {
                size.width = rect.width;
            }
            label.setSize(size);
            int labelHeight = label.getBounds().height;
            rect.y += labelHeight;
            rect.height -= labelHeight;
        }
        ScrollBar vBar = fig.getVerticalScrollBar();
        vBar.setBounds(new Rectangle(rect.right() - this.getVScrollWidth(), rect.y, this.getVScrollWidth(), rect.height - this.getHScrollHeight()));
        vBar.invalidate();
        vBar.validate();
        ScrollBar hBar = fig.getHorizontalScrollBar();
        hBar.setBounds(new Rectangle(rect.x, rect.bottom() - this.getHScrollHeight(), rect.width - this.getVScrollWidth(), this.getHScrollHeight()));
        hBar.invalidate();
        hBar.validate();
        vBar.setVisible(fig.getVerticalScrollBarVisibility() != 0);
        hBar.setVisible(fig.getHorizontalScrollBarVisibility() != 0);
        int vStepInc = vBar.getStepIncrement();
        int vPageInc = vBar.getRangeModel().getExtent() - vStepInc;
        if (vPageInc < vStepInc) {
            vPageInc = vStepInc;
        }
        vBar.setPageIncrement(vPageInc);
        int hStepInc = hBar.getStepIncrement();
        int hPageInc = hBar.getRangeModel().getExtent() - hStepInc;
        if (hPageInc < hStepInc) {
            hPageInc = hStepInc;
        }
        hBar.setPageIncrement(hPageInc);
    }

    protected int getObjectHeight() {
        CssScrollingFigure fig;
        Label label;
        int h = super.getObjectHeight() + this.getHScrollHeight();
        if (this.flowFigure instanceof CssScrollingFigure && (label = (fig = (CssScrollingFigure)this.flowFigure).getLabel()) != null) {
            h += label.getPreferredSize().height;
        }
        return h;
    }

    protected int getObjectWidth() {
        int w = super.getObjectWidth();
        return w += this.getVScrollWidth();
    }
}

