/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.figures;

import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.OffRenderingEditPart;
import com.ibm.etools.webedit.render.internal.figures.CssScrollingFigure;
import com.ibm.etools.webedit.render.internal.figures.HTMLElementFigure;
import com.ibm.etools.xve.renderer.figures.FigureFactoryImpl;
import com.ibm.etools.xve.renderer.figures.TextFigure;
import com.ibm.etools.xve.renderer.internal.figures.FigureUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HTMLFigureFactory
extends FigureFactoryImpl {
    private static HTMLFigureFactory theInstance = new HTMLFigureFactory();

    private HTMLFigureFactory() {
    }

    public IFigure createContainerFigure() {
        return new HTMLElementFigure();
    }

    public IFigure createScrollingFigure() {
        return new CssScrollingFigure();
    }

    public static HTMLFigureFactory getInstance() {
        return theInstance;
    }

    public IFigure createFigure(EditPart editPart) {
        Node node;
        if (editPart instanceof NodeEditPart && (node = ((NodeEditPart)editPart).getNode()) != null) {
            Object figure = null;
            if (node.getNodeType() == 9) {
                if (((NodeEditPart)editPart).isEmbeddedDocument()) {
                    figure = new HTMLElementFigure();
                } else {
                    figure = FigureUtil.createFlowContainer();
                    if (figure != null) {
                        HTMLElementFigure container = new HTMLElementFigure();
                        figure.add((IFigure)container);
                        this.initElementFigure((IFigure)container, editPart);
                    }
                }
            } else {
                figure = node.getNodeType() == 3 ? (!(editPart instanceof OffRenderingEditPart) ? new TextFigure() : new HTMLElementFigure()) : (!(editPart instanceof OffRenderingEditPart) && this.isCardElement(node) ? new CssScrollingFigure() : new HTMLElementFigure());
            }
            if (figure != null) {
                this.initElementFigure((IFigure)figure, editPart);
                return figure;
            }
        }
        return null;
    }

    private boolean isCardElement(Node n) {
        if (!n.getNodeName().equalsIgnoreCase("card")) {
            return false;
        }
        Document doc = n.getOwnerDocument();
        if (!(doc instanceof IDOMDocument)) {
            return false;
        }
        IDOMDocument xdoc = (IDOMDocument)doc;
        DocumentTypeAdapter adapter = (DocumentTypeAdapter)xdoc.getAdapterFor(DocumentTypeAdapter.class);
        if (adapter == null) {
            return false;
        }
        DocumentType docType = adapter.getDocumentType();
        if (docType == null) {
            return false;
        }
        if (!"wml".equalsIgnoreCase(docType.getName())) {
            return false;
        }
        ModelQuery query = ModelQueryUtil.getModelQuery((Document)doc);
        if (query == null) {
            return false;
        }
        if (!(n instanceof Element)) {
            return false;
        }
        CMElementDeclaration decl = query.getCMElementDeclaration((Element)n);
        return decl != null;
    }
}

