/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.figures;

import com.ibm.etools.webedit.render.internal.style.CssScrollingBodyStyle;
import com.ibm.etools.webedit.viewer.internal.ResourceHandler;
import com.ibm.etools.xve.renderer.figures.BidiCaretController;
import com.ibm.etools.xve.renderer.figures.CaretHandler;
import com.ibm.etools.xve.renderer.figures.ElementFigure;
import com.ibm.etools.xve.renderer.figures.IFlowContainer;
import com.ibm.etools.xve.renderer.internal.figures.FigureUtil;
import com.ibm.etools.xve.renderer.internal.figures.MediatorFactory;
import com.ibm.etools.xve.renderer.style.Length;
import com.ibm.etools.xve.renderer.style.Style;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class CssScrollingFigure
extends ElementFigure
implements PropertyChangeListener {
    public static final int NEVER = 0;
    public static final int AUTOMATIC = 1;
    public static final int ALWAYS = 2;
    private Figure tray;
    private IFlowContainer page;
    private ElementFigure body;
    private Label label;
    private ScrollBar hBar;
    private ScrollBar vBar;
    private int hVisibility = 1;
    private int vVisibility = 1;

    public CssScrollingFigure() {
        this.createPage();
        this.createLabel();
        this.createHorizontalScrollBar();
        this.createVerticalScrollBar();
    }

    protected void createPage() {
        if (this.tray == null) {
            this.tray = new Figure();
            this.tray.setOpaque(true);
        }
        super.add((IFigure)this.tray, null, -1);
        if (this.page == null) {
            this.page = FigureUtil.createFlowContainer();
            this.page.setOpaque(true);
        }
        this.updatePageSize();
        this.tray.add((IFigure)this.page);
        if (this.body == null) {
            this.body = new ElementFigure();
            this.body.setStyle((Style)new CssScrollingBodyStyle((IFigure)this.body));
            this.body.setOpaque(true);
            this.body.styleChanged(64);
        }
        this.page.add((IFigure)this.body, null, -1);
    }

    protected void createLabel() {
        this.label = new Label();
        this.label.setBorder((Border)new LabelBorder());
        super.add((IFigure)this.label, null, -1);
        this.updateLabel();
    }

    private void updateLabel() {
        Style style = this.getStyle();
        String name = style != null ? this.getStyle().getText(110) : ResourceHandler._UI_Card_1;
        this.label.setText(name);
    }

    public Label getLabel() {
        return this.label;
    }

    protected void createHorizontalScrollBar() {
        ScrollBar bar = new ScrollBar();
        bar.setHorizontal(true);
        this.setHorizontalScrollBar(bar);
    }

    protected void createVerticalScrollBar() {
        ScrollBar bar = new ScrollBar();
        this.setVerticalScrollBar(bar);
    }

    public ScrollBar getHorizontalScrollBar() {
        if (this.hBar == null) {
            this.createHorizontalScrollBar();
        }
        return this.hBar;
    }

    public int getHorizontalScrollBarVisibility() {
        return this.hVisibility;
    }

    public ScrollBar getVerticalScrollBar() {
        if (this.vBar == null) {
            this.createVerticalScrollBar();
        }
        return this.vBar;
    }

    public int getVerticalScrollBarVisibility() {
        return this.vVisibility;
    }

    public Point scrollBy(int dx, int dy) {
        RangeModel rangeModel;
        Point p = new Point();
        if (this.hBar != null && (rangeModel = this.hBar.getRangeModel()) != null) {
            int x = rangeModel.getValue();
            rangeModel.setValue(x + dx);
            p.x = rangeModel.getValue() - x;
        }
        if (this.vBar != null && (rangeModel = this.vBar.getRangeModel()) != null) {
            int y = rangeModel.getValue();
            rangeModel.setValue(y + dy);
            p.y = rangeModel.getValue() - y;
        }
        return p;
    }

    public void setHorizontalScrollBar(ScrollBar bar) {
        if (this.hBar != null) {
            super.remove((IFigure)this.hBar);
            this.hBar.getRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.hBar = bar;
        if (this.hBar != null) {
            super.add((IFigure)this.hBar, null, -1);
            this.hBar.getRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setHorizontalScrollBarVisibility(int v) {
        if (this.hVisibility == v) {
            return;
        }
        this.hVisibility = v;
        this.revalidate();
    }

    public void setScrollBarVisibility(int v) {
        this.setHorizontalScrollBarVisibility(v);
        this.setVerticalScrollBarVisibility(v);
    }

    public void setVerticalScrollBar(ScrollBar bar) {
        if (this.vBar != null) {
            super.remove((IFigure)this.vBar);
            this.vBar.getRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.vBar = bar;
        if (this.vBar != null) {
            super.add((IFigure)this.vBar, null, -1);
            this.vBar.getRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setVerticalScrollBarVisibility(int v) {
        if (this.vVisibility == v) {
            return;
        }
        this.vVisibility = v;
        this.revalidate();
    }

    public void validate() {
        super.validate();
        this.getHorizontalScrollBar().validate();
        this.getVerticalScrollBar().validate();
    }

    public void add(IFigure figure, Object constraint, int index) {
        this.body.add(figure, constraint, index);
    }

    public void remove(IFigure figure) {
        this.body.remove(figure);
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.body.setConstraint(child, constraint);
    }

    public void postValidate() {
        super.postValidate();
        Rectangle rectNew = new Rectangle(this.getBounds());
        if (rectNew != null) {
            Rectangle page_bounds = this.tray.getBounds();
            int diff_x = rectNew.x - page_bounds.x;
            int diff_y = this.label.getBounds().bottom() - page_bounds.y;
            this.tray.translate(diff_x, diff_y);
        }
        this.tray.invalidate();
        this.tray.validate();
        Dimension size = this.getContentSize();
        if (this.hBar != null) {
            this.hBar.getRangeModel().setAll(0, size.width, this.page.getBounds().width);
        }
        if (this.vBar != null) {
            this.vBar.getRangeModel().setAll(0, size.height, this.page.getBounds().height);
        }
        Point t = this.getViewLocation().getNegated();
        this.body.translate(t.x, t.y);
    }

    public void updateVisualStyle() {
        this.updateLabel();
        super.updateVisualStyle();
        this.body.updateVisualStyle();
        Color bg = this.getBackgroundColor();
        this.page.setBackgroundColor(bg);
        this.updatePageSize();
    }

    private Dimension getContentSize() {
        Dimension size = new Dimension(0, 0);
        Style style = this.getStyle();
        if (style != null) {
            Length height;
            Length width = style.getLength(31);
            if (width != null) {
                size.width = width.getPixelLength();
            }
            if ((height = style.getLength(32)) != null) {
                size.height = height.getPixelLength();
            }
        }
        return size;
    }

    private void updatePageSize() {
        if (this.page == null) {
            return;
        }
        this.page.setAvailableSize(this.getContentSize());
        this.tray.setSize(this.getContentSize());
    }

    public void invalidate() {
        super.invalidate();
        this.tray.invalidate();
        this.page.invalidate();
    }

    public boolean isOpaque() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof RangeModel && "value".equals(event.getPropertyName())) {
            this.revalidate();
        }
    }

    public Point getViewLocation() {
        return new Point(this.hBar.getRangeModel().getValue(), this.vBar.getRangeModel().getValue());
    }

    public Rectangle getCaretRect(int offset, int edge) {
        return this.body.getCaretRect(offset, edge);
    }

    public Rectangle getBidiCaretRect(int offset, boolean rtl, BidiCaretController controller) {
        return this.body.getBidiCaretRect(offset, rtl, controller);
    }

    public CaretHandler.BidiCaretState getNextBidiCaretState(int current_offset, boolean current_rtl) {
        return this.body.getNextBidiCaretState(current_offset, current_rtl);
    }

    public CaretHandler.BidiCaretState getPrevBidiCaretState(int current_offset, boolean current_rtl) {
        return this.body.getPrevBidiCaretState(current_offset, current_rtl);
    }

    public CaretHandler.BidiCaretState getBidiCaretOffset(Point p) {
        return this.body.getBidiCaretOffset(p);
    }

    public Rectangle getBidiPreviousLineRect(int offset, boolean rtl, BidiCaretController controller) {
        return this.body.getBidiPreviousLineRect(offset, rtl, controller);
    }

    public int getCaretOffset(Point p) {
        return this.body.getCaretOffset(p);
    }

    public Rectangle getContentArea() {
        Rectangle rect = new Rectangle();
        rect = super.getClientArea(rect);
        rect = rect.getCropped(new Insets(this.label != null ? this.label.getBounds().height : 0, 0, this.getHorScrollBarHeight(), this.getVerScrollBarWidth()));
        return rect;
    }

    private int getHorScrollBarHeight() {
        ScrollBar horizontalBar = this.getHorizontalScrollBar();
        if (this.getHorizontalScrollBarVisibility() == 0) {
            return 0;
        }
        return horizontalBar.getSize().height;
    }

    private int getVerScrollBarWidth() {
        ScrollBar verticalBar = this.getVerticalScrollBar();
        if (this.getVerticalScrollBarVisibility() == 0) {
            return 0;
        }
        return verticalBar.getSize().width;
    }

    public void addNotify() {
        super.addNotify();
        MediatorFactory factory = this.getFactory();
        this.page.setFactory(factory);
        this.body.setFactory(factory);
    }

    public boolean containsPointInContentArea(Point point) {
        return this.tray.containsPoint(point);
    }

    class LabelBorder
    extends AbstractBorder {
        private static final int borderWidth = 1;
        private static final int marginWidth = 2;
        private Insets myInsets = new Insets(3, 3, 2, 3);

        LabelBorder() {
        }

        public Insets getInsets(IFigure f) {
            return this.myInsets;
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            int x;
            Rectangle rect = figure.getBounds();
            Color org = g.getForegroundColor();
            g.setForegroundColor(ColorConstants.buttonLightest);
            int i = 0;
            while (i < 1) {
                int y = rect.y + i;
                g.drawLine(rect.x, y, rect.right(), y);
                ++i;
            }
            i = 0;
            while (i < 1) {
                x = rect.x + i;
                g.drawLine(x, rect.y, x, rect.bottom());
                ++i;
            }
            g.setForegroundColor(ColorConstants.buttonDarker);
            i = 0;
            while (i < 1) {
                x = rect.right() - i - 1;
                g.drawLine(x, rect.y, x, rect.bottom());
                ++i;
            }
            g.setForegroundColor(org);
        }
    }
}

