/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.commentelement;

import com.ibm.etools.webedit.render.commentelement.CommentElementInfo;
import com.ibm.etools.webedit.render.commentelement.IconContributor;
import com.ibm.etools.webedit.viewer.WebEditViewerPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class CommentElementInfoRegistry {
    private static CommentElementInfoRegistry fInstance;
    private String EXTENSION_POINT_ID = "commentElementRenderingInfo";
    private Map fInfoMap;
    private Map contributors;

    public static CommentElementInfoRegistry getInstance() {
        if (fInstance == null) {
            fInstance = new CommentElementInfoRegistry();
        }
        return fInstance;
    }

    private CommentElementInfoRegistry() {
    }

    public CommentElementInfo getInfo(String id) {
        CommentElementInfo info;
        if (this.fInfoMap == null) {
            this.setupInfo();
        }
        if ((info = (CommentElementInfo)this.fInfoMap.get(id)) == null) {
            info = new CommentElementInfo();
        }
        return info;
    }

    private void setupInfo() {
        if (this.fInfoMap != null) {
            return;
        }
        this.fInfoMap = new HashMap();
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extRegistry.getExtensionPoint(WebEditViewerPlugin.getDefault().getBundle().getSymbolicName(), this.EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                CommentElementInfo info = new CommentElementInfo(elements[i]);
                String id = info.getID();
                if (id != null) {
                    this.fInfoMap.put(id, info);
                }
                ++i;
            }
        }
    }

    IconContributor getIconContributor(String classname, Bundle bundle) {
        IconContributor contrib = null;
        if (bundle != null && classname != null && classname.length() > 0) {
            if (this.contributors == null) {
                this.contributors = new HashMap();
            }
            if (this.contributors != null) {
                try {
                    contrib = (IconContributor)this.contributors.get(classname);
                }
                catch (ClassCastException classCastException) {
                    contrib = null;
                }
                if (contrib == null) {
                    try {
                        Class clazz = bundle.loadClass(classname);
                        if (clazz != null) {
                            contrib = (IconContributor)clazz.newInstance();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        contrib = null;
                    }
                    catch (InstantiationException instantiationException) {
                        contrib = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        contrib = null;
                    }
                    if (contrib != null) {
                        this.contributors.put(classname, contrib);
                    }
                }
            }
        }
        return contrib;
    }
}

