/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.commentelement;

import com.ibm.etools.webedit.render.commentelement.CommentElementInfoRegistry;
import com.ibm.etools.webedit.render.commentelement.IconContributor;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class CommentElementInfo {
    public static final String ID = "id";
    public static final String IMAGE_CONTRIBUTOR = "image-contributor";
    public static final String IMAGE_START = "image-start";
    public static final String IMAGE_END = "image-end";
    public static final String ATTRIBUTE_VIEW_CLASS = "attribute-view";
    private Bundle bundle;
    private Map fProperties = new HashMap();

    CommentElementInfo(IConfigurationElement element) {
        this.setup(element);
    }

    CommentElementInfo() {
    }

    public String getID() {
        if (this.fProperties != null) {
            return (String)this.fProperties.get(ID);
        }
        return null;
    }

    public String getProperty(String name) {
        return (String)this.fProperties.get(name);
    }

    private URL getResourceURL(String name) {
        String path = this.getProperty(name);
        if (path != null) {
            return this.bundle == null ? null : this.bundle.getEntry(path);
        }
        return null;
    }

    private void setup(IConfigurationElement element) {
        if (this.fProperties != null) {
            this.fProperties.clear();
        }
        this.bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
        String[] names = element.getAttributeNames();
        if (names == null) {
            return;
        }
        int length = names.length;
        int i = 0;
        while (i < length) {
            String name = names[i];
            this.fProperties.put(name.toLowerCase(Locale.US), element.getAttribute(name));
            ++i;
        }
    }

    private IconContributor getIconContributor() {
        String classname = this.getProperty(IMAGE_CONTRIBUTOR);
        if (this.bundle != null && classname != null && classname.length() > 0) {
            return CommentElementInfoRegistry.getInstance().getIconContributor(classname, this.bundle);
        }
        return null;
    }

    public ImageDescriptor getStartIcon(Map attributes) {
        URL url;
        String id;
        ImageDescriptor desc = null;
        IconContributor contrib = this.getIconContributor();
        if (contrib != null && (id = this.getID()) != null && id.length() > 0) {
            desc = contrib.getStartIcon(id, attributes);
        }
        if (desc == null && (url = this.getResourceURL(IMAGE_START)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        return desc;
    }

    public ImageDescriptor getEndIcon(Map attributes) {
        URL url;
        String id;
        ImageDescriptor desc = null;
        IconContributor contrib = this.getIconContributor();
        if (contrib != null && (id = this.getID()) != null && id.length() > 0) {
            desc = contrib.getEndIcon(id, attributes);
        }
        if (desc == null && (url = this.getResourceURL(IMAGE_END)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        return desc;
    }
}

