/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.tools;

import java.io.IOException;
import java.io.InputStream;

public class MarkableInputStream
extends InputStream {
    private InputStream myInput = null;
    private byte[] myBuffer = null;
    private int myBufferPos = 0;
    private int myBufferFilled = 0;

    public MarkableInputStream(InputStream input) {
        this.myInput = input;
    }

    @Override
    public int available() throws IOException {
        if (this.myInput == null) {
            return 0;
        }
        int available = this.myBufferFilled - this.myBufferPos;
        available = Math.max(available, 0);
        return available + this.myInput.available();
    }

    @Override
    public void close() throws IOException {
        this.myBufferPos = 0;
        this.myBufferFilled = 0;
        this.myBuffer = null;
        this.myInput.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        byte[] work = new byte[readlimit];
        if (this.myBuffer != null) {
            int size = this.myBuffer.length - this.myBufferPos;
            if (size > readlimit) {
                work = new byte[size];
            }
            int i = 0;
            while (this.myBufferPos < this.myBufferFilled) {
                work[i] = this.myBuffer[this.myBufferPos];
                ++i;
                ++this.myBufferPos;
            }
            this.myBufferFilled = i;
        }
        this.myBuffer = work;
        this.myBufferPos = 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        byte[] work = new byte[1];
        this.read(work);
        return work[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        MarkableInputStream markableInputStream = this;
        synchronized (markableInputStream) {
            if (this.myBufferPos < this.myBufferFilled) {
                int xfer = this.myBufferFilled - this.myBufferPos;
                xfer = Math.min(xfer, len);
                int i = 0;
                while (i < xfer) {
                    b[off + i] = this.myBuffer[this.myBufferPos + i];
                    ++i;
                }
                this.myBufferPos += xfer;
                off += xfer;
                len -= xfer;
                read += xfer;
            }
            if (len <= 0) {
                return read;
            }
            int readbytes = this.myInput.read(b, off, len);
            read += readbytes;
            if (this.myBuffer != null) {
                int limit = this.myBuffer.length - this.myBufferFilled;
                if (len <= limit) {
                    int j = 0;
                    while (j < len) {
                        this.myBuffer[this.myBufferFilled + j] = b[off + j];
                        ++j;
                    }
                    this.myBufferFilled += len;
                    this.myBufferPos = this.myBufferFilled;
                } else {
                    this.myBuffer = null;
                    this.myBufferPos = 0;
                    this.myBufferFilled = 0;
                }
            }
        }
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.myBuffer == null || this.myBufferFilled < this.myBufferPos) {
            throw new IOException("not marked or exceeds readlimit");
        }
        this.myBufferPos = 0;
    }
}

