/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.png;

import com.ibm.etools.webedit.imagetool.internal.image.ImageProperties;
import com.ibm.etools.webedit.imagetool.internal.png.PNGPrivateChunk;
import com.ibm.etools.webedit.imagetool.internal.png.PNGTextChunk;

public class PNGImageProperties
extends ImageProperties {
    public static final int PNG_COLOR_GRAY = 0;
    public static final int PNG_COLOR_RGB = 2;
    public static final int PNG_COLOR_INDEXED = 3;
    public static final int PNG_COLOR_AGRAY = 4;
    public static final int PNG_COLOR_ARGB = 6;
    public static final int PNG_INTERLACE_NONE = 0;
    public static final int PNG_INTERLACE_ADAM7 = 1;
    static final int myFormat = 5;
    private int pngColorType = -1;
    private PNGTextChunk[] pngTexts = null;
    private PNGPrivateChunk[] pngPrivates = null;

    @Override
    public int getImageFormat() {
        return 5;
    }

    public int getPngColorType() {
        return this.pngColorType;
    }

    public byte[] getPrivateData(byte[] name, byte[] key) {
        if (this.pngPrivates == null) {
            return null;
        }
        int num = this.pngPrivates.length;
        int i = 0;
        while (i < num) {
            byte[] result;
            PNGPrivateChunk chunk = this.pngPrivates[i];
            boolean match = chunk.isMyName(name);
            if (match && (result = chunk.getData(key)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public byte[] getTextData(byte[] key) {
        if (this.pngTexts == null) {
            return null;
        }
        int num = this.pngTexts.length;
        int i = 0;
        while (i < num) {
            PNGTextChunk text = this.pngTexts[i];
            boolean match = text.isMyKey(key);
            if (match) {
                return text.getData();
            }
            ++i;
        }
        return null;
    }
}

