/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.jpeg;

import com.ibm.etools.webedit.imagetool.internal.io.EncodingOptions;
import com.ibm.etools.webedit.imagetool.internal.jpeg.JPEGEncodingOptions;
import com.ibm.etools.webedit.imagetool.internal.jpeg.JPEGImageWriter;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

class JPEGImageWriterJ2
extends JPEGImageWriter {
    private JPEGImageEncoder myEncoder = null;
    private JPEGEncodingOptions encOptions = null;

    public JPEGImageWriterJ2(OutputStream output) {
        this.myEncoder = JPEGCodec.createJPEGEncoder((OutputStream)output);
        this.encOptions = null;
    }

    @Override
    public boolean saveImage(BufferedImage bi) throws IOException {
        JPEGEncodeParam param = this.myEncoder.getDefaultJPEGEncodeParam(bi);
        if (this.encOptions != null) {
            JPEGQTable qtableY = new JPEGQTable(this.encOptions.createZigZagArray(false));
            JPEGQTable qtableC = new JPEGQTable(this.encOptions.createZigZagArray(true));
            param.setQTable(param.getQTableComponentMapping(0), qtableY);
            param.setQTable(param.getQTableComponentMapping(1), qtableC);
        }
        this.myEncoder.encode(bi, param);
        return true;
    }

    @Override
    public void setEncodingOptions(EncodingOptions options) {
        if (options instanceof JPEGEncodingOptions) {
            this.encOptions = (JPEGEncodingOptions)options;
        }
    }

    public void setEncodingOptions(JPEGEncodingOptions options) {
        this.encOptions = options;
    }
}

