/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.jpeg;

import com.ibm.etools.webedit.imagetool.internal.jpeg.JPEGQArray;
import com.sun.image.codec.jpeg.JPEGQTable;

public class HandyJPEGQTable
extends JPEGQArray {
    private static final int[] STD_LUMA_QARRAY = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    private static final int[] STD_CHROMA_QARRAY = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    public static final HandyJPEGQTable STD_LUMA_QTABLE = new HandyJPEGQTable(STD_LUMA_QARRAY, false);
    public static final HandyJPEGQTable STD_CHROMA_QTABLE = new HandyJPEGQTable(STD_CHROMA_QARRAY, true);
    static final int MIN_LUMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_LUMA_QARRAY, 0.0, false);
    static final int HLF_LUMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_LUMA_QARRAY, 0.5, false);
    static final int STD_LUMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_LUMA_QARRAY, 1.0, false);
    static final int DBL_LUMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_LUMA_QARRAY, 2.0, false);
    static final int MAX_LUMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_LUMA_QARRAY, 355.0, false);
    static final int MIN_CHROMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_CHROMA_QARRAY, 0.0, false);
    static final int HLF_CHROMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_CHROMA_QARRAY, 0.5, false);
    static final int STD_CHROMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_CHROMA_QARRAY, 1.0, false);
    static final int DBL_CHROMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_CHROMA_QARRAY, 2.0, false);
    static final int MAX_CHROMA_BARE_QLEVEL = HandyJPEGQTable.getBareQLevel(STD_CHROMA_QARRAY, 355.0, false);
    public static final int MAX_QUALITY = 100;
    public static final int DBL_QUALITY = 75;
    public static final int STD_QUALITY = 50;
    public static final int HLF_QUALITY = 25;
    public static final int MIN_QUALITY = 0;
    private boolean isChrominance = false;

    HandyJPEGQTable(int[] qarray, double magic, boolean forcebaseline, boolean ischroma) {
        super(qarray, magic, forcebaseline);
        this.isChrominance = ischroma;
    }

    HandyJPEGQTable(int[] qarray, boolean ischroma) {
        super(qarray);
        this.isChrominance = ischroma;
    }

    HandyJPEGQTable(JPEGQTable qtable, boolean ischroma) {
        super(qtable);
        this.isChrominance = ischroma;
    }

    public static HandyJPEGQTable createChromaQTable(int[] qarray, int quality, boolean forcebaseline) {
        double minMagic = 0.0;
        double maxMagic = 255.0;
        HandyJPEGQTable qtable = null;
        if (qarray == null) {
            qarray = STD_CHROMA_QARRAY;
        }
        int i = 0;
        while (i < 12) {
            double magic = (minMagic * 2.0 + maxMagic) / 3.0;
            qtable = new HandyJPEGQTable(qarray, magic, forcebaseline, true);
            int calculated = qtable.getQuality();
            if (calculated == quality) break;
            if (calculated > quality) {
                minMagic = magic;
            } else {
                maxMagic = magic;
            }
            ++i;
        }
        if (i == 12) {
            qtable = new HandyJPEGQTable(qarray, minMagic, forcebaseline, true);
        }
        return qtable;
    }

    public HandyJPEGQTable createChromaQTable(int quality, boolean forcebaseline) {
        return HandyJPEGQTable.createChromaQTable(this.myQArray, quality, forcebaseline);
    }

    public static HandyJPEGQTable createLumaQTable(int[] qarray, int quality, boolean forcebaseline) {
        double minMagic = 0.0;
        double maxMagic = 255.0;
        HandyJPEGQTable qtable = null;
        if (qarray == null) {
            qarray = STD_LUMA_QARRAY;
        }
        int i = 0;
        while (i < 12) {
            double magic = (minMagic * 2.0 + maxMagic) / 3.0;
            qtable = new HandyJPEGQTable(qarray, magic, forcebaseline, false);
            int calculated = qtable.getQuality();
            if (calculated == quality) break;
            if (calculated > quality) {
                minMagic = magic;
            } else {
                maxMagic = magic;
            }
            ++i;
        }
        if (i == 12) {
            qtable = new HandyJPEGQTable(qarray, minMagic, forcebaseline, false);
        }
        return qtable;
    }

    public HandyJPEGQTable createLumaQTable(int quality, boolean forcebaseline) {
        return HandyJPEGQTable.createLumaQTable(this.myQArray, quality, forcebaseline);
    }

    public int getQuality() {
        int bare = this.getBareQLevel();
        if (!this.isChrominance) {
            if (bare < HLF_LUMA_BARE_QLEVEL) {
                return 100 - (int)(25.0 * (double)(bare - MIN_LUMA_BARE_QLEVEL) / (double)(HLF_LUMA_BARE_QLEVEL - MIN_LUMA_BARE_QLEVEL) + 0.5);
            }
            if (bare < STD_LUMA_BARE_QLEVEL) {
                return 75 - (int)(25.0 * (double)(bare - HLF_LUMA_BARE_QLEVEL) / (double)(STD_LUMA_BARE_QLEVEL - HLF_LUMA_BARE_QLEVEL) + 0.5);
            }
            if (bare < DBL_LUMA_BARE_QLEVEL) {
                return 50 - (int)(25.0 * (double)(bare - STD_LUMA_BARE_QLEVEL) / (double)(DBL_LUMA_BARE_QLEVEL - STD_LUMA_BARE_QLEVEL) + 0.5);
            }
            return 25 - (int)(25.0 * (double)(bare - DBL_LUMA_BARE_QLEVEL) / (double)(MAX_LUMA_BARE_QLEVEL - DBL_LUMA_BARE_QLEVEL) + 0.5);
        }
        if (bare < HLF_CHROMA_BARE_QLEVEL) {
            return 100 - (int)(25.0 * (double)(bare - MIN_CHROMA_BARE_QLEVEL) / (double)(HLF_CHROMA_BARE_QLEVEL - MIN_CHROMA_BARE_QLEVEL) + 0.5);
        }
        if (bare < STD_CHROMA_BARE_QLEVEL) {
            return 75 - (int)(25.0 * (double)(bare - HLF_CHROMA_BARE_QLEVEL) / (double)(STD_CHROMA_BARE_QLEVEL - HLF_CHROMA_BARE_QLEVEL) + 0.5);
        }
        if (bare < DBL_CHROMA_BARE_QLEVEL) {
            return 50 - (int)(25.0 * (double)(bare - STD_CHROMA_BARE_QLEVEL) / (double)(DBL_CHROMA_BARE_QLEVEL - STD_CHROMA_BARE_QLEVEL) + 0.5);
        }
        return 25 - (int)(25.0 * (double)(bare - DBL_CHROMA_BARE_QLEVEL) / (double)(MAX_CHROMA_BARE_QLEVEL - DBL_CHROMA_BARE_QLEVEL) + 0.5);
    }
}

