/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.io;

import com.ibm.etools.webedit.imagetool.internal.bmp.BMPImageWriter;
import com.ibm.etools.webedit.imagetool.internal.gif.GIFImageWriter;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import com.ibm.etools.webedit.imagetool.internal.io.EncodingOptions;
import com.ibm.etools.webedit.imagetool.internal.jpeg.JPEGImageWriter;
import com.ibm.etools.webedit.imagetool.internal.png.PNGImageWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;

public abstract class HandyImageWriter {
    protected HandyImage myImage = null;

    public static HandyImageWriter createImageWriter(OutputStream output, int format) {
        HandyImageWriter writer = null;
        if (format == 4) {
            writer = JPEGImageWriter.createImageWriter(output);
        } else if (format == 2) {
            writer = GIFImageWriter.createImageWriter(output);
        } else if (format == 5) {
            writer = PNGImageWriter.createImageWriter(output);
        } else if (format == 1) {
            writer = BMPImageWriter.createImageWriter(output);
        }
        if (writer == null) {
            ImageError.error(3);
        }
        return writer;
    }

    public static HandyImageWriter createImageWriter(String filename) throws FileNotFoundException {
        int format = HandyImageWriter.detectFormatFromExt(filename);
        return HandyImageWriter.createImageWriter(filename, format);
    }

    public static HandyImageWriter createImageWriter(String filename, int format) throws FileNotFoundException {
        FileOutputStream output = new FileOutputStream(filename);
        return HandyImageWriter.createImageWriter(output, format);
    }

    public static int detectFormatFromExt(String filename) {
        String work = filename.toLowerCase(Locale.US);
        if (work.endsWith(".pcd")) {
            return 103;
        }
        if (work.endsWith(".fpx")) {
            return 104;
        }
        if (work.endsWith(".emf")) {
            return 201;
        }
        if (work.endsWith(".jpg") || work.endsWith(".jpeg")) {
            return 4;
        }
        if (work.endsWith(".gif")) {
            return 2;
        }
        if (work.endsWith(".png")) {
            return 5;
        }
        if (work.endsWith(".bmp")) {
            return 1;
        }
        if (work.endsWith(".tif") || work.endsWith(".tiff")) {
            return 6;
        }
        if (work.endsWith(".mif")) {
            return 101;
        }
        if (work.endsWith(".wmf")) {
            return 202;
        }
        if (work.endsWith(".wbmp")) {
            return 17;
        }
        return 0;
    }

    public abstract int getImageFormat();

    public abstract boolean saveImage(HandyImage var1) throws IOException;

    public abstract void setEncodingOptions(EncodingOptions var1);
}

