/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.io;

import com.ibm.etools.webedit.imagetool.ImageException;
import com.ibm.etools.webedit.imagetool.internal.bmp.BMPImageReader;
import com.ibm.etools.webedit.imagetool.internal.bmp.BMPImageReaderSwt;
import com.ibm.etools.webedit.imagetool.internal.bmp.ICOImageReader;
import com.ibm.etools.webedit.imagetool.internal.bmp.ICOImageReaderSwt;
import com.ibm.etools.webedit.imagetool.internal.filter.SizeOp;
import com.ibm.etools.webedit.imagetool.internal.gif.GIFImageReader;
import com.ibm.etools.webedit.imagetool.internal.gif.GIFImageReaderSwt;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.ImageProperties;
import com.ibm.etools.webedit.imagetool.internal.io.MIFImageReader;
import com.ibm.etools.webedit.imagetool.internal.jpeg.JPEGImageReader;
import com.ibm.etools.webedit.imagetool.internal.mif.MIFImageReaderImpl;
import com.ibm.etools.webedit.imagetool.internal.png.PNGImageReader;
import com.ibm.etools.webedit.imagetool.internal.wbmp.WBMPImageReader;
import com.ibm.etools.webedit.imagetool.internal.wbmp.WBMPImageReaderDirect;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public abstract class HandyImageReader {
    public static final int ZOOM_NOTRUNCATE = 1;
    public static final int ZOOM_TRUNCATE = 2;
    public static final int ZOOM_FIT = 3;

    public boolean ableToGetPropOnly() {
        return false;
    }

    public static HandyImageReader createImageReader(InputStream input) throws IOException, ImageException {
        int format = HandyImageReader.detectFormat(input);
        HandyImageReader reader = null;
        if (format == 4) {
            reader = JPEGImageReader.createJPEGImageReader(input);
        } else if (format == 2) {
            reader = new GIFImageReaderSwt(input);
        } else if (format == 5) {
            reader = PNGImageReader.createPNGImageReader(input);
        } else if (format == 1) {
            reader = new BMPImageReaderSwt(input);
        } else if (format == 3) {
            reader = new ICOImageReaderSwt(input);
        } else if (format == 101) {
            reader = new MIFImageReaderImpl(input);
        } else if (format == 17) {
            reader = new WBMPImageReaderDirect(input);
        }
        return reader;
    }

    public static HandyImageReader createImageReader(String filename) throws IOException, ImageException {
        FileInputStream input = new FileInputStream(filename);
        HandyImageReader reader = HandyImageReader.createImageReader(input);
        if (reader != null) {
            return reader;
        }
        input.close();
        HandyImageReader.detectFormatFromExt(filename);
        return reader;
    }

    public static int detectFormat(byte[] input) {
        if (JPEGImageReader.checkFormat(input)) {
            return 4;
        }
        if (GIFImageReader.checkFormat(input)) {
            return 2;
        }
        if (PNGImageReader.checkFormat(input)) {
            return 5;
        }
        if (BMPImageReader.checkFormat(input)) {
            return 1;
        }
        if (ICOImageReader.checkFormat(input)) {
            return 3;
        }
        if (MIFImageReader.checkFormat(input)) {
            return 101;
        }
        if (WBMPImageReader.checkFormat(input)) {
            return 17;
        }
        return 0;
    }

    static int detectFormat(InputStream input) {
        byte[] work = new byte[HandyImageReader.getCheckBytes()];
        try {
            input.mark(work.length);
            input.read(work);
            input.reset();
        }
        catch (IOException iOException) {
            return -1;
        }
        return HandyImageReader.detectFormat(work);
    }

    public static int detectFormat(String infile) {
        byte[] work = new byte[HandyImageReader.getCheckBytes()];
        try {
            FileInputStream input = new FileInputStream(infile);
            ((InputStream)input).read(work);
            ((InputStream)input).close();
        }
        catch (IOException iOException) {
            return -1;
        }
        return HandyImageReader.detectFormat(work);
    }

    public static int detectFormatFromExt(String filename) {
        String work = filename.toLowerCase(Locale.US);
        if (work.endsWith(".pcd")) {
            return 103;
        }
        if (work.endsWith(".fpx")) {
            return 104;
        }
        if (work.endsWith(".emf")) {
            return 201;
        }
        if (work.endsWith(".jpg") || work.endsWith(".jpeg")) {
            return 4;
        }
        if (work.endsWith(".gif")) {
            return 2;
        }
        if (work.endsWith(".png")) {
            return 5;
        }
        if (work.endsWith(".bmp")) {
            return 1;
        }
        if (work.endsWith(".ico")) {
            return 3;
        }
        if (work.endsWith(".tif") || work.endsWith(".tiff")) {
            return 6;
        }
        if (work.endsWith(".mif")) {
            return 101;
        }
        if (work.endsWith(".wmf")) {
            return 202;
        }
        if (work.endsWith(".wbmp")) {
            return 17;
        }
        return 0;
    }

    private static int getCheckBytes() {
        int maxCheckBytes = 0;
        maxCheckBytes = Math.max(maxCheckBytes, 3);
        maxCheckBytes = Math.max(maxCheckBytes, 6);
        maxCheckBytes = Math.max(maxCheckBytes, 8);
        maxCheckBytes = Math.max(maxCheckBytes, 10);
        maxCheckBytes = Math.max(maxCheckBytes, 4);
        maxCheckBytes = Math.max(maxCheckBytes, 16);
        maxCheckBytes = Math.max(maxCheckBytes, 2);
        return maxCheckBytes;
    }

    public abstract HandyImage getImage() throws IOException, ImageException;

    public abstract int getImageFormat();

    public abstract ImageProperties getImageProperties();

    public HandyImage getThumbnail(int width, int height) throws IOException, ImageException {
        return this.getThumbnail(width, height, 1, true);
    }

    public HandyImage getThumbnail(int width, int height, int zoomtype, boolean nogrow) throws IOException, ImageException {
        HandyImage hi = this.getImage();
        if (hi == null) {
            return null;
        }
        SizeOp size = new SizeOp(width, height, zoomtype, nogrow, 2);
        return hi.create(size);
    }

    public void reset() {
    }
}

