/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.image;

import com.ibm.etools.webedit.imagetool.internal.color.Colormap;
import com.ibm.etools.webedit.imagetool.internal.color.HeckbertQuantizer;
import com.ibm.etools.webedit.imagetool.internal.filter.ImageOp;
import com.ibm.etools.webedit.imagetool.internal.image.Frame;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.ImageConverter;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import org.eclipse.swt.graphics.ImageData;

public class RasterImage
extends Frame {
    private int posX = 0;
    private int posY = 0;
    private int myDisposalMethod = 0;
    private int myDelayTime = 0;
    private BufferedImage myBImage = null;
    private boolean isGray = false;

    public RasterImage(int w, int h, int type) {
        this.myBImage = new BufferedImage(w, h, type);
    }

    public RasterImage(BufferedImage bi) {
        this(bi, false);
    }

    public RasterImage(BufferedImage bi, Point2D pos, int delay, int disposal, boolean gray) {
        this.myBImage = bi;
        this.posX = (int)Math.round(pos.getX());
        this.posY = (int)Math.round(pos.getY());
        this.myDelayTime = delay;
        this.myDisposalMethod = disposal;
        this.isGray = gray;
    }

    public RasterImage(BufferedImage bi, boolean gray) {
        this.myBImage = bi;
        this.isGray = gray;
    }

    public RasterImage(ImageData image) {
        this.myBImage = ImageConverter.createBufferedImage(image);
        this.posX = image.x;
        this.posY = image.y;
        this.myDisposalMethod = image.disposalMethod;
        this.myDelayTime = image.delayTime;
    }

    public static BufferedImage convertImage(BufferedImage bi, int type) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage bid = new BufferedImage(w, h, type);
        Graphics2D g2 = bid.createGraphics();
        g2.drawImage(bi, null, 0, 0);
        return bid;
    }

    public static BufferedImage convertToFilterable(BufferedImage bi) {
        int stype = bi.getType();
        if (stype != 1 && stype != 2) {
            stype = stype == 13 ? 2 : 1;
            bi = RasterImage.convertImage(bi, stype);
        }
        return bi;
    }

    public static void copyAlpha(BufferedImage bi, BufferedImage bid) {
        int stype = bi.getType();
        int dtype = bid.getType();
        if (stype != 2 || dtype != 2) {
            throw new ImageError(1);
        }
        DataBufferInt sdbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        int[] src = sdbi.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int srch = bi.getHeight();
        int dsth = bid.getHeight();
        int loopw = srcw < dstw ? srcw : dstw;
        int looph = srch < dsth ? srch : dsth;
        int y = 0;
        while (y < looph) {
            int ys = y * srcw;
            int yd = y * dstw;
            int x = 0;
            while (x < loopw) {
                int spix = src[ys + x];
                int dpix = dst[yd + x];
                dst[yd + x] = dpix & 0xFFFFFF | spix & 0xFF000000;
                ++x;
            }
            ++y;
        }
    }

    @Override
    public HandyImage create(ImageOp operation) {
        int sw = this.getScreenWidth();
        int sh = this.getScreenHeight();
        return operation.create(this, new Dimension(sw, sh));
    }

    Graphics2D createGraphics() {
        if (this.myBImage == null) {
            return null;
        }
        return this.myBImage.createGraphics();
    }

    @Override
    public int getAverageColor() {
        BufferedImage bi = this.getBufferedImage();
        HeckbertQuantizer hq = new HeckbertQuantizer();
        hq.reset();
        hq.prescan(bi, null);
        int[] colors = hq.selectColors(1);
        return colors[0];
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.myBImage;
    }

    @Override
    public int getDelayTime() {
        return this.myDelayTime;
    }

    @Override
    public int getDisposalMethod() {
        return this.myDisposalMethod;
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    public Rectangle2D getImageRect() {
        if (this.myBImage == null) {
            return null;
        }
        return new Rectangle2D.Double(this.posX, this.posY, this.myBImage.getWidth(), this.myBImage.getHeight());
    }

    public int getIndexAt(int x, int y) {
        if (!this.isIndexed()) {
            return -1;
        }
        int w = this.myBImage.getWidth();
        int h = this.myBImage.getHeight();
        DataBufferByte sdbb = (DataBufferByte)this.myBImage.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        if (x < 0 || x >= w || y < 0 || y >= h) {
            return -1;
        }
        return src[w * y + x];
    }

    @Override
    public IndexColorModel getIndexColorModel() {
        if (this.myBImage == null) {
            return null;
        }
        ColorModel cm = this.myBImage.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            return null;
        }
        return (IndexColorModel)cm;
    }

    public int getNumFrames() {
        return this.myBImage == null ? 0 : 1;
    }

    @Override
    public int getOffsetX() {
        return this.myBImage != null ? this.posX : 0;
    }

    @Override
    public int getOffsetY() {
        return this.myBImage != null ? this.posY : 0;
    }

    public RasterImage getRaster() {
        return this;
    }

    @Override
    public boolean hasTransparentPart() {
        block7: {
            int h;
            int w;
            int type;
            block6: {
                if (this.myBImage == null) {
                    return false;
                }
                type = this.myBImage.getType();
                w = this.myBImage.getWidth();
                h = this.myBImage.getHeight();
                if (type != 13) break block6;
                IndexColorModel icm = this.getIndexColorModel();
                int transparent = icm.getTransparentPixel();
                if (transparent < 0) {
                    return false;
                }
                DataBufferByte dbb = (DataBufferByte)this.myBImage.getRaster().getDataBuffer();
                byte[] data = dbb.getData();
                int i = 0;
                while (i < w * h) {
                    if (data[i] == transparent) {
                        return true;
                    }
                    ++i;
                }
                break block7;
            }
            if (type != 2) break block7;
            DataBufferInt dbi = (DataBufferInt)this.myBImage.getRaster().getDataBuffer();
            int[] data = dbi.getData();
            int i = 0;
            while (i < w * h) {
                if (Colormap.getAlpha(data[i]) == 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isGray() {
        return this.isGray;
    }

    public boolean isIndexed() {
        return this.getIndexColorModel() != null;
    }

    public void setTransparentIndex(int index) {
        IndexColorModel icm = this.getIndexColorModel();
        if (icm == null) {
            return;
        }
        int ncolors = icm.getMapSize();
        if (index < 0 || index >= ncolors) {
            return;
        }
        int[] cmap = new int[256];
        icm.getRGBs(cmap);
        IndexColorModel cm = new IndexColorModel(8, ncolors, cmap, 0, true, index, 0);
        int w = this.myBImage.getWidth();
        int h = this.myBImage.getHeight();
        BufferedImage bid = new BufferedImage(w, h, 13, cm);
        DataBufferByte sdbb = (DataBufferByte)this.myBImage.getRaster().getDataBuffer();
        DataBufferByte ddbb = (DataBufferByte)bid.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        byte[] dst = ddbb.getData();
        int totalbytes = w * h;
        System.arraycopy(src, 0, dst, 0, totalbytes);
        this.myBImage = bid;
    }

    public void translate(int x, int y) {
        this.posX += x;
        this.posY += y;
    }
}

