/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.image;

import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ImageConverter {
    protected static BufferedImage _createBufferedImage16(ImageData image) {
        int maskR = image.palette.redMask;
        int maskG = image.palette.greenMask;
        int maskB = image.palette.blueMask;
        if (!(maskR == 31744 && maskG == 992 && maskB == 31 || maskR == 63488 && maskG == 2016 && maskB == 31)) {
            throw new ImageError(3);
        }
        BufferedImage bi = new BufferedImage(image.width, image.height, 1);
        DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        int soffset = 0;
        int dp = 0;
        byte[] src = image.data;
        int[] dst = dbi.getData();
        if (maskR == 63488 && maskG == 2016 && maskB == 31) {
            int ro = 0;
            while (ro < image.height) {
                int sp = soffset;
                int co = 0;
                while (co < image.width) {
                    int data = src[sp + 0] & 0xFF | src[sp + 1] << 8 & 0xFF00;
                    int r = (data & maskR) >> 11;
                    int g = (data & maskG) >> 5;
                    int b = data & maskB;
                    r = r << 3 | r & 7;
                    g = g << 2 | g & 3;
                    b = b << 3 | b & 7;
                    int pix = r << 16 | g << 8 | b;
                    dst[dp++] = pix;
                    ++co;
                    sp += 2;
                }
                soffset += image.bytesPerLine;
                ++ro;
            }
        } else {
            int ro = 0;
            while (ro < image.height) {
                int sp = soffset;
                int co = 0;
                while (co < image.width) {
                    int data = src[sp + 0] & 0xFF | src[sp + 1] << 8 & 0xFF00;
                    int r = (data & maskR) >> 10;
                    int g = (data & maskG) >> 5;
                    int b = data & maskB;
                    r = r << 3 | r & 7;
                    g = g << 3 | g & 7;
                    b = b << 3 | b & 7;
                    int pix = r << 16 | g << 8 | b;
                    dst[dp++] = pix;
                    ++co;
                    sp += 2;
                }
                soffset += image.bytesPerLine;
                ++ro;
            }
        }
        return bi;
    }

    protected static BufferedImage _createBufferedImageARGB(ImageData image) {
        int maskR = image.palette.redMask;
        int maskG = image.palette.greenMask;
        int maskB = image.palette.blueMask;
        boolean bgrOrder = false;
        if (maskB == 0xFF0000 && maskG == 65280 && maskR == 255) {
            bgrOrder = true;
        } else if (maskR != 0xFF0000 || maskG != 65280 || maskB != 255) {
            return null;
        }
        BufferedImage bi = new BufferedImage(image.width, image.height, 2);
        DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        int soffset = 0;
        int dp = 0;
        byte[] src = image.data;
        byte[] alpha = image.alphaData;
        int[] dst = dbi.getData();
        int pixbytes = image.depth / 8;
        int ro = 0;
        while (ro < image.height) {
            int pix;
            int co;
            int sp = soffset;
            if (bgrOrder) {
                co = 0;
                while (co < image.width) {
                    pix = src[sp + 0] & 0xFF | src[sp + 1] << 8 & 0xFF00 | src[sp + 2] << 16 & 0xFF0000 | alpha[dp] << 24 & 0xFF000000;
                    dst[dp++] = pix;
                    ++co;
                    sp += pixbytes;
                }
            } else {
                co = 0;
                while (co < image.width) {
                    pix = src[sp + 2] & 0xFF | src[sp + 1] << 8 & 0xFF00 | src[sp + 0] << 16 & 0xFF0000 | alpha[dp] << 24 & 0xFF000000;
                    dst[dp++] = pix;
                    ++co;
                    sp += pixbytes;
                }
            }
            soffset += image.bytesPerLine;
            ++ro;
        }
        return bi;
    }

    protected static BufferedImage _createBufferedImageBi(ImageData image) {
        if (image == null || image.palette == null || image.palette.colors == null || image.palette.colors.length != 2 || image.depth != 1) {
            return null;
        }
        RGB[] colors = image.palette.colors;
        int[] cmap = new int[2];
        int transPix = image.transparentPixel;
        int i = 0;
        while (i < 2) {
            cmap[i] = 0xFF000000 | colors[i].red << 16 & 0xFF0000 | colors[i].green << 8 & 0xFF00 | colors[i].blue & 0xFF;
            ++i;
        }
        if (transPix == 0 || transPix == 1) {
            int n = transPix;
            cmap[n] = cmap[n] & 0xFFFFFF;
        }
        IndexColorModel cm = new IndexColorModel(1, 2, cmap, 0, true, transPix, 0);
        BufferedImage bi = new BufferedImage(image.width, image.height, 12, cm);
        DataBuffer db = bi.getRaster().getDataBuffer();
        DataBufferByte dbb = (DataBufferByte)db;
        int soffset = 0;
        int dp = 0;
        byte[] src = image.data;
        byte[] dst = dbb.getData();
        int bytes = (image.width + 7) / 8;
        int ro = 0;
        while (ro < image.height) {
            int sp = soffset;
            int co = 0;
            while (co < bytes) {
                dst[dp++] = src[sp++];
                ++co;
            }
            soffset += image.bytesPerLine;
            ++ro;
        }
        return bi;
    }

    /*
     * Unable to fully structure code
     */
    protected static BufferedImage _createBufferedImageI(ImageData image) {
        if (image == null || image.palette == null || image.palette.colors == null || image.palette.colors.length <= 0 || image.depth != 8 && image.depth != 4 && image.depth != 2) {
            return null;
        }
        colors = image.palette.colors;
        numColors = colors.length;
        cmap = new int[numColors];
        transPix = image.transparentPixel;
        i = 0;
        while (i < numColors) {
            cmap[i] = -16777216 | colors[i].red << 16 & 0xFF0000 | colors[i].green << 8 & 65280 | colors[i].blue & 255;
            ++i;
        }
        if (transPix >= 0 && transPix < numColors) {
            v0 = transPix;
            cmap[v0] = cmap[v0] & 0xFFFFFF;
        }
        cm = new IndexColorModel(8, numColors, cmap, 0, true, transPix, 0);
        bi = new BufferedImage(image.width, image.height, 13, cm);
        dbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        soffset = 0;
        dp = 0;
        src = image.data;
        dst = dbb.getData();
        ro = 0;
        while (ro < image.height) {
            block10: {
                block9: {
                    sp = soffset;
                    co = 0;
                    if (image.depth != 8) break block9;
                    while (co < image.width) {
                        dst[dp++] = src[sp++];
                        ++co;
                    }
                    break block10;
                }
                if (image.depth != 4) ** GOTO lbl49
                while (co < image.width - 1) {
                    pix = src[sp++];
                    dst[dp++] = (byte)(pix >> 4 & 15);
                    dst[dp++] = (byte)(pix & 15);
                    co += 2;
                }
                if (co >= image.width) break block10;
                dst[dp++] = (byte)(src[sp] >> 4 & 15);
                break block10;
lbl-1000:
                // 1 sources

                {
                    pix = src[sp++];
                    dst[dp++] = (byte)(pix >> 6 & 3);
                    dst[dp++] = (byte)(pix >> 4 & 3);
                    dst[dp++] = (byte)(pix >> 2 & 3);
                    dst[dp++] = (byte)(pix & 3);
                    co += 4;
lbl49:
                    // 2 sources

                    ** while (co < image.width - 3)
                }
lbl50:
                // 1 sources

                shift = 6;
                while (co < image.width) {
                    pix = src[sp];
                    dst[dp++] = (byte)(pix >> shift & 3);
                    shift -= 2;
                    ++co;
                }
            }
            soffset += image.bytesPerLine;
            ++ro;
        }
        return bi;
    }

    protected static BufferedImage _createBufferedImageRGB(ImageData image) {
        BufferedImage bi = new BufferedImage(image.width, image.height, 1);
        DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        boolean linuxVersion = false;
        if (image.palette.blueMask == 255 && image.palette.greenMask == 65280 && image.palette.redMask == 0xFF0000) {
            linuxVersion = true;
        }
        int soffset = 0;
        int dp = 0;
        byte[] src = image.data;
        int[] dst = dbi.getData();
        int pixbytes = image.depth / 8;
        if (!linuxVersion) {
            int ro = 0;
            while (ro < image.height) {
                int sp = soffset;
                int co = 0;
                while (co < image.width) {
                    int pix = src[sp + 0] & 0xFF | src[sp + 1] << 8 & 0xFF00 | src[sp + 2] << 16 & 0xFF0000;
                    dst[dp++] = pix;
                    ++co;
                    sp += pixbytes;
                }
                soffset += image.bytesPerLine;
                ++ro;
            }
        } else if (image.depth == 32) {
            int ro = 0;
            while (ro < image.height) {
                int sp = soffset;
                int co = 0;
                while (co < image.width) {
                    int pix = src[sp + 3] & 0xFF | src[sp + 2] << 8 & 0xFF00 | src[sp + 1] << 16 & 0xFF0000;
                    dst[dp++] = pix;
                    ++co;
                    sp += pixbytes;
                }
                soffset += image.bytesPerLine;
                ++ro;
            }
        } else {
            int ro = 0;
            while (ro < image.height) {
                int sp = soffset;
                int co = 0;
                while (co < image.width) {
                    int pix = src[sp + 2] & 0xFF | src[sp + 1] << 8 & 0xFF00 | src[sp + 0] << 16 & 0xFF0000;
                    dst[dp++] = pix;
                    ++co;
                    sp += pixbytes;
                }
                soffset += image.bytesPerLine;
                ++ro;
            }
        }
        return bi;
    }

    protected static ImageData _createImageDataARGB(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        DataBuffer db = bi.getRaster().getDataBuffer();
        DataBufferInt dbi = (DataBufferInt)db;
        PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
        ImageData image = new ImageData(width, height, 24, palette);
        image.alphaData = new byte[width * height];
        int sp = 0;
        int doffset = 0;
        int[] src = dbi.getData();
        int ro = 0;
        while (ro < height) {
            int dp = doffset;
            int co = 0;
            while (co < width) {
                int pix = src[sp];
                image.data[dp + 0] = (byte)(pix & 0xFF);
                image.data[dp + 1] = (byte)(pix >> 8 & 0xFF);
                image.data[dp + 2] = (byte)(pix >> 16 & 0xFF);
                image.alphaData[sp++] = (byte)(pix >> 24 & 0xFF);
                dp += 3;
                ++co;
            }
            doffset += image.bytesPerLine;
            ++ro;
        }
        return image;
    }

    protected static ImageData _createImageDataBi(BufferedImage bi) {
        if (bi == null) {
            return null;
        }
        ColorModel cm = bi.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            return null;
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int numColors = icm.getMapSize();
        if (numColors != 2) {
            return null;
        }
        RGB[] colors = new RGB[numColors];
        int i = 0;
        while (i < numColors) {
            colors[i] = new RGB(icm.getRed(i), icm.getGreen(i), icm.getBlue(i));
            ++i;
        }
        PaletteData palette = new PaletteData(colors);
        ImageData image = new ImageData(bi.getWidth(), bi.getHeight(), 1, palette);
        image.transparentPixel = icm.getTransparentPixel();
        DataBuffer db = bi.getRaster().getDataBuffer();
        DataBufferByte dbb = (DataBufferByte)db;
        int sp = 0;
        int doffset = 0;
        byte[] src = dbb.getData();
        int bytes = (image.width + 7) / 8;
        int ro = 0;
        while (ro < image.height) {
            int dp = doffset;
            int co = 0;
            while (co < bytes) {
                image.data[dp++] = src[sp++];
                ++co;
            }
            doffset += image.bytesPerLine;
            ++ro;
        }
        return image;
    }

    protected static ImageData _createImageDataI(BufferedImage bi) {
        ColorModel cm;
        ColorModel colorModel = cm = bi == null ? null : bi.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            return null;
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int numColors = icm.getMapSize();
        RGB[] colors = new RGB[numColors];
        int i = 0;
        while (i < numColors) {
            colors[i] = new RGB(icm.getRed(i), icm.getGreen(i), icm.getBlue(i));
            ++i;
        }
        PaletteData palette = new PaletteData(colors);
        ImageData image = new ImageData(bi.getWidth(), bi.getHeight(), 8, palette);
        image.transparentPixel = icm.getTransparentPixel();
        DataBuffer db = bi.getRaster().getDataBuffer();
        DataBufferByte dbb = (DataBufferByte)db;
        int sp = 0;
        int doffset = 0;
        byte[] src = dbb.getData();
        int ro = 0;
        while (ro < image.height) {
            int dp = doffset;
            int co = 0;
            while (co < image.width) {
                image.data[dp++] = src[sp++];
                ++co;
            }
            doffset += image.bytesPerLine;
            ++ro;
        }
        return image;
    }

    protected static ImageData _createImageDataRGB(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        DataBuffer db = bi.getRaster().getDataBuffer();
        DataBufferInt dbi = (DataBufferInt)db;
        PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
        ImageData image = new ImageData(width, height, 24, palette);
        int sp = 0;
        int doffset = 0;
        int[] src = dbi.getData();
        int ro = 0;
        while (ro < height) {
            int dp = doffset;
            int co = 0;
            while (co < width) {
                int pix = src[sp++];
                image.data[dp + 0] = (byte)(pix & 0xFF);
                image.data[dp + 1] = (byte)(pix >> 8 & 0xFF);
                image.data[dp + 2] = (byte)(pix >> 16 & 0xFF);
                dp += 3;
                ++co;
            }
            doffset += image.bytesPerLine;
            ++ro;
        }
        return image;
    }

    public static BufferedImage createBufferedImage(ImageData image) {
        int depth;
        int n = depth = image == null ? 0 : image.depth;
        if (depth == 24 || depth == 32) {
            if (image.alphaData == null) {
                return ImageConverter._createBufferedImageRGB(image);
            }
            return ImageConverter._createBufferedImageARGB(image);
        }
        if (depth == 16) {
            return ImageConverter._createBufferedImage16(image);
        }
        if (depth == 8 || depth == 4 || depth == 2) {
            return ImageConverter._createBufferedImageI(image);
        }
        if (depth == 1) {
            return ImageConverter._createBufferedImageBi(image);
        }
        return null;
    }

    public static ImageData createImageData(BufferedImage bi) {
        if (bi == null) {
            return null;
        }
        int type = bi.getType();
        if (type == 1) {
            return ImageConverter._createImageDataRGB(bi);
        }
        if (type == 2) {
            return ImageConverter._createImageDataARGB(bi);
        }
        if (type == 13) {
            return ImageConverter._createImageDataI(bi);
        }
        if (type == 12) {
            return ImageConverter._createImageDataBi(bi);
        }
        return null;
    }
}

