/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.CropOp;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOp;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpA;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpI;
import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TrimOp
extends TransformOp {
    public TrimOp() {
        super(0);
    }

    @Override
    public RasterImage create(RasterImage fi, Dimension2D scrnSize) {
        int fx = fi.getOffsetX();
        int fy = fi.getOffsetY();
        int delay = fi.getDelayTime();
        int disposal = fi.getDisposalMethod();
        boolean gray = fi.isGray();
        BufferedImage bi = fi.getBufferedImage();
        Point2D.Double pos = new Point2D.Double(fx, fy);
        int type = bi.getType();
        if (type == 1 || type == 10 || type == 12) {
            return new RasterImage(bi, pos, delay, disposal, gray);
        }
        Rectangle2D trimrect = TrimOp.getTrimRect(bi);
        CropOp crop = new CropOp(trimrect);
        BufferedImage bid = crop.create(bi);
        double sl = trimrect.getMinX();
        double st = trimrect.getMinY();
        pos = new Point2D.Double(sl + (double)fx, st + (double)fy);
        return new RasterImage(bid, pos, delay, disposal, gray);
    }

    public BufferedImage create(BufferedImage bi) {
        Rectangle2D trimrect = TrimOp.getTrimRect(bi);
        CropOp crop = new CropOp(trimrect);
        BufferedImage bid = crop.create(bi);
        return bid;
    }

    public static Rectangle2D getTrimRect(BufferedImage bi) {
        int stype = bi.getType();
        int sw = bi.getWidth();
        int sh = bi.getHeight();
        LineOp operator = null;
        if (stype == 2) {
            operator = new LineOpA(false);
        } else if (stype == 13) {
            operator = new LineOpI(false);
        }
        if (operator == null) {
            return new Rectangle2D.Double(0.0, 0.0, sw, sh);
        }
        int y = 0;
        int el = 0;
        int er = 0;
        while (y < sh) {
            int[] edges = operator.getLeftRightEdge(bi, y);
            el = edges[0];
            er = edges[1];
            if (er != 0) break;
            ++y;
        }
        if (y >= sh) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        int st = y;
        int sl = el;
        int sr = er;
        int sb = y + 1;
        while (y < sh) {
            int[] edges = operator.getLeftRightEdge(bi, y);
            el = edges[0];
            er = edges[1];
            if (er != 0) {
                sb = y + 1;
                if (el < sl) {
                    sl = el;
                }
                if (er > sr) {
                    sr = er;
                }
            }
            ++y;
        }
        return new Rectangle2D.Double(sl, st, sr - sl, sb - st);
    }
}

