/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.HandyResizeOp;
import com.ibm.etools.webedit.imagetool.internal.filter.ImageOp;
import com.ibm.etools.webedit.imagetool.internal.filter.ResizeOp;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

public abstract class TransformOp
implements ImageOp {
    public static final int TYPE_NEAREST = 0;
    public static final int TYPE_BILINEAR = 1;
    public static final int TYPE_BICUBIC = 2;
    public static final double BICUBIC_MN_B = 0.3333333333333333;
    public static final double BICUBIC_MN_C = 0.3333333333333333;
    protected int interpolationType = 0;
    protected double bicubicB = 0.3333333333333333;
    protected double bicubicC = 0.3333333333333333;

    protected TransformOp(int type) {
        this.interpolationType = type;
    }

    @Override
    public abstract RasterImage create(RasterImage var1, Dimension2D var2);

    public BufferedImage createCompatible(BufferedImage bi, int w, int h) {
        int type = bi.getType();
        boolean index = type == 12 || type == 13;
        BufferedImage bid = null;
        bid = index ? new BufferedImage(w, h, type, (IndexColorModel)bi.getColorModel()) : new BufferedImage(w, h, type);
        return bid;
    }

    public static ResizeOp createResizeOp(double zx, double zy, int interpolation) {
        return new HandyResizeOp(zx, zy, interpolation);
    }

    int getATOInterpolation() {
        return TransformOp.getATOInterpolation(this.interpolationType);
    }

    static int getATOInterpolation(int interpolation) {
        int result = 1;
        switch (interpolation) {
            case 0: {
                break;
            }
            case 1: {
                result = 2;
                break;
            }
            case 2: {
                result = 2;
            }
        }
        return result;
    }

    public int getDesinationType(int type) {
        if (this.interpolationType == 0) {
            return type;
        }
        if (type == 12) {
            type = 10;
        } else if (type == 13) {
            type = 2;
        }
        return type;
    }

    public Dimension2D getOperatedSize(int width, int height) {
        return new Dimension(width, height);
    }

    @Override
    public Dimension2D getOperatedSize(Dimension2D size) {
        int w = (int)size.getWidth();
        int h = (int)size.getHeight();
        return this.getOperatedSize(w, h);
    }

    public static Rectangle2D transformRect(Rectangle2D rect, AffineTransform at) {
        double minX = rect.getMinX();
        double minY = rect.getMinY();
        double maxX = rect.getMaxX();
        double maxY = rect.getMaxY();
        Point2D[] qpa = new Point2D[]{at.transform(new Point2D.Double(minX, minY), null), at.transform(new Point2D.Double(maxX, minY), null), at.transform(new Point2D.Double(minX, maxY), null), at.transform(new Point2D.Double(maxX, maxY), null)};
        minX = qpa[0].getX();
        minY = qpa[0].getY();
        maxX = minX;
        maxY = minY;
        int i = 1;
        while (i < 4) {
            double x = qpa[i].getX();
            double y = qpa[i].getY();
            if (minX > x) {
                minX = x;
            }
            if (maxX < x) {
                maxX = x;
            }
            if (minY > y) {
                minY = y;
            }
            if (maxY < y) {
                maxY = y;
            }
            ++i;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }
}

