/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.ResizeOp;
import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;

public class SizeOp
extends TransformOp {
    public static final int ZOOM_NOTRUNCATE = 1;
    public static final int ZOOM_TRUNCATE = 2;
    public static final int ZOOM_FIT = 3;
    int sizeWidth = 0;
    int sizeHeight = 0;
    int sizeType = 1;
    boolean sizeNoGrow = true;

    public SizeOp(int width, int height, int zoomType, boolean nogrow, int interpolation) {
        super(interpolation);
        this.sizeWidth = width;
        this.sizeHeight = height;
        this.sizeType = zoomType;
        this.sizeNoGrow = nogrow;
    }

    @Override
    public RasterImage create(RasterImage fi, Dimension2D scrnSize) {
        int w = (int)scrnSize.getWidth();
        int h = (int)scrnSize.getHeight();
        double[] zoom = this.getScalingFactor(w, h);
        ResizeOp resize = new ResizeOp(zoom[0], zoom[1], this.interpolationType);
        return resize.create(fi, scrnSize);
    }

    public BufferedImage create(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        double[] zoom = this.getScalingFactor(w, h);
        ResizeOp resize = new ResizeOp(zoom[0], zoom[1], this.interpolationType);
        return resize.create(bi);
    }

    double[] getScalingFactor(int sw, int sh) {
        double zx = (double)this.sizeWidth / (double)sw;
        double zy = (double)this.sizeHeight / (double)sh;
        if (this.sizeNoGrow) {
            if (zx > 1.0) {
                zx = 1.0;
            }
            if (zy > 1.0) {
                zy = 1.0;
            }
        }
        if (this.sizeType == 1) {
            if (zx > zy) {
                zx = zy;
            } else {
                zy = zx;
            }
        } else if (this.sizeType == 2) {
            if (zx > zy) {
                zy = zx;
            } else {
                zx = zy;
            }
        }
        return new double[]{zx, zy};
    }

    double[] getScalingFactor(Dimension2D inputsize) {
        double sw = inputsize.getWidth();
        double sh = inputsize.getHeight();
        double zx = (double)this.sizeWidth / sw;
        double zy = (double)this.sizeHeight / sh;
        if (this.sizeNoGrow) {
            if (zx > 1.0) {
                zx = 1.0;
            }
            if (zy > 1.0) {
                zy = 1.0;
            }
        }
        if (this.sizeType == 1) {
            if (zx > zy) {
                zx = zy;
            } else {
                zy = zx;
            }
        } else if (this.sizeType == 2) {
            if (zx > zy) {
                zy = zx;
            } else {
                zx = zy;
            }
        }
        return new double[]{zx, zy};
    }
}

