/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class RotateOp
extends TransformOp {
    private double rotateAngle = 0.0;

    public RotateOp(double angle, int type) {
        super(type);
        this.rotateAngle = angle;
    }

    @Override
    public RasterImage create(RasterImage fi, Dimension2D scrnSize) {
        BufferedImage bi = fi.getBufferedImage();
        BufferedImage bid = this.create(bi);
        int fx = fi.getOffsetX();
        int fy = fi.getOffsetY();
        int bw = bi.getWidth();
        int bh = bi.getHeight();
        Rectangle2D.Double original = new Rectangle2D.Double(fx, fy, bw, bh);
        Rectangle2D operated = this.getTransformedRect(original, scrnSize);
        double rx = operated.getMinX();
        double ry = operated.getMinY();
        Point2D.Double pos = new Point2D.Double(rx, ry);
        return new RasterImage(bid, pos, fi.getDelayTime(), fi.getDisposalMethod(), fi.isGray());
    }

    public BufferedImage create(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        Dimension size = new Dimension(w, h);
        Rectangle2D.Double original = new Rectangle2D.Double(0.0, 0.0, w, h);
        Rectangle2D operated = this.getTransformedRect(original, size);
        double rw = operated.getMaxX() - operated.getMinX();
        double rh = operated.getMaxY() - operated.getMinY();
        int bw = (int)Math.ceil(rw);
        int bh = (int)Math.ceil(rh);
        BufferedImage bid = new BufferedImage(bw, bh, 2);
        AffineTransform at = this.getTransform(size);
        AffineTransformOp ato = new AffineTransformOp(at, this.getATOInterpolation());
        return ato.filter(bi, bid);
    }

    @Override
    public int getDesinationType(int type) {
        if (this.interpolationType == 0 && type == 13) {
            return type;
        }
        return 2;
    }

    public static double getRadian(double degree) {
        return Math.PI * degree / 180.0;
    }

    public AffineTransform getTransform(Dimension2D scrnSize) {
        AffineTransform at = AffineTransform.getRotateInstance(this.rotateAngle);
        double scrw = scrnSize.getWidth();
        double scrh = scrnSize.getHeight();
        Point2D tl = at.transform(new Point2D.Double(0.0, 0.0), null);
        Point2D tr = at.transform(new Point2D.Double(scrw, 0.0), null);
        Point2D bl = at.transform(new Point2D.Double(0.0, scrh), null);
        Point2D br = at.transform(new Point2D.Double(scrw, scrh), null);
        double minX = tl.getX();
        double minY = tl.getY();
        if (minX > tr.getX()) {
            minX = tr.getX();
        }
        if (minX > bl.getX()) {
            minX = bl.getX();
        }
        if (minX > br.getX()) {
            minX = br.getX();
        }
        if (minY > tr.getY()) {
            minY = tr.getY();
        }
        if (minY > bl.getY()) {
            minY = bl.getY();
        }
        if (minY > br.getY()) {
            minY = br.getY();
        }
        at = AffineTransform.getTranslateInstance(-minX, -minY);
        at.rotate(this.rotateAngle);
        return at;
    }

    Rectangle2D getTransformedRect(Rectangle2D rect, Dimension2D scrnSize) {
        AffineTransform at = this.getTransform(scrnSize);
        return RotateOp.transformRect(rect, at);
    }
}

