/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import com.ibm.etools.webedit.imagetool.internal.tools.DebugTool;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class ResizeOp
extends TransformOp {
    protected double scaleX = 1.0;
    protected double scaleY = 1.0;

    public ResizeOp(double zx, double zy, int interpolation) {
        super(interpolation);
        this.scaleX = zx;
        this.scaleY = zy;
    }

    static BufferedImage convertBack(BufferedImage bi) {
        DebugTool.assertError(bi.getType() == 3);
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage bid = new BufferedImage(w, h, 2);
        DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        DataBufferInt dbd = (DataBufferInt)bid.getRaster().getDataBuffer();
        int[] src = dbi.getData();
        int[] dest = dbd.getData();
        int n = w * h;
        int i = 0;
        while (i < n) {
            int pix = src[i];
            int a = pix >> 24 & 0xFF;
            int r = pix >> 16 & 0xFF;
            int g = pix >> 8 & 0xFF;
            int b = pix & 0xFF;
            if (a <= 0) {
                dest[i] = 0xFFFFFF;
            } else {
                r = r * 255 / a;
                g = g * 255 / a;
                b = b * 255 / a;
                dest[i] = a << 24 | r << 16 | g << 8 | b;
            }
            ++i;
        }
        return bid;
    }

    static BufferedImage convertToPremultiplied(BufferedImage bi) {
        DebugTool.assertError(bi.getType() == 2);
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage bid = new BufferedImage(w, h, 3);
        DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        DataBufferInt dbd = (DataBufferInt)bid.getRaster().getDataBuffer();
        int[] src = dbi.getData();
        int[] dest = dbd.getData();
        int n = w * h;
        int i = 0;
        while (i < n) {
            int pix = src[i];
            int a = pix >> 24 & 0xFF;
            int r = pix >> 16 & 0xFF;
            int g = pix >> 8 & 0xFF;
            int b = pix & 0xFF;
            r = r * a / 255;
            g = g * a / 255;
            b = b * a / 255;
            dest[i] = a << 24 | r << 16 | g << 8 | b;
            ++i;
        }
        return bid;
    }

    @Override
    public RasterImage create(RasterImage fi, Dimension2D scrnSize) {
        BufferedImage bis = fi.getBufferedImage();
        BufferedImage bid = this.create(bis);
        int x = fi.getOffsetX();
        int y = fi.getOffsetY();
        Point2D.Double pos = new Point2D.Double(this.scaleX * (double)x, this.scaleY * (double)y);
        return new RasterImage(bid, pos, fi.getDelayTime(), fi.getDisposalMethod(), fi.isGray());
    }

    public BufferedImage create(BufferedImage bi) {
        return this.filter(bi, null);
    }

    public BufferedImage filter(BufferedImage bi, BufferedImage bid) {
        BufferedImage bir;
        AffineTransform at = this.getTransform();
        AffineTransformOp ato = new AffineTransformOp(at, this.getATOInterpolation());
        if (bi.getType() == 2) {
            bi = ResizeOp.convertToPremultiplied(bi);
        }
        if ((bir = ato.filter(bi, bid)).getType() == 3) {
            bir = ResizeOp.convertBack(bir);
        }
        return bir;
    }

    @Override
    public Dimension2D getOperatedSize(int w, int h) {
        return new Dimension((int)Math.round(this.scaleX * (double)w), (int)Math.round(this.scaleY * (double)h));
    }

    public AffineTransform getTransform() {
        return AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
    }
}

