/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import java.awt.image.IndexColorModel;

final class PixelA {
    private double a = 0.0;
    private double r = 0.0;
    private double g = 0.0;
    private double b = 0.0;

    final void addA(int argb, double w) {
        double ww = w * 0.00392156862745098;
        double mm = ww * (double)(argb >> 24 & 0xFF);
        this.a += mm;
        this.r += mm * (double)(argb >> 16 & 0xFF);
        this.g += mm * (double)(argb >> 8 & 0xFF);
        this.b += mm * (double)(argb & 0xFF);
    }

    final void addA(PixelA pix, double w) {
        this.a += w * pix.a;
        this.r += w * pix.r;
        this.g += w * pix.g;
        this.b += w * pix.b;
    }

    final void addG(byte gray, double w) {
        this.a += w;
        double result = w * 0.00392156862745098 * (double)(gray & 0xFF);
        this.r += result;
        this.g += result;
        this.b += result;
    }

    final void addI(IndexColorModel icm, int pixel, double w) {
        double aa = 0.00392156862745098 * (double)icm.getAlpha(pixel);
        double am = aa * w;
        double mm = am * 0.00392156862745098;
        this.a += am;
        this.r += mm * (double)icm.getRed(pixel);
        this.g += mm * (double)icm.getGreen(pixel);
        this.b += mm * (double)icm.getBlue(pixel);
    }

    final void addR(int argb, double w) {
        double mm = w * 0.00392156862745098;
        this.a += w;
        this.r += mm * (double)(argb >> 16 & 0xFF);
        this.g += mm * (double)(argb >> 8 & 0xFF);
        this.b += mm * (double)(argb & 0xFF);
    }

    final int getA() {
        if (this.a <= 0.0) {
            return 0xFFFFFF;
        }
        int ia = (int)(this.a * 255.0 + 0.5);
        double aa = 255.0 / this.a;
        int ir = (int)(this.r * aa + 0.5);
        int ig = (int)(this.g * aa + 0.5);
        int ib = (int)(this.b * aa + 0.5);
        ia = Math.min(Math.max(ia, 0), 255);
        ir = Math.min(Math.max(ir, 0), 255);
        ig = Math.min(Math.max(ig, 0), 255);
        ib = Math.min(Math.max(ib, 0), 255);
        return ia << 24 | ir << 16 | ig << 8 | ib;
    }

    final byte getG() {
        if (this.a <= 0.0) {
            return -1;
        }
        int ig = (int)(this.g * 255.0 / this.a + 0.5);
        ig = Math.min(Math.max(ig, 0), 255);
        return (byte)ig;
    }

    final int getR() {
        if (this.a <= 0.0) {
            return 0xFFFFFF;
        }
        double aa = 255.0 / this.a;
        int ir = (int)(this.r * aa + 0.5);
        int ig = (int)(this.g * aa + 0.5);
        int ib = (int)(this.b * aa + 0.5);
        ir = Math.min(Math.max(ir, 0), 255);
        ig = Math.min(Math.max(ig, 0), 255);
        ib = Math.min(Math.max(ib, 0), 255);
        return ir << 16 | ig << 8 | ib;
    }
}

