/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.LineOp;
import com.ibm.etools.webedit.imagetool.internal.filter.PixelA;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;

public class LineOpG
implements LineOp {
    private boolean isDstOpaq = false;

    LineOpG(boolean opaqdst) {
        this.isDstOpaq = opaqdst;
    }

    @Override
    public void filterBiCubic(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy) {
        DataBufferByte sdbi = (DataBufferByte)bi.getRaster().getDataBuffer();
        byte[] src = sdbi.getData();
        int srcw = bi.getWidth();
        int is = ix[0];
        int ie = ix[dw * 4 - 1] + 1;
        PixelA[] work = new PixelA[ie - is];
        int x = is;
        while (x < ie) {
            PixelA v = new PixelA();
            v.addG(src[iy[0] * srcw + x], fy[0]);
            v.addG(src[iy[1] * srcw + x], fy[1]);
            v.addG(src[iy[2] * srcw + x], fy[2]);
            v.addG(src[iy[3] * srcw + x], fy[3]);
            work[x - is] = v;
            ++x;
        }
        int de = dx + dw;
        int dstw = bid.getWidth();
        if (this.isDstOpaq) {
            DataBufferByte ddbb = (DataBufferByte)bid.getRaster().getDataBuffer();
            byte[] dst = ddbb.getData();
            int x2 = dx;
            while (x2 < de) {
                PixelA sum = new PixelA();
                int x4 = x2 * 4;
                sum.addA(work[ix[x4 + 0] - is], fx[x2 * 4 + 0]);
                sum.addA(work[ix[x4 + 1] - is], fx[x2 * 4 + 1]);
                sum.addA(work[ix[x4 + 2] - is], fx[x2 * 4 + 2]);
                sum.addA(work[ix[x4 + 3] - is], fx[x2 * 4 + 3]);
                dst[dy * dstw + x2] = sum.getG();
                ++x2;
            }
        } else {
            DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
            int[] dst = ddbi.getData();
            int x3 = dx;
            while (x3 < de) {
                PixelA sum = new PixelA();
                int x4 = x3 * 4;
                sum.addA(work[ix[x4 + 0] - is], fx[x3 * 4 + 0]);
                sum.addA(work[ix[x4 + 1] - is], fx[x3 * 4 + 1]);
                sum.addA(work[ix[x4 + 2] - is], fx[x3 * 4 + 2]);
                sum.addA(work[ix[x4 + 3] - is], fx[x3 * 4 + 3]);
                dst[dy * dstw + x3] = sum.getA();
                ++x3;
            }
        }
    }

    @Override
    public void filterBiLinear(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy) {
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int srcw = bi.getWidth();
        int is = ix[0];
        int ie = ix[dw * 2 - 1] + 1;
        PixelA[] work = new PixelA[ie - is];
        int x = is;
        while (x < ie) {
            PixelA v = new PixelA();
            v.addG(src[iy[0] * srcw + x], fy[0]);
            v.addG(src[iy[1] * srcw + x], fy[1]);
            work[x - is] = v;
            ++x;
        }
        int de = dx + dw;
        int dstw = bid.getWidth();
        if (this.isDstOpaq) {
            DataBufferByte ddbb = (DataBufferByte)bid.getRaster().getDataBuffer();
            byte[] dst = ddbb.getData();
            int x2 = dx;
            while (x2 < de) {
                PixelA sum = new PixelA();
                int x22 = x2 * 2;
                sum.addA(work[ix[x22 + 0] - is], fx[x22 + 0]);
                sum.addA(work[ix[x22 + 1] - is], fx[x22 + 1]);
                dst[dy * dstw + x2] = sum.getG();
                ++x2;
            }
        } else {
            DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
            int[] dst = ddbi.getData();
            int x3 = dx;
            while (x3 < de) {
                PixelA sum = new PixelA();
                int x2 = x3 * 2;
                sum.addA(work[ix[x2 + 0] - is], fx[x2 + 0]);
                sum.addA(work[ix[x2 + 1] - is], fx[x2 + 1]);
                dst[dy * dstw + x3] = sum.getA();
                ++x3;
            }
        }
    }

    @Override
    public void filterConvolute(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] hk, double[] vk) {
        PixelA sum;
        int kw = hk.length;
        int kh = vk.length;
        int cx = kw / 2;
        int cy = kh / 2;
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int srch = bi.getHeight();
        PixelA[] tmp = new PixelA[dstw];
        int de = dx + dw;
        int co = dx;
        while (co < de) {
            sum = new PixelA();
            int y = 0;
            while (y < kh) {
                int sy = dy + y - cy;
                if (sy >= 0) {
                    if (sy >= srch) break;
                    sum.addG(src[sy * srcw + co], vk[y]);
                }
                ++y;
            }
            tmp[co] = sum;
            ++co;
        }
        co = dx;
        while (co < de) {
            sum = new PixelA();
            int x = 0;
            while (x < kw) {
                int sx = co + x - cx;
                if (sx >= 0) {
                    if (sx >= srcw) break;
                    sum.addA(tmp[sx], hk[x]);
                }
                ++x;
            }
            dst[dy * dstw + co] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++co;
        }
    }

    @Override
    public void filterConvolute(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, Kernel k) {
        int co;
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int srcw = bi.getWidth();
        int srch = bi.getHeight();
        int cx = k.getXOrigin();
        int cy = k.getYOrigin();
        int kw = k.getWidth();
        int kh = k.getHeight();
        float[] data = k.getKernelData(null);
        PixelA[] work = new PixelA[dw];
        int de = dx + dw;
        int co2 = dx;
        while (co2 < de) {
            PixelA sum = new PixelA();
            int y = 0;
            int i = 0;
            while (y < kh) {
                int sy = dy + y - cy;
                if (sy >= 0) {
                    if (sy >= srch) break;
                    int x = 0;
                    while (x < kw) {
                        int sx = co2 + x - cx;
                        if (sx >= 0) {
                            if (sx >= srcw) break;
                            sum.addG(src[sy * srcw + sx], data[y * kw + x]);
                        }
                        ++x;
                    }
                }
                ++y;
                ++i;
            }
            work[co2 - dx] = sum;
            ++co2;
        }
        int dstw = bid.getWidth();
        if (this.isDstOpaq) {
            DataBufferByte ddbb = (DataBufferByte)bid.getRaster().getDataBuffer();
            byte[] dst = ddbb.getData();
            co = dx;
            while (co < de) {
                dst[dy * dstw + co] = work[co - dx].getG();
                ++co;
            }
        } else {
            DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
            int[] dst = ddbi.getData();
            co = dx;
            while (co < de) {
                dst[dy * dstw + co] = work[co - dx].getA();
                ++co;
            }
        }
    }

    @Override
    public void filterZoomDown(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy, double zx, double zy) {
        int x;
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int srcw = bi.getWidth();
        double ww = zx * zy;
        int de = dx + dw;
        PixelA[] work = new PixelA[dw];
        int x2 = dx;
        while (x2 < de) {
            PixelA sum = new PixelA();
            int j = iy[0] + 1;
            while (j < iy[1]) {
                int i = ix[x2 * 2] + 1;
                while (i < ix[x2 * 2 + 1]) {
                    sum.addA(src[j * srcw + i], ww);
                    ++i;
                }
                sum.addG(src[j * srcw + ix[x2 * 2]], fx[x2 * 2] * zy);
                sum.addG(src[j * srcw + ix[x2 * 2 + 1]], fx[x2 * 2 + 1] * zy);
                ++j;
            }
            int i = ix[x2 * 2] + 1;
            while (i < ix[x2 * 2 + 1]) {
                sum.addG(src[iy[0] * srcw + i], fy[0] * zx);
                sum.addG(src[iy[1] * srcw + i], fy[1] * zx);
                ++i;
            }
            sum.addG(src[iy[0] * srcw + ix[x2 * 2]], fy[0] * fx[x2 * 2]);
            sum.addG(src[iy[0] * srcw + ix[x2 * 2 + 1]], fy[0] * fx[x2 * 2 + 1]);
            sum.addG(src[iy[1] * srcw + ix[x2 * 2]], fy[1] * fx[x2 * 2]);
            sum.addG(src[iy[1] * srcw + ix[x2 * 2 + 1]], fy[1] * fx[x2 * 2 + 1]);
            work[x2 - dx] = sum;
            ++x2;
        }
        int dstw = bid.getWidth();
        if (this.isDstOpaq) {
            DataBufferByte ddbb = (DataBufferByte)bid.getRaster().getDataBuffer();
            byte[] dst = ddbb.getData();
            x = dx;
            while (x < de) {
                dst[dy * dstw + x] = work[x].getG();
                ++x;
            }
        } else {
            DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
            int[] dst = ddbi.getData();
            x = dx;
            while (x < de) {
                dst[dy * dstw + x] = work[x].getA();
                ++x;
            }
        }
    }

    @Override
    public int[] getLeftRightEdge(BufferedImage bi, int y) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        if (y < 0 || y >= h) {
            return null;
        }
        int[] nArray = new int[2];
        nArray[1] = w;
        return nArray;
    }
}

