/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.BiCubicCalc;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOp;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpA;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpI;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpR;
import com.ibm.etools.webedit.imagetool.internal.filter.ResizeOp;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

public class HandyResizeOp
extends ResizeOp {
    private double reversalX = 1.0;
    private double reversalY = 1.0;

    public HandyResizeOp(double zx, double zy, int interpolation) {
        super(zx, zy, interpolation);
        this.reversalX = 1.0 / zx;
        this.reversalY = 1.0 / zy;
    }

    @Override
    public BufferedImage create(BufferedImage bi) {
        BufferedImage bid = this.createDestination(bi);
        return this.filter(bi, bid);
    }

    public BufferedImage createDestination(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int type = bi.getType();
        Dimension2D size = this.getOperatedSize(w, h);
        boolean index = (type = this.getDesinationType(type)) == 12 || type == 13;
        BufferedImage bid = null;
        w = (int)size.getWidth();
        h = (int)size.getHeight();
        bid = index ? new BufferedImage(w, h, type, (IndexColorModel)bi.getColorModel()) : new BufferedImage(w, h, type);
        return bid;
    }

    @Override
    public BufferedImage filter(BufferedImage bi, BufferedImage bid) {
        if (bi == bid) {
            ImageError.error(1);
        }
        if (this.interpolationType == 2) {
            return this.filterBiCubic(bi, bid);
        }
        if (this.interpolationType == 1) {
            return this.filterBiLinear(bi, bid);
        }
        return super.filter(bi, bid);
    }

    BufferedImage filterBiCubic(BufferedImage bi, BufferedImage bid) {
        boolean isDstOpaq;
        if (this.scaleX < 1.0 || this.scaleY < 1.0) {
            return this.filterZoomDown(bi, bid);
        }
        int stype = bi.getType();
        int dtype = bid.getType();
        LineOp operator = null;
        boolean bl = isDstOpaq = dtype == 1;
        if (stype == 2) {
            operator = new LineOpA(isDstOpaq);
        } else if (stype == 1) {
            operator = new LineOpR(isDstOpaq);
        } else if (stype == 13) {
            operator = new LineOpI(isDstOpaq);
        }
        if (operator == null) {
            return super.filter(bi, bid);
        }
        int sw = bi.getWidth();
        int dw = bid.getWidth();
        int sh = bi.getHeight();
        int dh = bid.getHeight();
        int x = 0;
        while (this.getSourceX(x + 1, 0.0) < 0.0) {
            ++x;
        }
        int dx0 = x;
        while (this.getSourceX(x, 0.0) < (double)sw && x < dw) {
            ++x;
        }
        int dxe = x;
        if (dxe <= dx0) {
            return bid;
        }
        double[] fx = new double[(dxe - dx0) * 4];
        int[] ix = new int[(dxe - dx0) * 4];
        BiCubicCalc calc = new BiCubicCalc(this.bicubicB, this.bicubicC);
        x = dx0;
        while (x < dxe) {
            double u = this.getSourceX((double)x + 0.5, 0.0) - 0.5;
            int iu = (int)Math.floor(u);
            double du = u - (double)iu;
            fx[x * 4] = calc.getWeight(1.0 + du);
            fx[x * 4 + 1] = calc.getWeight(du);
            fx[x * 4 + 2] = calc.getWeight(1.0 - du);
            fx[x * 4 + 3] = 1.0 - (fx[x * 4 + 0] + fx[x * 4 + 1] + fx[x * 4 + 2]);
            ix[x * 4] = iu - 1;
            ix[x * 4 + 1] = iu;
            ix[x * 4 + 2] = iu + 1;
            ix[x * 4 + 3] = iu + 2;
            if (iu < 1 || iu > sw) {
                fx[x * 4] = 0.0;
                ix[x * 4] = 0;
            }
            if (iu < 0 || iu > sw - 1) {
                fx[x * 4 + 1] = 0.0;
                ix[x * 4 + 1] = 0;
            }
            if (iu < -1 || iu > sw - 2) {
                fx[x * 4 + 2] = 0.0;
                ix[x * 4 + 2] = 0;
            }
            if (iu < -2 || iu > sw - 3) {
                fx[x * 4 + 3] = 0.0;
                ix[x * 4 + 3] = 0;
            }
            if (iu > sw - 3) {
                ix[x * 4 + 3] = sw - 1;
            }
            ++x;
        }
        int y = 0;
        while (this.getSourceY(0.0, y + 1) < 0.0) {
            ++y;
        }
        double[] fy = new double[4];
        int[] iy = new int[4];
        while (y < dh) {
            double v = this.getSourceY(0.0, (double)y + 0.5) - 0.5;
            int iv = (int)Math.floor(v);
            double dv = v - (double)iv;
            fy[0] = calc.getWeight(1.0 + dv);
            fy[1] = calc.getWeight(dv);
            fy[2] = calc.getWeight(1.0 - dv);
            fy[3] = 1.0 - (fy[0] + fy[1] + fy[2]);
            iy[0] = iv - 1;
            iy[1] = iv;
            iy[2] = iv + 1;
            iy[3] = iv + 2;
            if (iv < 1 || iv > sh) {
                fy[0] = 0.0;
                iy[0] = 0;
            }
            if (iv < 0 || iv > sh - 1) {
                fy[1] = 0.0;
                iy[1] = 0;
            }
            if (iv < -1 || iv > sh - 2) {
                fy[2] = 0.0;
                iy[2] = 0;
            }
            if (iv < -2 || iv > sh - 3) {
                fy[3] = 0.0;
                iy[3] = 0;
            }
            if (iv > sh) break;
            operator.filterBiCubic(bi, bid, dx0, dxe - dx0, y, fx, fy, ix, iy);
            ++y;
        }
        return bid;
    }

    BufferedImage filterBiLinear(BufferedImage bi, BufferedImage bid) {
        boolean isDstOpaq;
        if (this.scaleX < 1.0 || this.scaleY < 1.0) {
            return this.filterZoomDown(bi, bid);
        }
        int stype = bi.getType();
        int dtype = bid.getType();
        LineOp operator = null;
        boolean bl = isDstOpaq = dtype == 1;
        if (stype != 2) {
            if (stype == 1) {
                operator = new LineOpR(isDstOpaq);
            } else if (stype == 13) {
                operator = new LineOpI(isDstOpaq);
            }
        }
        if (operator == null) {
            return super.filter(bi, bid);
        }
        int sw = bi.getWidth();
        int dw = bid.getWidth();
        int sh = bi.getHeight();
        int dh = bid.getHeight();
        int x = 0;
        while (this.getSourceX(x + 1, 0.0) < 0.0) {
            ++x;
        }
        int dx0 = x;
        while (this.getSourceX(x, 0.0) < (double)sw && x < dw) {
            ++x;
        }
        int dxe = x;
        if (dxe <= dx0) {
            return bid;
        }
        double[] fx = new double[(dxe - dx0) * 2];
        int[] ix = new int[(dxe - dx0) * 2];
        x = dx0;
        while (x < dxe) {
            double u = this.getSourceX((double)x + 0.5, 0.0) - 0.5;
            int iu = (int)Math.floor(u);
            double du = u - (double)iu;
            fx[x * 2] = 1.0 - du;
            fx[x * 2 + 1] = du;
            ix[x * 2] = iu;
            ix[x * 2 + 1] = iu + 1;
            if (iu < 0 || iu > sw - 1) {
                fx[x * 2] = 0.0;
                ix[x * 2] = 0;
            }
            if (iu < -1 || iu > sw - 2) {
                fx[x * 2 + 1] = 0.0;
                ix[x * 2 + 1] = 0;
            }
            if (iu > sw - 2) {
                ix[x * 2 + 1] = sw - 1;
            }
            ++x;
        }
        int y = 0;
        while (this.getSourceY(0.0, y + 1) < 0.0) {
            ++y;
        }
        double[] fy = new double[4];
        int[] iy = new int[4];
        while (y < dh) {
            double v = this.getSourceY(0.0, (double)y + 0.5) - 0.5;
            int iv = (int)Math.floor(v);
            double dv = v - (double)iv;
            fy[0] = 1.0 - dv;
            fy[1] = dv;
            iy[0] = iv;
            iy[1] = iv + 1;
            if (iv < 0 || iv > sh - 1) {
                fy[0] = 0.0;
                iy[0] = 0;
            }
            if (iv < -1 || iv > sh - 2) {
                fy[1] = 0.0;
                iy[1] = 0;
            }
            if (iv > sh - 1) break;
            operator.filterBiLinear(bi, bid, dx0, dxe - dx0, y, fx, fy, ix, iy);
            ++y;
        }
        return bid;
    }

    BufferedImage filterZoomDown(BufferedImage bi, BufferedImage bid) {
        boolean isDstOpaq;
        int stype = bi.getType();
        int dtype = bid.getType();
        LineOp operator = null;
        boolean bl = isDstOpaq = dtype == 1;
        if (stype == 2) {
            operator = new LineOpA(isDstOpaq);
        } else if (stype == 1) {
            operator = new LineOpR(isDstOpaq);
        } else if (stype == 13) {
            operator = new LineOpI(isDstOpaq);
        }
        if (operator == null) {
            return super.filter(bi, bid);
        }
        int sw = bi.getWidth();
        int dw = bid.getWidth();
        int sh = bi.getHeight();
        int dh = bid.getHeight();
        int x = 0;
        while (this.getSourceX(x + 1, 0.0) < 0.0) {
            ++x;
        }
        int dx0 = x;
        while (this.getSourceX(x, 0.0) < (double)sw && x < dw) {
            ++x;
        }
        int dxe = x;
        if (dxe <= dx0) {
            return bid;
        }
        double[] fx = new double[(dxe - dx0) * 2];
        int[] ix = new int[(dxe - dx0) * 2];
        if (this.scaleX >= 1.0) {
            x = dx0;
            while (x < dxe) {
                double u = this.getSourceX((double)x + 0.5, 0.0) - 0.5;
                int iu = (int)Math.floor(u);
                double du = u - (double)iu;
                fx[(x - dx0) * 2] = 1.0 - du;
                fx[(x - dx0) * 2 + 1] = du;
                ix[(x - dx0) * 2] = iu;
                ix[(x - dx0) * 2 + 1] = iu + 1;
                if (iu < 0) {
                    fx[(x - dx0) * 2] = 0.0;
                    ix[(x - dx0) * 2] = 0;
                }
                if (iu >= sw - 1) {
                    fx[(x - dx0) * 2 + 1] = 0.0;
                    ix[(x - dx0) * 2 + 1] = sw - 1;
                }
                ++x;
            }
        } else {
            x = dx0;
            while (x < dxe) {
                double l = this.getSourceX(x, 0.0);
                double r = this.getSourceX(x + 1, 0.0);
                int il = (int)Math.floor(l);
                int ir = (int)Math.floor(r);
                double dl = l - (double)il;
                double dr = r - (double)ir;
                fx[(x - dx0) * 2] = (1.0 - dl) * this.scaleX;
                fx[(x - dx0) * 2 + 1] = dr * this.scaleX;
                ix[(x - dx0) * 2] = il;
                ix[(x - dx0) * 2 + 1] = ir;
                if (il < 0) {
                    fx[(x - dx0) * 2] = this.scaleX;
                    ix[(x - dx0) * 2] = 0;
                }
                if (ir >= sw) {
                    fx[(x - dx0) * 2 + 1] = this.scaleX;
                    ix[(x - dx0) * 2 + 1] = sw - 1;
                }
                ++x;
            }
        }
        int y = 0;
        while (this.getSourceY(0.0, y + 1) < 0.0) {
            ++y;
        }
        double[] fy = new double[2];
        int[] iy = new int[2];
        while (y < dh) {
            if (this.scaleY >= 1.0) {
                double v = this.getSourceY(0.0, (double)y + 0.5) - 0.5;
                int iv = (int)Math.floor(v);
                double dv = v - (double)iv;
                fy[0] = 1.0 - dv;
                fy[1] = dv;
                iy[0] = iv;
                iy[1] = iv + 1;
                if (iv < 0) {
                    fy[0] = 0.0;
                    iy[0] = 0;
                }
                if (iv >= sh - 1) {
                    fx[1] = 0.0;
                    ix[1] = sh - 1;
                }
                if (iv >= sh) {
                    break;
                }
            } else {
                double t = this.getSourceY(0.0, y);
                double b = this.getSourceY(0.0, y + 1);
                int it = (int)Math.floor(t);
                int ib = (int)Math.floor(b);
                double dt = t - (double)it;
                double db = b - (double)ib;
                fy[0] = (1.0 - dt) * this.scaleY;
                fy[1] = db * this.scaleY;
                iy[0] = it;
                iy[1] = ib;
                if (it < 0) {
                    fy[0] = this.scaleY;
                    iy[0] = 0;
                }
                if (ib >= sh) {
                    fy[1] = this.scaleY;
                    iy[1] = sh - 1;
                }
                if (it >= sh) break;
            }
            operator.filterZoomDown(bi, bid, dx0, dxe - dx0, y, fx, fy, ix, iy, this.scaleX, this.scaleY);
            ++y;
        }
        return bid;
    }

    public double getSourceX(double dx, double dy) {
        double u = dx * this.reversalX;
        return u;
    }

    public double getSourceY(double dx, double dy) {
        double u = dy * this.reversalY;
        return u;
    }
}

