/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.FilterOp;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class ButtonOp
extends FilterOp {
    int myDepth = 1;
    int myIntensity = 1;

    public ButtonOp(int depth, int intensity) {
        this.myDepth = depth;
        this.myIntensity = intensity;
    }

    static int adjustBrightness(int pix, int level) {
        int r = pix >>> 16 & 0xFF;
        int g = pix >>> 8 & 0xFF;
        int b = pix & 0xFF;
        g += level;
        int n = (r += level) < 0 ? 0 : (r = r > 255 ? 255 : r);
        int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
        b = b < 0 ? 0 : (b > 255 ? 255 : (b += level));
        return pix & 0xFF000000 | r << 16 | g << 8 | b;
    }

    @Override
    public BufferedImage filter(BufferedImage bi, BufferedImage bid) {
        int stype;
        if (bid == bi) {
            ImageError.error(1);
        }
        if ((stype = bi.getType()) != 1 && stype != 2) {
            stype = stype == 13 ? 2 : 1;
            bi = RasterImage.convertImage(bi, stype);
        }
        if (bid == null) {
            bid = RasterImage.convertImage(bi, stype);
        }
        this.filterButton(bid);
        return bid;
    }

    protected void filterButton(BufferedImage bi) {
        int pix;
        int x;
        int sw = bi.getWidth();
        int sh = bi.getHeight();
        int thickness = this.myDepth;
        int intensity = this.myIntensity;
        if (thickness < 0) {
            thickness = -thickness;
            intensity = -intensity;
        }
        int xc = sw / 2 - 1;
        int yc = sh / 2 - 1;
        if (thickness > xc) {
            thickness = xc;
        }
        if (thickness > yc) {
            thickness = yc;
        }
        DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        int[] data = dbi.getData();
        int y = 0;
        while (y < thickness) {
            x = 0;
            while (x < y) {
                pix = data[y * sw + x];
                data[y * sw + x] = ButtonOp.adjustBrightness(pix, 8 * intensity);
                ++x;
            }
            while (x < sw - y) {
                pix = data[y * sw + x];
                data[y * sw + x] = ButtonOp.adjustBrightness(pix, 16 * intensity);
                ++x;
            }
            while (x < sw) {
                pix = data[y * sw + x];
                data[y * sw + x] = ButtonOp.adjustBrightness(pix, -8 * intensity);
                ++x;
            }
            ++y;
        }
        while (y < sh - thickness) {
            x = 0;
            while (x < thickness) {
                pix = data[y * sw + x];
                data[y * sw + x] = ButtonOp.adjustBrightness(pix, 8 * intensity);
                ++x;
            }
            x = sw - thickness;
            while (x < sw) {
                pix = data[y * sw + x];
                data[y * sw + x] = ButtonOp.adjustBrightness(pix, -8 * intensity);
                ++x;
            }
            ++y;
        }
        while (y < sh) {
            x = 0;
            while (x < sh - y) {
                pix = data[y * sw + x];
                data[y * sw + x] = ButtonOp.adjustBrightness(pix, 8 * intensity);
                ++x;
            }
            while (x < sw + y - sh) {
                pix = data[y * sw + x];
                data[y * sw + x] = ButtonOp.adjustBrightness(pix, -16 * intensity);
                ++x;
            }
            while (x < sw) {
                pix = data[y * sw + x];
                data[y * sw + x] = ButtonOp.adjustBrightness(pix, -8 * intensity);
                ++x;
            }
            ++y;
        }
    }
}

