/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.HVKernel;

public class BlurKernel
extends HVKernel {
    public static final int BLUR_BOX = 1;
    public static final int BLUR_TRIANGLE = 2;
    public static final int BLUR_BELL = 3;
    public static final int BLUR_BSPLINE = 4;
    public static final int BLUR_LANCOS3 = 5;
    public static final int BLUR_MITCHELL = 6;

    public BlurKernel(int type, double strength) {
        this(type, strength, strength);
    }

    public BlurKernel(int type, double width, double height) {
        super(BlurKernel.createArray(type, width), BlurKernel.createArray(type, height));
    }

    public static double[] createArray(int type, double strength) {
        double[] array = null;
        if (strength <= 0.0) {
            array = new double[]{1.0};
        }
        int w = (int)(strength / 2.0);
        int ks = w * 2 + 1;
        array = new double[ks];
        abstract class Distribution {
            Distribution() {
            }

            abstract double getValue(double var1);

            abstract double getSupport();
        }
        Distribution dist = null;
        if (type == 1) {
            dist = new Distribution(){
                {
                }

                @Override
                double getValue(double d) {
                    return -0.5 < d && d <= 0.5 ? 1.0 : 0.0;
                }

                @Override
                double getSupport() {
                    return 0.5;
                }
            };
        } else if (type == 2) {
            dist = new Distribution(){
                {
                }

                @Override
                public double getValue(double d) {
                    if (d < 0.0) {
                        d = -d;
                    }
                    return d < 1.0 ? 1.0 - d : 0.0;
                }

                @Override
                double getSupport() {
                    return 1.0;
                }
            };
        } else if (type == 3) {
            dist = new Distribution(){
                {
                }

                @Override
                public double getValue(double d) {
                    if (d < 0.0) {
                        d = -d;
                    }
                    if (d < 0.5) {
                        return 0.75 - d * d;
                    }
                    if (d > 1.5) {
                        return 0.0;
                    }
                    return 0.5 * (d -= 1.5) * d;
                }

                @Override
                double getSupport() {
                    return 1.5;
                }
            };
        } else if (type == 4) {
            dist = new Distribution(){
                {
                }

                @Override
                public double getValue(double d) {
                    if (d < 0.0) {
                        d = -d;
                    }
                    if (d < 1.0) {
                        double dd = d * d;
                        return 0.5 * dd * d - dd + 0.6666666666666666;
                    }
                    if (d < 2.0) {
                        d = 2.0 - d;
                        return 0.16666666666666666 * d * d * d;
                    }
                    return 0.0;
                }

                @Override
                double getSupport() {
                    return 2.0;
                }
            };
        } else if (type == 5) {
            dist = new Distribution(){
                {
                }

                double sinc(double x) {
                    double px = x * Math.PI;
                    if (px != 0.0) {
                        return Math.sin(px) / px;
                    }
                    return 1.0;
                }

                @Override
                public double getValue(double d) {
                    if (d < 0.0) {
                        d = -d;
                    }
                    if (d < 3.0) {
                        return this.sinc(d) * this.sinc(d / 3.0);
                    }
                    return 0.0;
                }

                @Override
                double getSupport() {
                    return 3.0;
                }
            };
        } else if (type == 6) {
            dist = new Distribution(){
                static final double B = 0.3333333333333333;
                static final double C = 0.3333333333333333;
                {
                }

                @Override
                public double getValue(double d) {
                    if (d < 0.0) {
                        d = -d;
                    }
                    double dd = d * d;
                    if (d < 1.0) {
                        return (7.0 * (d * dd) + -12.0 * dd + 5.333333333333333) / 6.0;
                    }
                    if (d < 2.0) {
                        return (-2.3333333333333335 * (d * dd) + 12.0 * dd + -20.0 * d + 10.666666666666666) / 6.0;
                    }
                    return 0.0;
                }

                @Override
                double getSupport() {
                    return 2.0;
                }
            };
        }
        double total = 0.0;
        double s = dist.getSupport() / (strength * 0.5);
        int i = 0;
        while (i < ks) {
            double weight;
            array[i] = weight = dist.getValue(s * (double)(i - w));
            total += weight;
            ++i;
        }
        i = 0;
        while (i < ks) {
            array[i] = array[i] / total;
            ++i;
        }
        return array;
    }
}

