/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.color;

import com.ibm.etools.webedit.imagetool.internal.color.Colormap;
import com.ibm.etools.webedit.imagetool.internal.color.GrayColormap;
import com.ibm.etools.webedit.imagetool.internal.color.IndexErrorDiffused;
import com.ibm.etools.webedit.imagetool.internal.color.IndexNearestColor;
import com.ibm.etools.webedit.imagetool.internal.color.IndexOrderedDither;
import com.ibm.etools.webedit.imagetool.internal.color.LatticeColormap;
import com.ibm.etools.webedit.imagetool.internal.color.ReversibleColormap;
import com.ibm.etools.webedit.imagetool.internal.filter.FilterOp;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

public abstract class IndexOp
extends FilterOp {
    public static final int INDEXING_NEAREST_COLOR = 0;
    public static final int INDEXING_ORDERED_DITHER = 1;
    public static final int INDEXING_ERROR_DIFFUSION = 2;

    public static ReversibleColormap createColormap(int type, int ncolors, boolean transparent) {
        if (type == 1) {
            return IndexOp.createLatticeColormap(ncolors, transparent);
        }
        if (type == 2) {
            return IndexOp.createGrayColormap(ncolors, transparent);
        }
        ImageError.error(1);
        return null;
    }

    public static GrayColormap createGrayColormap(int ncolors, boolean transparent) {
        return new GrayColormap(ncolors, transparent);
    }

    public static BufferedImage createIndexImage(int w, int h, Colormap colormap) {
        int numColors = colormap.getNumColors();
        int[] cmap = new int[numColors];
        int i = 0;
        while (i < numColors) {
            cmap[i] = colormap.getColor(i);
            ++i;
        }
        int transPix = colormap.getTransparentIndex();
        if (transPix >= 0 && transPix < numColors) {
            int n = transPix;
            cmap[n] = cmap[n] & 0xFFFFFF;
        }
        IndexColorModel cm = new IndexColorModel(8, numColors, cmap, 0, true, transPix, 0);
        BufferedImage bid = new BufferedImage(w, h, 13, cm);
        return bid;
    }

    public static IndexOp createIndexOp(int type, ReversibleColormap colormap) {
        IndexOp indexop = null;
        if (type == 0) {
            indexop = new IndexNearestColor(colormap);
        } else if (type == 1) {
            indexop = new IndexOrderedDither(colormap);
        } else if (type == 2) {
            indexop = new IndexErrorDiffused(colormap);
        }
        return indexop;
    }

    public static LatticeColormap createLatticeColormap(int ncolors, boolean transparent) {
        if (ncolors >= 216) {
            return new LatticeColormap(6, 6, 6, transparent);
        }
        if (ncolors >= 180) {
            return new LatticeColormap(6, 6, 5, transparent);
        }
        if (ncolors >= 150) {
            return new LatticeColormap(5, 6, 5, transparent);
        }
        if (ncolors >= 125) {
            return new LatticeColormap(5, 5, 5, transparent);
        }
        if (ncolors >= 100) {
            return new LatticeColormap(5, 5, 4, transparent);
        }
        if (ncolors >= 80) {
            return new LatticeColormap(4, 5, 4, transparent);
        }
        if (ncolors >= 64) {
            return new LatticeColormap(4, 4, 4, transparent);
        }
        if (ncolors >= 48) {
            return new LatticeColormap(4, 4, 3, transparent);
        }
        if (ncolors >= 36) {
            return new LatticeColormap(3, 4, 3, transparent);
        }
        if (ncolors >= 27) {
            return new LatticeColormap(3, 3, 3, transparent);
        }
        if (ncolors >= 18) {
            return new LatticeColormap(3, 3, 2, transparent);
        }
        if (ncolors >= 12) {
            return new LatticeColormap(2, 3, 2, transparent);
        }
        if (ncolors >= 8) {
            return new LatticeColormap(2, 2, 2, transparent);
        }
        return null;
    }

    @Override
    public BufferedImage filter(BufferedImage bi, BufferedImage bid) {
        if (bid != null) {
            ImageError.error(1);
        }
        return this.filterIndex(bi);
    }

    abstract BufferedImage filterIndex(BufferedImage var1);
}

