/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.color;

import com.ibm.etools.webedit.imagetool.internal.color.Colormap;
import com.ibm.etools.webedit.imagetool.internal.color.ReversibleColormap;

public class GenericColormap
extends ReversibleColormap {
    static final int R_BITS = 5;
    static final int G_BITS = 5;
    static final int B_BITS = 5;
    static final int R_SHIFT = 3;
    static final int G_SHIFT = 3;
    static final int B_SHIFT = 3;
    static final int BOX3_R_LOG = 2;
    static final int BOX3_G_LOG = 2;
    static final int BOX3_B_LOG = 2;
    static final int BOX3_SHIFT = 5;
    static final int R_SCALE = 2;
    static final int G_SCALE = 3;
    static final int B_SCALE = 1;
    static final int MIN = 0;
    static final int MAX = 1;
    private short[][][] indexCache = null;
    private double span = 0.0;

    public GenericColormap(int[] colorarray, boolean transparent) {
        this.setup(colorarray, transparent);
    }

    static void calcMinMaxDistance(int[] distances, int x, int minc, int maxc, int centerc, int scale2) {
        int maxd;
        int mind = 0;
        if (x < minc) {
            mind = x - minc;
            maxd = x - maxc;
            distances[0] = distances[0] + mind * mind * scale2;
        } else if (x > maxc) {
            mind = x - maxc;
            maxd = x - minc;
            distances[0] = distances[0] + mind * mind * scale2;
        } else {
            maxd = x <= centerc ? x - maxc : x - minc;
        }
        distances[1] = distances[1] + maxd * maxd * scale2;
    }

    static double calculateSpan(int ncolors) {
        double level = Math.exp(Math.log(ncolors) / 3.0);
        level = Math.max(2.0, level);
        double span = 255.0 / (level - 1.0);
        span = Math.max(1.0, Math.min(255.0, span));
        return span;
    }

    public static int[] createColorArray(int[] colorarray, boolean transparent) {
        int ncolors = colorarray.length;
        if (ncolors >= 256) {
            transparent = false;
        }
        int alloc = ncolors;
        if (transparent) {
            ++alloc;
        }
        int[] cmap = new int[alloc];
        int i = 0;
        while (i < ncolors) {
            cmap[i] = colorarray[i];
            ++i;
        }
        if (transparent) {
            cmap[i] = 0xFFFFFF;
        }
        return cmap;
    }

    public static int[] createColorArray(Colormap colormap) {
        int ncolors = colormap.getNumColors();
        int[] cmap = new int[ncolors];
        int i = 0;
        while (i < ncolors) {
            cmap[i] = colormap.getColor(i);
            ++i;
        }
        return cmap;
    }

    void fillInverseColormap(int cr, int cg, int cb) {
        int[] colorlist = new int[256];
        int minr = ((cr >>= 2) << 5) + 4;
        int ming = ((cg >>= 2) << 5) + 4;
        int minb = ((cb >>= 2) << 5) + 4;
        int numcolors = this.findNearbyColors(minr, ming, minb, colorlist);
        this.findBestColors(minr, ming, minb, numcolors, colorlist);
    }

    void findBestColors(int minr, int ming, int minb, int ncolors, int[] colorlist) {
        int cr = minr >> 5 << 2;
        int cg = ming >> 5 << 2;
        int cb = minb >> 5 << 2;
        int[][][] best_dist = new int[4][4][4];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                int k = 0;
                while (k < 4) {
                    best_dist[i][j][k] = Integer.MAX_VALUE;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ncolors) {
            int icolor = colorlist[i];
            int color = this.getColor(icolor);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int inc0 = (minr - r) * 2;
            int inc1 = (ming - g) * 3;
            int inc2 = (minb - b) * 1;
            int dist0 = inc0 * inc0 + inc1 * inc1 + inc2 * inc2;
            inc0 = inc0 * 32 + 256;
            inc1 = inc1 * 48 + 576;
            inc2 = inc2 * 16 + 64;
            int xx0 = inc0;
            int ic0 = 0;
            while (ic0 < 4) {
                int dist1 = dist0;
                int xx1 = inc1;
                int ic1 = 0;
                while (ic1 < 4) {
                    int dist2 = dist1;
                    int xx2 = inc2;
                    int ic2 = 0;
                    while (ic2 < 4) {
                        if (dist2 < best_dist[ic0][ic1][ic2]) {
                            best_dist[ic0][ic1][ic2] = dist2;
                            this.indexCache[cr + ic0][cg + ic1][cb + ic2] = (short)icolor;
                        }
                        dist2 += xx2;
                        xx2 += 128;
                        ++ic2;
                    }
                    dist1 += xx1;
                    xx1 += 1152;
                    ++ic1;
                }
                dist0 += xx0;
                xx0 += 512;
                ++ic0;
            }
            ++i;
        }
    }

    int findNearbyColors(int minr, int ming, int minb, int[] colorlist) {
        int num_colors = this.getNumColors();
        int[] mindist = new int[256];
        int maxr = minr + 24;
        int maxg = ming + 24;
        int maxb = minb + 24;
        int centerr = minr + maxr >> 1;
        int centerg = ming + maxg >> 1;
        int centerb = minb + maxb >> 1;
        int minmaxdist = Integer.MAX_VALUE;
        int[] distances = new int[2];
        int i = 0;
        while (i < num_colors) {
            int color = this.getColor(i);
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            distances[0] = 0;
            distances[1] = 0;
            if (a > 0) {
                GenericColormap.calcMinMaxDistance(distances, r, minr, maxr, centerr, 4);
                GenericColormap.calcMinMaxDistance(distances, g, ming, maxg, centerg, 9);
                GenericColormap.calcMinMaxDistance(distances, b, minb, maxb, centerb, 1);
            } else {
                distances[0] = Integer.MAX_VALUE;
                distances[1] = Integer.MAX_VALUE;
            }
            mindist[i] = distances[0];
            if (distances[1] < minmaxdist) {
                minmaxdist = distances[1];
            }
            ++i;
        }
        int ncolors = 0;
        int i2 = 0;
        while (i2 < num_colors) {
            if (mindist[i2] <= minmaxdist) {
                colorlist[ncolors++] = i2;
            }
            ++i2;
        }
        return ncolors;
    }

    @Override
    public int getFluctuatedIndex(int r, int g, int b, double factor) {
        int fl = (int)(factor * this.span);
        int ir = r + fl;
        int ig = g + fl;
        int ib = b + fl;
        ir = Math.max(0, Math.min(255, ir));
        ig = Math.max(0, Math.min(255, ig));
        ib = Math.max(0, Math.min(255, ib));
        return this.getNearestIndex(ir, ig, ib);
    }

    @Override
    public int getNearestIndex(int r, int g, int b) {
        int br = r >>> 3;
        int bg = g >>> 3;
        int bb = b >>> 3;
        short index = this.indexCache[br][bg][bb];
        if (index < 0) {
            this.fillInverseColormap(br, bg, bb);
            index = this.indexCache[br][bg][bb];
        }
        return index;
    }

    void initIndexCache() {
        int rsize = 32;
        int gsize = 32;
        int bsize = 32;
        this.indexCache = new short[rsize][gsize][bsize];
        int r = 0;
        while (r < rsize) {
            int g = 0;
            while (g < gsize) {
                int b = 0;
                while (b < bsize) {
                    this.indexCache[r][g][b] = -1;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
    }

    public void setup(int[] colorarray, boolean transparent) {
        this.myColormap = GenericColormap.createColorArray(colorarray, transparent);
        this.span = GenericColormap.calculateSpan(colorarray.length);
        this.initIndexCache();
    }

    public void setup(Colormap colormap) {
        this.myColormap = GenericColormap.createColorArray(colormap);
        this.span = GenericColormap.calculateSpan(colormap.getNumColors());
        this.initIndexCache();
    }
}

