/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool;

import com.ibm.etools.webedit.imagetool.ImageException;
import com.ibm.etools.webedit.imagetool.internal.filter.ConvoluteHVOp;
import com.ibm.etools.webedit.imagetool.internal.filter.ConvoluteOp;
import com.ibm.etools.webedit.imagetool.internal.filter.CropOp;
import com.ibm.etools.webedit.imagetool.internal.filter.GenericKernel;
import com.ibm.etools.webedit.imagetool.internal.filter.HVKernel;
import com.ibm.etools.webedit.imagetool.internal.filter.HandyConvoluteHVOp;
import com.ibm.etools.webedit.imagetool.internal.filter.HandyConvoluteOp;
import com.ibm.etools.webedit.imagetool.internal.filter.ImageOp;
import com.ibm.etools.webedit.imagetool.internal.filter.OrientOp;
import com.ibm.etools.webedit.imagetool.internal.filter.ResizeOp;
import com.ibm.etools.webedit.imagetool.internal.filter.RotateOp;
import com.ibm.etools.webedit.imagetool.internal.filter.SizeOp;
import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.filter.TrimOp;
import com.ibm.etools.webedit.imagetool.internal.image.AnimContext;
import com.ibm.etools.webedit.imagetool.internal.image.AnimImage;
import com.ibm.etools.webedit.imagetool.internal.image.Frame;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.IMultiFrame;
import com.ibm.etools.webedit.imagetool.internal.image.ImageProperties;
import com.ibm.etools.webedit.imagetool.internal.io.EncodingOptions;
import com.ibm.etools.webedit.imagetool.internal.io.HandyImageReader;
import com.ibm.etools.webedit.imagetool.internal.io.HandyImageWriter;
import com.ibm.etools.webedit.imagetool.internal.tools.DebugTool;
import com.ibm.etools.webedit.imagetool.internal.tools.MarkableInputStream;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ImageAgent {
    private HandyImageReader myImageReader = null;
    private HandyImage myImage = null;
    private ImageProperties myProperties = null;

    protected ImageAgent() {
    }

    public ImageAgent(HandyImage image) {
        this(image, null);
    }

    public ImageAgent(HandyImage image, ImageProperties prop) {
        this.myImage = image;
        this.myProperties = prop;
    }

    public ImageAgent(InputStream input, boolean load) throws IOException, ImageException {
        this.myImage = null;
        this.setInputStream(input, load);
    }

    public ImageAgent(String filename, boolean load) throws IOException, ImageException {
        this.myImage = null;
        this.setInputFile(filename, load);
    }

    public boolean ableToGetPropOnly_() {
        return this.myImageReader != null && this.myImageReader.ableToGetPropOnly();
    }

    public void convolute(GenericKernel kernel) {
        ConvoluteOp conv = DebugTool.preferJava2D ? new ConvoluteOp(kernel) : new HandyConvoluteOp(kernel);
        this.myImage = this.myImage.create(conv);
    }

    public void convolute(HVKernel hvk) {
        ConvoluteHVOp conv = DebugTool.preferJava2D ? new ConvoluteHVOp(hvk) : new HandyConvoluteHVOp(hvk);
        this.myImage = this.myImage.create(conv);
    }

    public AnimContext createAnimContext() {
        return this.isAnimatable() ? this.myImage.createAnimContext() : null;
    }

    public ImageData createImageData() {
        Frame fi = this.getFrame();
        if (fi == null) {
            return null;
        }
        return fi.createImageData();
    }

    public void crop(Rectangle2D cropRect) {
        CropOp crop = new CropOp(cropRect);
        this.myImage = this.myImage.create(crop);
    }

    public void draw(GC gc, Display display, int ix, int iy, float xscale, float yscale, boolean transparent) {
        this.draw(gc, display, ix, iy, 0, 0, -1, -1, xscale, yscale, !transparent);
    }

    public void draw(GC gc, Display display, int ix, int iy, int clipx, int clipy, int clipw, int cliph, double xzoom, double yzoom, boolean forceOpaque) {
        Frame fi = this.getFrame();
        if (fi == null) {
            return;
        }
        fi.draw(gc, display, ix, iy, clipx, clipy, clipw, cliph, xzoom, yzoom, forceOpaque);
    }

    public void filter(ImageOp filter) {
        this.myImage = this.myImage.create(filter);
    }

    public AnimImage getAnimImage() {
        return this.myImage instanceof AnimImage ? (AnimImage)this.myImage : null;
    }

    public int getAverageColor() {
        Frame frame = this.getFrame();
        return frame != null ? frame.getAverageColor() : 0;
    }

    public BufferedImage getBufferedImage() {
        Frame hi = this.getFrame();
        return hi != null ? hi.getBufferedImage() : null;
    }

    public Frame getFrame() {
        return this.myImage != null ? this.myImage.getFrame() : null;
    }

    public int getFrameIndex() {
        if (!(this.myImage instanceof IMultiFrame)) {
            return 0;
        }
        IMultiFrame mf = (IMultiFrame)((Object)this.myImage);
        return mf.getFrameIndex();
    }

    public int getHeight() {
        return this.myImage != null ? this.myImage.getHeight() : 0;
    }

    public ImageProperties getImageProperties() {
        if (this.myProperties == null && this.myImageReader != null) {
            this.myProperties = this.myImageReader.getImageProperties();
        }
        return this.myProperties;
    }

    public int getNumFrames() {
        if (this.myImage == null) {
            return 0;
        }
        if (!(this.myImage instanceof IMultiFrame)) {
            return 1;
        }
        IMultiFrame mf = (IMultiFrame)((Object)this.myImage);
        return mf.getNumFrames();
    }

    public int getRepeatCount() {
        return this.myImage != null ? this.myImage.getRepeatCount() : 0;
    }

    public int getType() {
        if (this.myImage == null) {
            return -1;
        }
        return this.myImage.getType();
    }

    public int getWidth() {
        return this.myImage != null ? this.myImage.getWidth() : 0;
    }

    public boolean isAnimatable() {
        return this.myImage != null && this.myImage.isAnimation();
    }

    public boolean isOpaque() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return false;
        }
        return frame.isOpaque();
    }

    public boolean loadImage() throws IOException, ImageException {
        if (this.myImage == null && this.myImageReader != null) {
            this.myImage = this.myImageReader.getImage();
        }
        return this.myImage != null;
    }

    public boolean loadThumbnail(int width, int height) throws IOException, ImageException {
        return this.loadThumbnail(width, height, 1, true);
    }

    public boolean loadThumbnail(int width, int height, int zoomtype, boolean nogrow) throws IOException, ImageException {
        this.myImage = this.myImageReader.getThumbnail(width, height, zoomtype, nogrow);
        return this.myImage != null;
    }

    public void orient(int orientation) {
        OrientOp orient = new OrientOp(orientation);
        this.myImage = this.myImage.create(orient);
    }

    public void reset() {
        this.myImage = null;
        this.myProperties = null;
        this.myImageReader = null;
    }

    public void resize(double zx, double zy, int mode) {
        ResizeOp resize = TransformOp.createResizeOp(zx, zy, mode);
        this.myImage = this.myImage.create(resize);
    }

    public void rotate(double radian, int mode) {
        RotateOp rotate = new RotateOp(radian, mode);
        this.myImage = this.myImage.create(rotate);
    }

    public boolean saveImage(OutputStream output, int format) throws IOException {
        if (this.myImage == null) {
            return false;
        }
        HandyImageWriter writer = HandyImageWriter.createImageWriter(output, format);
        if (writer == null) {
            return false;
        }
        return writer.saveImage(this.myImage);
    }

    public boolean saveImage(OutputStream output, EncodingOptions options) throws IOException {
        if (this.myImage == null) {
            return false;
        }
        HandyImageWriter writer = HandyImageWriter.createImageWriter(output, options.getImageFormat());
        if (writer == null) {
            return false;
        }
        return writer.saveImage(this.myImage);
    }

    public boolean saveImage(String filename, int format) throws IOException {
        if (this.myImage == null) {
            return false;
        }
        HandyImageWriter writer = HandyImageWriter.createImageWriter(filename, format);
        if (writer == null) {
            return false;
        }
        return writer.saveImage(this.myImage);
    }

    public boolean saveImage(String filename, EncodingOptions options) throws IOException {
        if (this.myImage == null) {
            return false;
        }
        HandyImageWriter writer = HandyImageWriter.createImageWriter(filename, options.getImageFormat());
        if (writer == null) {
            return false;
        }
        writer.setEncodingOptions(options);
        return writer.saveImage(this.myImage);
    }

    public boolean setInputFile(String filename, boolean loadImage) throws IOException, ImageException {
        FileInputStream input = new FileInputStream(filename);
        try {
            boolean bl = this.setInputStream(input, loadImage);
            return bl;
        }
        catch (ImageException e) {
            int err = e.getErrorCode();
            if (err != 101) {
                throw e;
            }
        }
        finally {
            ((InputStream)input).close();
        }
        this.myImageReader = HandyImageReader.createImageReader(filename);
        if (this.myImageReader == null) {
            ImageException.error(101);
        }
        if (!loadImage) {
            return true;
        }
        this.myImage = this.myImageReader.getImage();
        return this.myImage != null;
    }

    public boolean setInputStream(InputStream input, boolean loadImage) throws IOException, ImageException {
        if (!input.markSupported()) {
            input = new MarkableInputStream(input);
        }
        this.reset();
        this.myImageReader = HandyImageReader.createImageReader(input);
        if (this.myImageReader == null) {
            ImageException.error(101);
        }
        this.myImage = loadImage ? this.myImageReader.getImage() : null;
        return !loadImage || this.myImage != null;
    }

    public void size(int width, int height, int zoomtype, boolean nogrow, int interpolation) {
        SizeOp size = new SizeOp(width, height, zoomtype, nogrow, interpolation);
        this.myImage = this.myImage.create(size);
    }

    public void trim(boolean shrink) {
        TrimOp trim = new TrimOp();
        this.myImage = this.myImage.create(trim);
        if (shrink) {
            this.myImage.shrink();
        }
    }

    public int getImageFormat() {
        if (this.myImageReader == null) {
            return 0;
        }
        return this.myImageReader.getImageFormat();
    }
}

