/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.frame;

import com.ibm.etools.webedit.frame.FrameLayoutNode;
import com.ibm.etools.webedit.frame.FrameLayouter;
import com.ibm.etools.webedit.frame.FrameManager;
import com.ibm.etools.webedit.frame.FrameManagerListener;
import com.ibm.etools.webedit.frame.FrameNode;
import com.ibm.etools.webedit.frame.FrameSetNode;
import com.ibm.etools.webedit.frame.FrameView;
import com.ibm.etools.webedit.frame.FrameViewFactory;
import com.ibm.etools.webedit.viewer.internal.frame.FrameLayoutNodeImpl;
import com.ibm.etools.webedit.viewer.internal.frame.FrameManagerImpl;
import java.util.Vector;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FrameLayouterImpl
implements FrameLayouter,
FrameManagerListener {
    private FrameLayoutNodeImpl top;
    private FrameManager manager = new FrameManagerImpl();
    private Rectangle bounds;
    private FrameViewFactory viewFactory;

    @Override
    public void boundsChanged() {
        if (this.top != null) {
            this.top.setBounds(this.bounds);
        }
    }

    @Override
    public void marginsChanged() {
        if (this.top != null) {
            this.top.updateMargins();
        }
    }

    @Override
    public void dispose() {
        this.manager.removeListener(this);
        this.disposeLayoutNode();
        this.manager.dispose();
    }

    private void disposeLayoutNode() {
        if (this.top != null) {
            this.top.dispose();
            this.top = null;
        }
    }

    private FrameLayoutNode find(FrameLayoutNode node, FrameNode fnode) {
        if (node == null) {
            return null;
        }
        if (node.getFrameNode() == fnode) {
            return node;
        }
        FrameLayoutNode[] children = node.getChildPanes();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                FrameLayoutNode n = this.find(children[i], fnode);
                if (n != null) {
                    return n;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public FrameLayoutNode find(FrameNode fnode) {
        if (this.top == null) {
            return null;
        }
        return this.find(this.top, fnode);
    }

    @Override
    public FrameView[] getAllViews() {
        Vector views = new Vector();
        FrameLayoutNodeImpl n = this.top;
        this.getViews(n, views);
        if (views.size() == 0) {
            return null;
        }
        FrameView[] ret = new FrameView[views.size()];
        views.toArray(ret);
        return ret;
    }

    @Override
    public FrameManager getFrameManager() {
        return this.manager;
    }

    @Override
    public FrameLayoutNode getTopLayoutNode() {
        return this.top;
    }

    @Override
    public FrameViewFactory getViewFactory() {
        return this.viewFactory;
    }

    private void getViews(FrameLayoutNode node, Vector views) {
        FrameLayoutNode[] children;
        if (node == null) {
            return;
        }
        FrameView v = node.getView();
        if (v != null) {
            views.add(v);
        }
        if ((children = node.getChildPanes()) == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            this.getViews(children[i], views);
            ++i;
        }
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        if (this.top != null) {
            this.top.setBounds(bounds);
        }
    }

    @Override
    public void setModel(IDOMModel model) {
        this.manager.setModel(model);
        this.updatePanes();
        this.manager.addListener(this);
    }

    @Override
    public FrameViewFactory setViewFactory(FrameViewFactory viewFactory) {
        FrameViewFactory f = this.viewFactory;
        this.viewFactory = viewFactory;
        return f;
    }

    @Override
    public void structureChanged() {
        this.updatePanes();
    }

    private void updatePanes() {
        if (this.manager.isFrame()) {
            FrameSetNode node = this.manager.getTop();
            if (this.top == null) {
                this.top = new FrameLayoutNodeImpl(null, this, 0);
                this.top.setBounds(this.bounds);
            }
            this.top.setFrameNode(node);
        } else {
            this.disposeLayoutNode();
        }
    }
}

