/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.style.jsp;

import com.ibm.etools.webedit.viewer.WebEditViewerPlugin;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class CustomTagStyleAdapterRegistryReader {
    private static final String pluginId = WebEditViewerPlugin.getDefault().getBundle().getSymbolicName();
    private static final String EXTENSION_POINT_ID = "customTagStyleAdapterContribution";
    private static final String TAGLIB = "taglib";
    private static final String DEFAULT_CLASS = "default-class";
    private static final String URI = "uri";
    private static final String TAG = "tag";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private Map uriToNameList = new HashMap();
    private Map uriToDefaultClass = new HashMap();
    private Map uriToNameConfMap = new HashMap();
    private List uriList = new ArrayList();
    private boolean hasAdapter;
    private Map confToContributor = new HashMap();

    private void clearMaps() {
        this.uriToNameList.clear();
        this.uriToDefaultClass.clear();
        this.uriToNameConfMap.clear();
        this.uriList.clear();
        this.confToContributor.clear();
    }

    private Object createContributor(IConfigurationElement ce, String uri) {
        if (ce == null || uri == null) {
            return null;
        }
        Object obj = null;
        try {
            if (ce.getAttribute(CLASS) != null) {
                obj = ce.createExecutableExtension(CLASS);
            } else if (this.uriToDefaultClass.containsKey(uri)) {
                obj = ((IConfigurationElement)ce.getParent()).createExecutableExtension(DEFAULT_CLASS);
            }
        }
        catch (CoreException e) {
            obj = null;
            Logger.log("CoreException: " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            obj = null;
            Logger.log("NoClassDefFoundError: " + e.getMessage());
        }
        return obj;
    }

    public List getUriList() {
        return this.uriList;
    }

    public Object getProperty(String uri, String tagName, String propName) {
        if (propName == null) {
            return null;
        }
        IConfigurationElement ce = this.getConfigurationElement(uri, tagName);
        if (ce == null) {
            return null;
        }
        return ce.getAttribute(propName);
    }

    private IConfigurationElement getConfigurationElement(String uri, String tagName) {
        String name = tagName.toLowerCase(Locale.US);
        List nameList = (List)this.uriToNameList.get(uri);
        if (nameList == null || !nameList.contains(name)) {
            return null;
        }
        Map nameConfMap = (Map)this.uriToNameConfMap.get(uri);
        IConfigurationElement ce = nameConfMap != null ? (IConfigurationElement)nameConfMap.get(name) : null;
        return ce;
    }

    public boolean hasAdapter() {
        return this.hasAdapter;
    }

    public Object getContributor(String uri, String tagName) {
        IConfigurationElement ce = this.getConfigurationElement(uri, tagName);
        if (ce == null) {
            return null;
        }
        Object contributor = this.confToContributor.get(ce);
        if (contributor != null) {
            return contributor;
        }
        contributor = this.createContributor(ce, uri);
        if (contributor != null) {
            this.confToContributor.put(ce, contributor);
        }
        return contributor;
    }

    protected void readRegistry() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        if (reg == null) {
            return;
        }
        IConfigurationElement[] conf = reg.getConfigurationElementsFor(String.valueOf(pluginId) + "." + EXTENSION_POINT_ID);
        if (conf == null || conf.length <= 0) {
            return;
        }
        this.hasAdapter = true;
        this.clearMaps();
        int confIndex = 0;
        while (confIndex < conf.length) {
            String uri;
            IConfigurationElement currentConf = conf[confIndex];
            String confName = currentConf.getName();
            if (confName.equalsIgnoreCase(TAGLIB) && (uri = currentConf.getAttribute(URI)) != null) {
                IConfigurationElement[] confChildren;
                this.uriList.add(uri);
                String defaultClass = currentConf.getAttribute(DEFAULT_CLASS);
                if (defaultClass != null) {
                    this.uriToDefaultClass.put(uri, defaultClass);
                }
                if ((confChildren = currentConf.getChildren(TAG)) != null) {
                    HashMap<String, IConfigurationElement> nameConfMap;
                    ArrayList<String> nameList = (ArrayList<String>)this.uriToNameList.get(uri);
                    if (nameList == null) {
                        nameList = new ArrayList<String>();
                    }
                    if ((nameConfMap = (HashMap<String, IConfigurationElement>)this.uriToNameConfMap.get(uri)) == null) {
                        nameConfMap = new HashMap<String, IConfigurationElement>();
                    }
                    int childIndex = 0;
                    while (childIndex < confChildren.length) {
                        IConfigurationElement confChild = confChildren[childIndex];
                        String name = confChild.getAttribute(NAME);
                        name = name.toLowerCase(Locale.US);
                        nameList.add(name);
                        nameConfMap.put(name, confChild);
                        ++childIndex;
                    }
                    this.uriToNameList.put(uri, nameList);
                    this.uriToNameConfMap.put(uri, nameConfMap);
                }
            }
            ++confIndex;
        }
    }
}

