/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.style;

import com.ibm.etools.webedit.editparts.style.CSSQueryDeclarationData;
import com.ibm.etools.webedit.editparts.style.CSSQueryValueData;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import com.ibm.etools.xve.renderer.utils.URLContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.eclipse.wst.css.core.internal.util.CSSLinkConverter;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.css.CSSValue;

public class CSSQueryContext
extends CSSPropertyContext {
    private static final String URL_BEGIN = "url(";
    private static final String URL_END = ")";
    protected URLContext baseContext;

    public CSSQueryContext(URLContext context) {
        this.baseContext = context;
    }

    public void applyFull(ICSSStyleDeclaration decl) {
        if (decl == null) {
            return;
        }
        Enumeration enm = this.fProperties.keys();
        while (enm.hasMoreElements()) {
            String value;
            ICSSStyleDeclItem itemToRemove;
            Object key = enm.nextElement();
            Object val = this.fProperties.get(key);
            if (val instanceof CSSQueryDeclarationData) {
                ICSSStyleDeclItem declItem = ((CSSQueryDeclarationData)((Object)val)).getDeclItem();
                if (declItem.getLength() <= 0) {
                    itemToRemove = decl.getDeclItemNode(key.toString());
                    if (itemToRemove == null) continue;
                    decl.removeDeclItemNode(itemToRemove);
                    continue;
                }
                decl.setDeclItemNode(declItem);
                continue;
            }
            String string = value = val instanceof ICSSValue ? ((ICSSValue)val).getCSSValueText() : val.toString();
            if (value == null || value.length() <= 0) {
                itemToRemove = decl.getDeclItemNode(key.toString());
                if (itemToRemove == null) continue;
                decl.removeDeclItemNode(itemToRemove);
                continue;
            }
            decl.setProperty(key.toString(), value, null);
        }
    }

    private boolean check(String propName, boolean important, int specificity) {
        Object current = this.fProperties.get(propName);
        if (current != null && current instanceof CSSQueryValueData) {
            CSSQueryValueData currentValue = (CSSQueryValueData)((Object)current);
            if (!important && currentValue.important || currentValue.getSpecificity() > specificity) {
                return false;
            }
        }
        return true;
    }

    URLContext getContext(ICSSStyleDeclaration decl) {
        ICSSModel model = decl.getOwnerDocument().getModel();
        if (model instanceof ICSSModel && model.getStyleSheetType() != "externalCSS") {
            return this.baseContext;
        }
        Path path = new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)model));
        return new URLContext((IPath)path){
            private final /* synthetic */ IPath val$path;
            {
                this.val$path = iPath;
            }

            public IPath getFileBase() {
                return this.val$path;
            }

            public IPath getPageBase() {
                return this.val$path;
            }

            public IPath getLinkBase() {
                return this.val$path;
            }
        };
    }

    public void overrideWithExpand(ICSSStyleDeclaration decl, int specificity) {
        if (decl == null) {
            return;
        }
        URLContext currentContext = this.getContext(decl);
        int nProperties = decl.getLength();
        int i = 0;
        while (i < nProperties) {
            String propN;
            String propName = decl.item(i);
            if (propName != null && (propN = propName.trim().toLowerCase()).length() != 0) {
                boolean important;
                PropCMProperty prop = PropCMProperty.getInstanceOf((String)propN);
                String priority = decl.getPropertyPriority(propName);
                boolean bl = important = priority != null && priority.length() > 0;
                if (prop != null && prop.isShorthand()) {
                    CSSQueryContext context = new CSSQueryContext(this.baseContext);
                    CSSQueryContext.expandToLeaf((PropCMProperty)prop, (String)decl.getPropertyValue(propName), (CSSPropertyContext)context);
                    Enumeration enm = context.properties();
                    while (enm.hasMoreElements()) {
                        propN = enm.nextElement().toString();
                        if (!this.check(propN, important, specificity)) continue;
                        this.fProperties.put(propN, new CSSQueryValueData(this.toAbsolute(currentContext, context.get(propN)), important, specificity));
                    }
                } else if (this.check(propN, important, specificity)) {
                    ICSSStyleDeclItem declItem = (ICSSStyleDeclItem)decl.getDeclItemNode(propName).cloneNode(true);
                    int nValues = declItem.getLength();
                    int j = 0;
                    while (j < nValues) {
                        this.toAbsolute(currentContext, declItem.item(j));
                        ++j;
                    }
                    declItem.setPriority(null);
                    this.fProperties.put(propN, new CSSQueryDeclarationData(declItem, important, specificity));
                }
            }
            ++i;
        }
    }

    protected String toAbsolute(URLContext context, String source) {
        if (CSSQueryContext.isUrl(source)) {
            String absLink;
            String rawUrl = CSSLinkConverter.stripFunc((String)source);
            if (CSSQueryContext.isExternalWithoutProtocol(rawUrl)) {
                rawUrl = "http:" + rawUrl;
            }
            if ((absLink = LinkUtil.getAbsURL(context.getLinkBase(), context.getPageBase(), rawUrl, true)) != null) {
                String url;
                block6: {
                    url = absLink;
                    if (absLink != null) {
                        try {
                            new URL(absLink);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Path path = new Path(absLink);
                            if (path == null) break block6;
                            url = FileURL.getURL((IPath)path);
                        }
                    }
                }
                return CSSLinkConverter.addFunc((String)url);
            }
            return "url()";
        }
        return source;
    }

    private static boolean isUrl(String source) {
        if (source == null) {
            return false;
        }
        source = source.trim().toLowerCase();
        return source.startsWith(URL_BEGIN);
    }

    protected boolean toAbsolute(URLContext context, CSSValue node) {
        ICSSPrimitiveValue value;
        if (node instanceof ICSSPrimitiveValue && (value = (ICSSPrimitiveValue)node).getPrimitiveType() == 20) {
            value.setValue(CSSLinkConverter.stripFunc((String)this.toAbsolute(context, URL_BEGIN + value.getStringValue() + URL_END)));
            return true;
        }
        return false;
    }

    static boolean isExternalWithoutProtocol(String uri) {
        try {
            URI u = new URI(uri);
            return u.getScheme() == null && u.getHost() != null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

