/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.style;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.OffRenderingEditPart;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.viewer.internal.utils.ElementAliasUtil;
import com.ibm.etools.xve.renderer.style.StyleOwner;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.StringTokenizer;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorCombinator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CSSGraphicalSelectorMatcher {
    public static boolean match(ICSSSelectorList selectors, ElementEditPart editPart, String pseudoName) {
        Element e;
        String nodeName = null;
        String attrId = null;
        String attrClass = null;
        if (editPart != null && (e = editPart.getElement()) != null) {
            nodeName = e.getNodeName();
            attrId = e.getAttribute("id");
            attrClass = e.getAttribute("class");
        }
        int i = 0;
        while (i < selectors.getLength()) {
            if (CSSGraphicalSelectorMatcher.match(selectors.getSelector(i), editPart, pseudoName, nodeName, attrId, attrClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean match(ICSSSelector selector, ElementEditPart editPart, String pseudoName) {
        String str;
        Element e;
        String nodeName = null;
        String attrId = null;
        String attrClass = null;
        if (editPart != null && (e = editPart.getElement()) != null) {
            nodeName = e.getNodeName();
            attrId = e.getAttribute("id");
            attrClass = e.getAttribute("class");
        }
        if (nodeName != null && nodeName.compareToIgnoreCase("A") == 0 && (str = selector.getString()).endsWith(":link")) {
            return CSSGraphicalSelectorMatcher.match(selector, editPart, "link", nodeName, attrId, attrClass);
        }
        return CSSGraphicalSelectorMatcher.match(selector, editPart, pseudoName, nodeName, attrId, attrClass);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean match(ICSSSelector selector, ElementEditPart editPart, String pseudoName, String nodeName, String attrId, String attrClass) {
        target = editPart;
        combinatorType = 63;
        chunkStartEditPart = null;
        chunkStartItem = -1;
        chunkImplicitNode = null;
        numItems = selector.getLength();
        iItem = numItems - 1;
        while (iItem >= 0) {
            block18: {
                block19: {
                    block16: {
                        block17: {
                            item = selector.getItem(iItem);
                            if (item == null || item.getItemType() != 1) break block16;
                            if (target != null || chunkImplicitNode != null) break block17;
                            if (!((ICSSSimpleSelector)item).isUniversal()) {
                                return false;
                            }
                            break block18;
                        }
                        v0 = element = target != null ? target.getElement() : chunkImplicitNode;
                        if (CSSGraphicalSelectorMatcher.matchExactly((ICSSSimpleSelector)item, element, pseudoName)) break block18;
                        switch (combinatorType) {
                            case 32: {
                                do {
                                    current = target;
                                    if ((target = CSSGraphicalSelectorMatcher.getParentEditPart(target)) == null) {
                                        chunkImplicitNode = CSSGraphicalSelectorMatcher.getImplicitParent(current);
                                    }
                                    if (target != null || chunkImplicitNode != null || (chunkImplicitNode = CSSGraphicalSelectorMatcher.getHtmlNode(current)) != null) continue;
                                    return false;
                                } while (!CSSGraphicalSelectorMatcher.matchExactly((ICSSSimpleSelector)item, target != null ? target.getElement() : chunkImplicitNode, pseudoName));
                                break block18;
                            }
                            case 43: 
                            case 62: {
                                if (chunkStartEditPart == null || chunkStartEditPart == editPart) ** GOTO lbl36
                                target = CSSGraphicalSelectorMatcher.getParentEditPart(chunkStartEditPart);
                                iItem = chunkStartItem + 1;
                                chunkStartEditPart = null;
                                chunkStartItem = -1;
                                combinatorType = 32;
                                break block18;
                            }
lbl36:
                            // 2 sources

                            default: {
                                return false;
                            }
                        }
                    }
                    if (item == null || item.getItemType() != 2) break block19;
                    if (iItem == numItems - 1) {
                        return false;
                    }
                    sc = (ICSSSelectorCombinator)item;
                    combinatorType = sc.getCombinatorType();
                    switch (combinatorType) {
                        case 32: {
                            current = target;
                            target = CSSGraphicalSelectorMatcher.getParentEditPart(target);
                            if (target == null && (chunkImplicitNode = CSSGraphicalSelectorMatcher.getImplicitParent(current)) == null) {
                                chunkImplicitNode = CSSGraphicalSelectorMatcher.getHtmlNode(current);
                                break;
                            }
                            break block18;
                        }
                        case 43: 
                        case 62: {
                            if (chunkStartEditPart == null) {
                                chunkStartEditPart = target;
                                chunkStartItem = iItem + 1;
                            }
                            if (combinatorType != 62) ** GOTO lbl62
                            current = target;
                            if ((target = CSSGraphicalSelectorMatcher.getParentEditPart(target)) == null && (chunkImplicitNode = CSSGraphicalSelectorMatcher.getImplicitParent(current)) == null) {
                                chunkImplicitNode = CSSGraphicalSelectorMatcher.getHtmlNode(current);
                                break;
                            }
                            break block18;
lbl62:
                            // 1 sources

                            target = CSSGraphicalSelectorMatcher.getPreviousEditPart(target);
                        }
                    }
                    break block18;
                }
                return false;
            }
            --iItem;
        }
        return true;
    }

    private static Element getImplicitParent(ElementEditPart part) {
        if (part == null) {
            return null;
        }
        Element ele = part.getElement();
        if (ele == null) {
            return null;
        }
        String name = ElementAliasUtil.aliasName(ele);
        if (name == null) {
            name = ele.getNodeName();
        }
        if (name.equalsIgnoreCase("BODY")) {
            return null;
        }
        return ele.getOwnerDocument().createElement("BODY");
    }

    private static Element getHtmlNode(ElementEditPart part) {
        if (part == null) {
            return null;
        }
        ElementEditPart editPart = part;
        while (editPart != null) {
            EditPart parent = editPart.getParent();
            if (parent instanceof OffRenderingEditPart) {
                Node node = ((OffRenderingEditPart)parent).getNode();
                if (!(node instanceof Element)) {
                    return null;
                }
                String name = ((Element)node).getTagName();
                if (name == null) {
                    return null;
                }
                if (name.equalsIgnoreCase("HTML")) {
                    return (Element)node;
                }
                if ((name = ElementAliasUtil.aliasName(name)) == null) {
                    return null;
                }
                if (name.equalsIgnoreCase("HTML")) {
                    return (Element)node;
                }
            } else if (!(parent instanceof DocumentEditPart)) {
                return null;
            }
            editPart = parent;
        }
        Element ele = part.getElement();
        if (ele == null) {
            return null;
        }
        return ele.getOwnerDocument().createElement("HTML");
    }

    private static ElementEditPart getParentEditPart(ElementEditPart element) {
        ElementEditPart part = element;
        while (part != null) {
            EditPart parent = part.getParent();
            if (parent instanceof ElementEditPart) {
                if (PartAnalyzer.isStyleSheetTarget(parent)) {
                    return (ElementEditPart)parent;
                }
            } else if (!(parent instanceof DocumentEditPart)) {
                return null;
            }
            part = parent;
        }
        return null;
    }

    private static ElementEditPart getPreviousEditPart(ElementEditPart element) {
        ElementEditPart owner = element;
        while (owner != null) {
            StyleOwner newOwner = null;
            if (!PartAnalyzer.isStyleSheetTarget((EditPart)owner)) {
                ElementEditPart current = owner;
                while (current != null) {
                    newOwner = current.getPreviousSiblingStyleOwner();
                    if (newOwner == null) {
                        if (PartAnalyzer.isStyleSheetTarget((EditPart)(current = current.getParentStyleOwner()))) continue;
                        return null;
                    }
                    break;
                }
            } else {
                List children = ((EditPart)owner).getChildren();
                if (children != null && children.size() > 0) {
                    int i = children.size() - 1;
                    while (i >= 0) {
                        EditPart child = (EditPart)children.get(i);
                        if (child instanceof StyleOwner) {
                            newOwner = (StyleOwner)child;
                            break;
                        }
                        --i;
                    }
                }
            }
            if (newOwner instanceof ElementEditPart && !PartAnalyzer.isStyleSheetTarget((EditPart)newOwner)) {
                return (ElementEditPart)newOwner;
            }
            owner = newOwner;
        }
        return null;
    }

    private static boolean matchExactly(ICSSSimpleSelector selector, Element element, String pseudoName) {
        if (element == null || selector == null) {
            return false;
        }
        String aliasName = ElementAliasUtil.aliasName(element);
        if (aliasName != null) {
            Element newElement = element.getOwnerDocument().createElement(aliasName);
            NamedNodeMap map = element.getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                Attr attr = (Attr)map.item(i);
                newElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
                ++i;
            }
            element = newElement;
        }
        return CSSGraphicalSelectorMatcher.matchPatterns(selector, element, pseudoName);
    }

    private static boolean matchPatterns(ICSSSimpleSelector selector, Element element, String pseudoName) {
        if (element == null) {
            return false;
        }
        if (!CSSGraphicalSelectorMatcher.matchPseudoName(selector, pseudoName)) {
            return false;
        }
        if (!selector.isUniversal() && !element.getNodeName().equalsIgnoreCase(selector.getName())) {
            return false;
        }
        if (!CSSGraphicalSelectorMatcher.matchAttrId(selector, element, null)) {
            return false;
        }
        if (!CSSGraphicalSelectorMatcher.matchAttrClass(selector, element, null)) {
            return false;
        }
        return CSSGraphicalSelectorMatcher.matchAttributes(selector, element);
    }

    private static boolean matchPseudoName(ICSSSimpleSelector selector, String pseudoName) {
        int i = selector.getNumOfPseudoNames();
        if (i > 0) {
            if (pseudoName == null || pseudoName.length() == 0) {
                return false;
            }
            --i;
            while (i >= 0) {
                if (pseudoName.equalsIgnoreCase(selector.getPseudoName(i))) break;
                --i;
            }
            if (i < 0) {
                return false;
            }
        }
        return true;
    }

    private static boolean matchAttrId(ICSSSimpleSelector selector, Element element, String key) {
        int i = selector.getNumOfIDs();
        if (i > 0) {
            if (i > 1) {
                return false;
            }
            if (element != null) {
                key = element.getAttribute("id");
            }
            if (key == null) {
                return false;
            }
            if (!selector.getID(0).equalsIgnoreCase(key)) {
                return false;
            }
        }
        return true;
    }

    private static boolean matchAttrClass(ICSSSimpleSelector selector, Element element, String key) {
        int i = selector.getNumOfClasses();
        if (i > 0) {
            if (element != null) {
                key = element.getAttribute("class");
            }
            if (key == null) {
                return false;
            }
            StringTokenizer tokenizer = new StringTokenizer(key, new UnicodeSet("[ \t\n\r\f<>]", false));
            --i;
            while (i >= 0) {
                boolean ok = false;
                while (tokenizer.hasMoreTokens()) {
                    if (!selector.getClass(i).equalsIgnoreCase(tokenizer.nextToken())) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    private static boolean matchAttributes(ICSSSimpleSelector selector, Element element) {
        int i = selector.getNumOfAttributes() - 1;
        while (i >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(selector.getAttribute(i), "=~| \t\r\n\f");
            int countTokens = tokenizer.countTokens();
            if (countTokens > 0) {
                String attrValue = element.getAttribute(tokenizer.nextToken());
                if (attrValue == null) {
                    return false;
                }
                if (countTokens > 1) {
                    String token = tokenizer.nextToken("= \t\r\n\f");
                    StringTokenizer attrValueTokenizer = null;
                    if (token.equals("~")) {
                        attrValueTokenizer = new StringTokenizer(attrValue);
                    } else if (token.equals("|")) {
                        attrValueTokenizer = new StringTokenizer(attrValue, "-");
                    }
                    if (attrValueTokenizer != null) {
                        if (tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            boolean ok = false;
                            while (attrValueTokenizer.hasMoreTokens()) {
                                if (!token.equals(attrValueTokenizer.nextToken())) continue;
                                ok = true;
                                break;
                            }
                            if (!ok) {
                                return false;
                            }
                        }
                    } else if (!attrValue.equals(token)) {
                        return false;
                    }
                }
            }
            --i;
        }
        return true;
    }
}

