/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.design;

import com.ibm.etools.webedit.editparts.design.IDesignTimeTagAdapter;
import com.ibm.etools.webedit.editparts.design.IDesignTimeTagAdapterInContext;
import com.ibm.etools.webedit.editparts.design.IDesignTimeTagAdapterWithContext;
import com.ibm.etools.webedit.editparts.design.TaglibDirectiveHandler;
import com.ibm.etools.webedit.editparts.visualizer.IVisualizerViewContext;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Node;

public class DesignTimeTagUtil {
    public static final String VTAG_EMPTY_BODY_CONTENT = "emptyBodyContent";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";

    public static boolean isBodyContentEmpty(Node node) {
        String attributeValue = DesignTimeTagUtil.getString(node, VTAG_EMPTY_BODY_CONTENT);
        if (attributeValue != null) {
            return attributeValue.equalsIgnoreCase(VALUE_TRUE);
        }
        return false;
    }

    public static String getString(Node node, String attributeName) {
        Object attributeValue = DesignTimeTagUtil.getAttribute(node, attributeName);
        if (attributeValue != null && attributeValue instanceof String) {
            return ((String)attributeValue).trim();
        }
        return null;
    }

    public static Object getAttribute(Node node, String attributeName) {
        if (node == null || attributeName == null) {
            return null;
        }
        IDesignTimeTagAdapter dttAdapter = DesignTimeTagUtil.getDesignTimeTagAdapter(node);
        if (dttAdapter != null) {
            return dttAdapter.getAttribute(attributeName);
        }
        return null;
    }

    public static IDesignTimeTagAdapter getDesignTimeTagAdapter(Node node) {
        if (node instanceof INodeNotifier) {
            return (IDesignTimeTagAdapterWithContext)((INodeNotifier)node).getAdapterFor(IDesignTimeTagAdapter.class);
        }
        return null;
    }

    public static IDesignTimeTagAdapterInContext getDesignTimeTagAdapter(Node node, IVisualizerViewContext viewContext) {
        IDesignTimeTagAdapterWithContext a;
        if (node instanceof INodeNotifier && (a = (IDesignTimeTagAdapterWithContext)((INodeNotifier)node).getAdapterFor(IDesignTimeTagAdapter.class)) != null) {
            return a.getDTTAInContext(viewContext);
        }
        return null;
    }

    public static TaglibDirectiveHandler getTaglibDirectiveHandler(Node node) {
        if (node instanceof INodeNotifier) {
            return (TaglibDirectiveHandler)((INodeNotifier)node).getAdapterFor(TaglibDirectiveHandler.class);
        }
        return null;
    }
}

