/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.editparts.ViewerUtil;
import com.ibm.etools.webedit.editparts.VisibleNodeEditPart;
import com.ibm.etools.webedit.editparts.design.PartTypeManager;
import com.ibm.etools.xve.renderer.figures.FigureFactory;
import com.ibm.etools.xve.renderer.figures.ITextFigure;
import com.ibm.etools.xve.renderer.style.ContainerStyle;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LabeledContainer;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextEditPart
extends VisibleNodeEditPart {
    private Runnable updateModelRunnable;

    @Override
    public void activate() {
        super.activate();
        try {
            ITextFigure tf = (ITextFigure)this.getFigure();
            tf.setText(((Text)this.getNode()).getData());
            this.setMask(tf);
        }
        catch (ClassCastException classCastException) {}
    }

    public void clearSelection() {
        ITextFigure tf = (ITextFigure)this.getFigure();
        tf.clearSelection();
    }

    protected IFigure createFigure() {
        FigureFactory factory = this.getFigureFactory();
        if (factory != null) {
            return factory.createFigure((EditPart)this);
        }
        return null;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        DragTracker tracker = null;
        if (tracker == null && "selection".equals(request.getType())) {
            tracker = super.getDragTracker(request);
        }
        return tracker;
    }

    protected LabeledContainer getLabeledContainer() {
        return (LabeledContainer)this.getFigure();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (PartAnalyzer.isOrphan((EditPart)this)) {
            return;
        }
        if (eventType == 1) {
            this.refreshFromModel(notifier);
        } else if (eventType == 4) {
            this.updateStructure(notifier);
        }
    }

    @Override
    protected void refreshFromModel() {
        String t;
        Object n;
        String s;
        IFigure f = this.getFigure();
        if (f instanceof ITextFigure && ((s = ((ITextFigure)f).getOriginalText()) == null || s.length() == 0) && (n = this.getNodeObject(this.getModel())) instanceof Node && (t = ((Node)n).getNodeValue()) != null && t.length() > 0) {
            this.refreshFromModel(null);
        }
    }

    protected void refreshFromModel(Object property) {
        this.updateModel();
    }

    private void updateModel() {
        if (this.updateModelRunnable != null) {
            return;
        }
        this.updateModelRunnable = new Runnable(){

            @Override
            public void run() {
                TextEditPart.this.updateModelRunnable = null;
                TextEditPart.this.updateModelBody();
            }
        };
        if (Display.getDefault() != Display.getCurrent()) {
            Display.getDefault().syncExec(this.updateModelRunnable);
        } else {
            this.updateModelRunnable.run();
        }
    }

    private void updateModelBody() {
        String oldText;
        Text textNode = (Text)this.getNode();
        ITextFigure tf = (ITextFigure)this.getFigure();
        String newText = textNode.getData();
        if (!newText.equals(oldText = tf.getOriginalText())) {
            tf.setText(newText);
            this.getFigure().revalidate();
        }
        this.setMask(tf);
        this.getFigure().repaint();
    }

    @Override
    public String toString() {
        return "Node(" + this.getNode().getNodeName() + ")";
    }

    protected void updateStructure(Object property) {
    }

    @Override
    public void updateVisual(boolean update_myself, boolean update_children, boolean update_structure, boolean force) {
    }

    @Override
    public void resetStyles(boolean reset_children) {
    }

    @Override
    public void updateContainer(ContainerStyle cs) {
    }

    private void setMask(ITextFigure tf) {
        boolean isMaskMode = false;
        PartTypeManager mgr = ViewerUtil.getPartTypeManager((EditPart)this);
        if (mgr != null) {
            isMaskMode = mgr.isMaskedPart((EditPart)this);
        }
        tf.setMask(isMaskMode);
    }

    @Override
    public void updateMask(boolean update_children) {
        try {
            ITextFigure tf = (ITextFigure)this.getFigure();
            this.setMask(tf);
        }
        catch (ClassCastException classCastException) {}
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

            public void getName(AccessibleEvent e) {
                Node node = TextEditPart.this.getNode();
                if (node != null) {
                    String str = node.getNodeName();
                    if (str != null && node.getNodeType() == 3) {
                        str = String.valueOf(str) + "(" + node.getNodeValue() + ")";
                    }
                    e.result = str;
                }
            }
        };
    }
}

