/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.DocumentOwner;
import com.ibm.etools.webedit.editparts.EditPartIterator;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalRootEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewerImpl;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.editparts.SelectionHandler;
import com.ibm.etools.webedit.editparts.SelectionHandlerFactory;
import com.ibm.etools.webedit.editparts.SelectionOwner;
import com.ibm.etools.webedit.editparts.ViewerUtil;
import com.ibm.etools.webedit.editparts.adapter.SubModelAdapter;
import com.ibm.etools.webedit.editparts.adapter.SubModelAdapterFactory;
import com.ibm.etools.webedit.editparts.design.DesignTimeTagManager;
import com.ibm.etools.webedit.editparts.design.DesignTimeTagUtil;
import com.ibm.etools.webedit.editparts.design.IDesignTimeTagAdapterInContext;
import com.ibm.etools.webedit.editparts.design.IVisualizerAdapterListener;
import com.ibm.etools.webedit.editparts.visualizer.IVisualizerViewContext;
import com.ibm.etools.webedit.render.style.ViewOption;
import com.ibm.etools.webedit.viewer.internal.HTMLEmbeddedDocPartFactory;
import com.ibm.etools.webedit.viewer.internal.utils.ElementAliasUtil;
import com.ibm.etools.webedit.viewer.utils.OffRenderingUtil;
import com.ibm.etools.xve.renderer.figures.FigureFactory;
import com.ibm.etools.xve.renderer.style.ContainerStyle;
import com.ibm.etools.xve.viewer.EditPolicyFactoryRegistry;
import com.ibm.etools.xve.viewer.XMLNodeEditPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OffRenderingEditPart
extends NodeEditPart
implements INodeAdapter,
IVisualizerAdapterListener,
SelectionOwner,
DocumentOwner {
    private IDesignTimeTagAdapterInContext dtadapter = null;
    private boolean isRefreshNeeded = false;
    private HTMLEmbeddedDocPartFactory viewFactory;
    private SubModelAdapter subModelAdapter;

    protected void addChildVisual(EditPart childEditPart, int index) {
        List list = OffRenderingUtil.getVisualChildren(childEditPart);
        if (list.size() > 0) {
            EditPart target = OffRenderingUtil.getVisualParent(this.getParent());
            int i = 0;
            while (i < list.size()) {
                this.addChildVisual(target, (EditPart)list.get(i));
                ++i;
            }
        }
    }

    private void addChildVisual(EditPart parentEditPart, EditPart childEditPart) {
        EditPartIterator iterator = new EditPartIterator(childEditPart);
        iterator.prev();
        IFigure parent = ((GraphicalEditPart)parentEditPart).getContentPane();
        int insert = 0;
        while (iterator.hasPrev()) {
            EditPart prev = iterator.prev();
            IFigure fig = ((GraphicalEditPart)prev).getFigure();
            int i = parent.getChildren().indexOf(fig);
            if (i == -1) continue;
            if (i != parent.getChildren().size() - 1) {
                insert = i + 1;
                break;
            }
            insert = -1;
            break;
        }
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (!parent.getChildren().contains(child)) {
            parent.add(child, insert);
        }
    }

    private Document getEmbeddedDocument() {
        ViewOption viewOption = ViewerUtil.getViewOption((EditPart)this);
        if (viewOption != null && !viewOption.showEmbeddedDocument()) {
            return null;
        }
        SubModelAdapter handler = this.getSubModelAdapter();
        if (handler == null || handler.isLoop()) {
            return null;
        }
        IDOMModel subModel = handler.getModel();
        return subModel != null ? subModel.getDocument() : null;
    }

    @Override
    public EditPart createDocumentEditPart(Document embeddedDoc) {
        if (embeddedDoc == null) {
            return null;
        }
        if (this.viewFactory == null) {
            this.viewFactory = new HTMLEmbeddedDocPartFactory();
        }
        IDOMModel subModel = ((IDOMNode)embeddedDoc).getModel();
        this.viewFactory.setModel(subModel);
        this.viewFactory.setDesignTimeTagManager(ViewerUtil.getDesignTimeTagManager((EditPart)this));
        EditPart part = this.viewFactory.getViewPart();
        this.viewFactory.setVisualizerContext(this.getVisualizerContext());
        this.viewFactory.setModel(null);
        if (part instanceof NodeEditPart && ((DocumentEditPart)part).getVisualizerContext() == null) {
            ((DocumentEditPart)part).setRootVisualizerContext(this.getVisualizerContext());
        }
        return part;
    }

    protected void createEditPolicies() {
        EditPartViewer viewer = this.getViewer();
        if (viewer instanceof HTMLGraphicalViewerImpl) {
            EditPolicyFactoryRegistry reg = ((HTMLGraphicalViewerImpl)viewer).getPolicyFactoryRegistry();
            reg.installEditPolicies((EditPart)this);
        }
    }

    private boolean isHtml(Node node) {
        if (node != null && node.getNodeType() == 1) {
            return "HTML".equalsIgnoreCase(node.getNodeName()) || "HTML".equalsIgnoreCase(ElementAliasUtil.aliasName(node.getNodeName()));
        }
        return false;
    }

    protected List getModelChildren() {
        List modelChildren = this.getAllModelChildren();
        int numChild = modelChildren.size();
        if (numChild > 0 && !this.isHtml(this.getNode())) {
            int i = numChild - 1;
            while (i >= 0) {
                if (((Node)modelChildren.get(i)).getNodeType() == 3) {
                    modelChildren.remove(i);
                }
                --i;
            }
        }
        return this.convertToNodeWrapper(modelChildren);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        List list = OffRenderingUtil.getVisualChildren(childEditPart);
        if (list.size() > 0) {
            EditPart target = OffRenderingUtil.getVisualParent(this.getParent());
            IFigure parent = ((GraphicalEditPart)target).getContentPane();
            int i = 0;
            while (i < list.size()) {
                EditPart p = (EditPart)list.get(i);
                IFigure child = ((GraphicalEditPart)p).getFigure();
                if (parent.getChildren().contains(child)) {
                    parent.remove(child);
                }
                ++i;
            }
        }
    }

    protected IFigure createFigure() {
        FigureFactory factory = this.getFigureFactory();
        if (factory != null) {
            return factory.createFigure((EditPart)this);
        }
        return null;
    }

    public void setLayoutConstraint(EditPart childEditPart, IFigure childFigure, Object constraint) {
        List list = OffRenderingUtil.getVisualChildren(childEditPart);
        if (list.size() > 0) {
            EditPart target = OffRenderingUtil.getVisualParent(this.getParent());
            IFigure parent = ((GraphicalEditPart)target).getContentPane();
            int i = 0;
            while (i < list.size()) {
                EditPart p = (EditPart)list.get(i);
                IFigure child = ((GraphicalEditPart)p).getFigure();
                if (parent.getChildren().contains(child)) {
                    parent.setConstraint(child, constraint);
                }
                ++i;
            }
        }
    }

    public DragTracker getDragTracker(Request arg0) {
        return null;
    }

    @Override
    public void visualizerChanged(boolean update_children) {
        if (this.getDesignTimeTagAdapter() != null) {
            this.updateVisual(true, update_children, true, false);
        }
    }

    public void activate() {
        super.activate();
        Node model = this.getNode();
        if (model instanceof INodeNotifier) {
            ((INodeNotifier)model).addAdapter((INodeAdapter)this);
        }
    }

    @Override
    public void deactivate() {
        DesignTimeTagManager dm;
        if (this.dtadapter != null) {
            this.dtadapter.removeListener(this);
        }
        super.deactivate();
        Node model = this.getNode();
        if (model instanceof INodeNotifier) {
            ((INodeNotifier)model).removeAdapter((INodeAdapter)this);
        }
        if (this.viewFactory != null) {
            this.viewFactory.dispose();
            this.viewFactory = null;
        }
        if (this.subModelAdapter != null) {
            this.subModelAdapter.dispose();
        }
        this.subModelAdapter = DISPOSED_SUBMODEL_ADAPTER;
        DocumentEditPart doc = PartAnalyzer.getDocumentEditPart((EditPart)this);
        if (doc != null && (dm = doc.getDesignTimeTagManager()) != null) {
            IDesignTimeTagAdapterInContext da = dm.getDesignTimeTagAdapter(this.getNode(), null, this.getVisualizerViewContext());
            if (da != null) {
                da.clearChildMap();
            } else {
                dm.removeChildMapEntry((Document)doc.getNode(), this.getNode());
            }
        }
    }

    public boolean isAdapterForType(Object arg0) {
        return false;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (PartAnalyzer.isOrphan((EditPart)this)) {
            return;
        }
        if (eventType == 1) {
            RootEditPart rootPart = this.getRoot();
            if (rootPart instanceof HTMLGraphicalRootEditPart) {
                ((HTMLGraphicalRootEditPart)rootPart).updateStyle(this, changedFeature, oldValue, newValue);
            }
            if (this.getDesignTimeTagAdapter() != null) {
                this.updateVisual(false, false, true, false);
            } else if (this.getSubModelAdapter() != null && ViewerUtil.getViewOption((EditPart)this).showEmbeddedDocument()) {
                this.getSubModelAdapter().refresh();
                this.removeAllChidlren();
                this.updateVisual(true, false, true, false);
            }
        } else if (eventType == 4) {
            HTMLGraphicalViewerImpl viewer;
            RootEditPart root;
            this.clearDocumentBodies();
            this.eraseUnusedNodeMap();
            if (ViewerUtil.getViewOption((EditPart)this).isVisualizingTag() && (root = this.getRoot()) != null && (viewer = (HTMLGraphicalViewerImpl)root.getViewer()) != null && viewer.isNeededRereshChildren()) {
                viewer.setRefreshChildrenFlag(false);
                viewer.setStructureChangedFlag(true);
                try {
                    OffRenderingEditPart.updateVisualIfNeeded((EditPart)this);
                }
                finally {
                    viewer.setStructureChangedFlag(false);
                }
            }
        } else if (eventType != 5) {
            this.clearDocumentBodies();
            if (ViewerUtil.getViewOption((EditPart)this).isVisualizingTag()) {
                HTMLGraphicalViewerImpl viewer;
                RootEditPart root;
                DesignTimeTagManager mgr;
                Document doc;
                DocumentEditPart dep = PartAnalyzer.getDocumentEditPart((EditPart)this);
                if (dep != null && (doc = (Document)dep.getNode()) != null && (mgr = ViewerUtil.getDesignTimeTagManager((EditPart)this)) != null) {
                    mgr.notifyChanged(doc, this.getNode(), oldValue, newValue, this.getVisualizerViewContext());
                }
                if (this.getDesignTimeTagAdapter() != null && (root = this.getRoot()) != null && (viewer = (HTMLGraphicalViewerImpl)root.getViewer()) != null) {
                    viewer.setRefreshChildrenFlag(true);
                    this.isRefreshNeeded = true;
                    return;
                }
            }
            this.updateStructure(notifier);
        }
    }

    public void resetStyles(boolean reset_children) {
        List childParts = this.getChildren();
        if (childParts != null) {
            int i = 0;
            while (i < childParts.size()) {
                Object child = childParts.get(i);
                if (child instanceof XMLNodeEditPart) {
                    ((XMLNodeEditPart)child).resetStyles(reset_children);
                }
                ++i;
            }
        }
    }

    public void updateContainer(ContainerStyle cs) {
        List childParts = this.getChildren();
        if (childParts != null) {
            int i = 0;
            while (i < childParts.size()) {
                Object child = childParts.get(i);
                if (child instanceof XMLNodeEditPart) {
                    ((XMLNodeEditPart)child).updateContainer(cs);
                }
                ++i;
            }
        }
    }

    public void updateEditPolicies() {
        List childParts = this.getChildren();
        if (childParts != null) {
            int i = 0;
            while (i < childParts.size()) {
                Object child = childParts.get(i);
                if (child instanceof XMLNodeEditPart) {
                    ((XMLNodeEditPart)child).updateEditPolicies();
                }
                ++i;
            }
        }
    }

    public void updateVisual(boolean update_myself, boolean update_children, boolean update_structure, boolean force) {
        boolean childrenRefreshed = false;
        if (update_structure && (!this.isStructureChanged() || this.isRefreshNeeded)) {
            ViewOption viewOption = ViewerUtil.getViewOption((EditPart)this);
            IDesignTimeTagAdapterInContext iadapter = this.getDesignTimeTagAdapter();
            if (iadapter != null && !iadapter.isNoVisualization() && update_children || this.getSubModelAdapter() != null && viewOption != null && !viewOption.showEmbeddedDocument()) {
                if (this.getSubModelAdapter() != null) {
                    this.getSubModelAdapter().refresh();
                }
                this.removeAllChidlren();
                childrenRefreshed = true;
            }
            this.refreshChildren();
            this.isRefreshNeeded = false;
        }
        if (childrenRefreshed) {
            return;
        }
        List childParts = this.getChildren();
        if (childParts != null) {
            int nChildren = childParts.size();
            int i = 0;
            while (i < nChildren) {
                XMLNodeEditPart child;
                try {
                    child = (XMLNodeEditPart)childParts.get(i);
                }
                catch (ClassCastException classCastException) {
                    child = null;
                }
                if (child != null && update_children) {
                    child.updateVisual(true, true, update_structure, force);
                }
                ++i;
            }
        }
    }

    private IDesignTimeTagAdapterInContext getDesignTimeTagAdapter() {
        ViewOption viewOption = ViewerUtil.getViewOption((EditPart)this);
        if (viewOption != null && viewOption.isVisualizingTag()) {
            if (ElementAliasUtil.aliasName(this.getNode().getNodeName()) != null) {
                return null;
            }
            IDesignTimeTagAdapterInContext adapter = DesignTimeTagUtil.getDesignTimeTagAdapter(this.getNode(), this.getVisualizerViewContext());
            if (adapter != this.dtadapter) {
                if (this.dtadapter != null) {
                    this.dtadapter.removeListener(this);
                }
                if (adapter != null) {
                    adapter.addListener(this);
                }
                this.dtadapter = adapter;
            }
            return this.dtadapter;
        }
        return null;
    }

    private static void updateVisualIfNeeded(EditPart part) {
        List children;
        if (part instanceof OffRenderingEditPart) {
            if (((OffRenderingEditPart)part).isRefreshNeeded) {
                ((OffRenderingEditPart)part).updateVisual(true, false, true, true);
            }
        } else if (part instanceof ElementEditPart && ((ElementEditPart)part).isRefreshNeeded()) {
            ((ElementEditPart)part).updateVisual(true, false, true, true);
        }
        if ((children = part.getChildren()) != null) {
            int i = 0;
            while (i < children.size()) {
                Object child = children.get(i);
                if (child instanceof OffRenderingEditPart) {
                    OffRenderingEditPart.updateVisualIfNeeded((EditPart)((OffRenderingEditPart)child));
                } else if (child instanceof ElementEditPart) {
                    OffRenderingEditPart.updateVisualIfNeeded((EditPart)((ElementEditPart)child));
                }
                ++i;
            }
        }
    }

    private boolean isStructureChanged() {
        RootEditPart root = this.getRoot();
        if (root == null) {
            return false;
        }
        HTMLGraphicalViewerImpl viewer = (HTMLGraphicalViewerImpl)root.getViewer();
        if (viewer == null) {
            return false;
        }
        return viewer.isStructureChanged();
    }

    private void updateStructure(Object property) {
        this.refreshChildren();
    }

    private void eraseUnusedNodeMap() {
        DocumentEditPart dep;
        DesignTimeTagManager dtmanager = ViewerUtil.getDesignTimeTagManager((EditPart)this);
        if (dtmanager != null && (dep = PartAnalyzer.getDocumentEditPart((EditPart)this)) != null) {
            dtmanager.eraseUnusedNodeMap((Document)dep.getNode());
        }
    }

    private void removeAllChidlren() {
        List childParts = this.getChildren();
        ArrayList trash = new ArrayList();
        int i = 0;
        while (i < childParts.size()) {
            trash.add(childParts.get(i));
            ++i;
        }
        i = 0;
        while (i < trash.size()) {
            super.removeChild((EditPart)trash.get(i));
            ++i;
        }
    }

    private List getAllModelChildren() {
        DesignTimeTagManager mgr;
        Document doc;
        DocumentEditPart dep;
        Node model = this.getVisualNode();
        Document embeddedDoc = this.getEmbeddedDocument();
        if (embeddedDoc != null) {
            ArrayList<Document> modelChildren = new ArrayList<Document>(1);
            modelChildren.add(embeddedDoc);
            return modelChildren;
        }
        List childs = null;
        if (ViewerUtil.getViewOption((EditPart)this).isVisualizingTag() && (dep = PartAnalyzer.getDocumentEditPart((EditPart)this)) != null && (doc = (Document)dep.getNode()) != null && (mgr = ViewerUtil.getDesignTimeTagManager((EditPart)this)) != null) {
            childs = mgr.getModelChildren(doc, model, this.getVisualizerViewContext());
        }
        if (childs == null) {
            Node node = model.getFirstChild();
            if (node == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Node> modelChildren = new ArrayList<Node>(model.getChildNodes().getLength());
            while (node != null) {
                modelChildren.add(node);
                node = node.getNextSibling();
            }
            return modelChildren;
        }
        ArrayList modelChildren = new ArrayList(childs.size());
        Iterator it = childs.iterator();
        while (it.hasNext()) {
            modelChildren.add(it.next());
        }
        return modelChildren;
    }

    private Node getVisualNode() {
        Node node;
        Node model = this.getNode();
        IDesignTimeTagAdapterInContext adapter = this.getDesignTimeTagAdapter();
        if (adapter != null && (node = adapter.getSubNode(ViewerUtil.getClientName((EditPart)this), ViewerUtil.getOptionSet((EditPart)this), this.getNode())) != null) {
            model = node;
        }
        return model;
    }

    @Override
    public SubModelAdapter getSubModelAdapter() {
        if (this.subModelAdapter == null) {
            this.subModelAdapter = SubModelAdapterFactory.createSubModelAdapterFor(this);
        } else if (this.subModelAdapter == DISPOSED_SUBMODEL_ADAPTER) {
            return null;
        }
        return this.subModelAdapter;
    }

    @Override
    public SelectionHandler getSelectionHandler() {
        HTMLGraphicalViewerImpl viewer = ViewerUtil.getHTMLGraphicalViewerImpl((EditPart)this);
        if (viewer == null) {
            return null;
        }
        SelectionHandlerFactory factory = viewer.getSelectionHandlerFactory();
        return factory != null ? factory.createSelectionHandler((EditPart)this) : null;
    }

    @Override
    protected void refreshChildren() {
        super.refreshChildren();
        IDesignTimeTagAdapterInContext adapter = this.getDesignTimeTagAdapter();
        if (adapter != null) {
            if (adapter.isEndTagNeeded()) {
                super.refreshChildren();
                this.refreshChildParts();
            }
            adapter.clearNodeMap();
        }
    }

    public void refreshChildParts() {
        DesignTimeTagManager mgr = ViewerUtil.getDesignTimeTagManager((EditPart)this);
        if (mgr != null) {
            mgr.refreshChildParts();
        }
    }

    private void clearDocumentBodies() {
        DocumentEditPart doc = PartAnalyzer.getDocumentEditPart((EditPart)this);
        if (doc != null) {
            doc.clearBodies();
        }
    }

    @Override
    protected void register() {
        super.register();
        try {
            HTMLGraphicalRootEditPart rootPart = (HTMLGraphicalRootEditPart)this.getRoot();
            if (rootPart != null) {
                rootPart.registerStyle(this);
            }
        }
        catch (ClassCastException classCastException) {}
    }

    @Override
    protected void unregister() {
        try {
            HTMLGraphicalRootEditPart rootPart = (HTMLGraphicalRootEditPart)this.getRoot();
            if (rootPart != null) {
                rootPart.unregisterStyle(this);
            }
        }
        catch (ClassCastException classCastException) {}
        super.unregister();
    }

    protected IVisualizerViewContext getVisualizerViewContext() {
        if (this.dtadapter == null) {
            return null;
        }
        return this.dtadapter.getViewContext();
    }
}

