/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.DocumentOwner;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.NodeWrapper;
import com.ibm.etools.webedit.editparts.OffRenderingEditPart;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.editparts.TextEditPart;
import com.ibm.etools.webedit.editparts.VisibleNodeEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        if (context instanceof TextEditPart) {
            return null;
        }
        DocumentEditPart docPart = PartAnalyzer.getDocumentEditPart(context);
        if (docPart == null) {
            return null;
        }
        Node node = model instanceof NodeWrapper ? ((NodeWrapper)model).getNode() : (Node)model;
        NodeEditPart childPart = null;
        switch (node.getNodeType()) {
            case 3: {
                if (context instanceof VisibleNodeEditPart || docPart.isRenderingRoot(node)) {
                    childPart = new TextEditPart();
                    break;
                }
                childPart = new OffRenderingEditPart();
                break;
            }
            case 9: {
                if (!(context instanceof DocumentOwner)) break;
                childPart = ((DocumentOwner)context).createDocumentEditPart((Document)node);
                break;
            }
            default: {
                childPart = context instanceof VisibleNodeEditPart || docPart.isRenderingRoot(node) ? new ElementEditPart() : new OffRenderingEditPart();
            }
        }
        if (childPart != null) {
            childPart.setModel(model);
        }
        return childPart;
    }
}

