/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.ClippableLayer;
import com.ibm.etools.webedit.editparts.ContextUtil;
import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.DragTrackerProvider;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.ElementHighlighter;
import com.ibm.etools.webedit.editparts.FocusChangeListener;
import com.ibm.etools.webedit.editparts.HTMLGraphicalRootEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewer;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.NodeEditPartFactory;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.editparts.RangeUpdateManager;
import com.ibm.etools.webedit.editparts.SelectionHandlerFactory;
import com.ibm.etools.webedit.editparts.SubModelDecoratorFactory;
import com.ibm.etools.webedit.editparts.SubModelHighlighter;
import com.ibm.etools.webedit.editparts.VisibleNodeEditPart;
import com.ibm.etools.webedit.editparts.adapter.SubModelOwner;
import com.ibm.etools.webedit.editparts.design.DesignTimeTagManager;
import com.ibm.etools.webedit.editparts.design.PartTypeManager;
import com.ibm.etools.webedit.editparts.style.GraphicalDocumentCSS;
import com.ibm.etools.webedit.imagetool.ImageAgent;
import com.ibm.etools.webedit.imagetool.ImageException;
import com.ibm.etools.webedit.render.internal.figures.HTMLFigureFactory;
import com.ibm.etools.webedit.render.internal.layout.HTMLLayoutManagerFactory;
import com.ibm.etools.webedit.render.internal.painter.HTMLPainterFactory;
import com.ibm.etools.webedit.render.internal.style.HTMLContainerStyle;
import com.ibm.etools.webedit.render.internal.style.HTMLStyleOwner;
import com.ibm.etools.webedit.render.internal.style.extended.AbstractHTMLStyleFactory;
import com.ibm.etools.webedit.render.internal.style.extended.HTMLStyleFactoryImpl;
import com.ibm.etools.webedit.render.style.ViewOption;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import com.ibm.etools.webedit.viewer.vct.OptionSet;
import com.ibm.etools.webedit.viewer.vct.OptionSetImpl;
import com.ibm.etools.xve.renderer.figures.FigureFactory;
import com.ibm.etools.xve.renderer.figures.IFlowContainer;
import com.ibm.etools.xve.renderer.figures.IFlowFigure;
import com.ibm.etools.xve.renderer.internal.BidiCaretUpdater;
import com.ibm.etools.xve.renderer.internal.bidi.BidiTool;
import com.ibm.etools.xve.renderer.internal.figures.LengthUtil;
import com.ibm.etools.xve.renderer.internal.style.ImageObjectImpl;
import com.ibm.etools.xve.renderer.layout.LayoutManagerFactory;
import com.ibm.etools.xve.renderer.painter.PainterFactory;
import com.ibm.etools.xve.renderer.style.CSSFont;
import com.ibm.etools.xve.renderer.style.ContainerStyle;
import com.ibm.etools.xve.renderer.style.ImageObject;
import com.ibm.etools.xve.renderer.style.ImageObjectFactory;
import com.ibm.etools.xve.renderer.style.ImageUpdater;
import com.ibm.etools.xve.renderer.style.Length;
import com.ibm.etools.xve.renderer.style.RenderOption;
import com.ibm.etools.xve.renderer.style.XMLStyle;
import com.ibm.etools.xve.renderer.style.XMLStyleFactory;
import com.ibm.etools.xve.renderer.utils.URLContext;
import com.ibm.etools.xve.viewer.AbstractXMLGraphicalViewer;
import com.ibm.etools.xve.viewer.EditPolicyFactoryRegistry;
import com.ibm.etools.xve.viewer.ViewNode;
import com.ibm.etools.xve.viewer.internal.ViewNodeImpl;
import com.ibm.etools.xve.viewer.link.AbstractPathContextFactory;
import com.ibm.etools.xve.viewer.link.AbstractPathResolver;
import com.ibm.etools.xve.viewer.link.AbstractPathResolverFactory;
import com.ibm.etools.xve.viewer.link.PathContext;
import com.ibm.etools.xve.viewer.link.PathContextFactory;
import com.ibm.etools.xve.viewer.link.PathResolver;
import com.ibm.etools.xve.viewer.link.PathResolverFactory;
import com.ibm.etools.xve.viewer.submodel.SubModelContribution;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

public class HTMLGraphicalViewerImpl
extends AbstractXMLGraphicalViewer
implements HTMLGraphicalViewer {
    private Caret caret = null;
    private XMLStyleFactory styleFactory = null;
    private Map highlighterMap = null;
    private ElementHighlighter highlighterProto = null;
    private ContainerStyle containerStyle = null;
    private boolean isNeededRefresh = false;
    private boolean isStructureChanged = false;
    private EditPolicyFactoryRegistry policyFactoryReg = null;
    private DragTrackerProvider trackerProvider = null;
    private DesignTimeTagManager designTimeTagManager = null;
    private List focusTargetListeners = null;
    private PartTypeManager partTypeManager = null;
    private String clientName;
    private DocumentEditPart activeDocumentEditPart;
    private SubModelDecoratorFactory decoratorFactory;
    private OptionSet optionSet = new OptionSetImpl();
    private HashMap mapObjectCache = new HashMap();
    private int visibility = 1;
    private Runnable runnable;
    private PathContextFactory pathContextFactory;
    private PathResolverFactory pathResolverFactory;

    private void clearObjectCache() {
        if (this.mapObjectCache == null) {
            return;
        }
        for (ImageObject obj : this.mapObjectCache.values()) {
            if (obj == null) continue;
            obj.releaseRef();
        }
        this.mapObjectCache.clear();
    }

    private String createObjectCacheKey(String url, URLContext context) {
        StringBuffer sb = new StringBuffer(url);
        if (context != null) {
            sb.append(context.getFileBase());
            sb.append(context.getLinkBase());
            sb.append(context.getPageBase());
        }
        return sb.toString();
    }

    public HTMLGraphicalViewerImpl(String clientName) {
        this.clientName = clientName;
    }

    protected HTMLGraphicalViewerImpl() {
    }

    public int getVisibility() {
        return this.visibility;
    }

    public ImageObject createImageObject(PathResolver pathResolver, PathContext pathContext, String url, String tagName, String attrName, ImageUpdater updater) {
        Object obj;
        if (url == null) {
            return null;
        }
        URLContext context = null;
        if (pathContext instanceof URLContext) {
            context = (URLContext)pathContext;
        }
        String objKey = this.createObjectCacheKey(url, context);
        ImageObject imageObject = obj = this.mapObjectCache != null ? (ImageObject)this.mapObjectCache.get(objKey) : null;
        if (obj != null) {
            if (updater != null) {
                obj.addUpdater(updater);
            }
            return obj;
        }
        EditPart root = this.getContents();
        if (!(root instanceof NodeEditPart)) {
            return null;
        }
        try {
            String scheme;
            boolean fileScheme;
            URI uri = new URI(url);
            if (uri.getScheme() == null && uri.getHost() != null) {
                uri = new URI("http:" + url);
            }
            if (uri.isAbsolute() && !(fileScheme = (scheme = uri.getScheme().toLowerCase()).equals("file"))) {
                boolean bundleEntryScheme = scheme.equals("bundleentry");
                if (!(fileScheme || bundleEntryScheme || this.getViewOption().renderExternalImage())) {
                    obj = new HTMLImageObjectImpl(null);
                } else if (bundleEntryScheme || updater != null) {
                    if (bundleEntryScheme) {
                        updater = null;
                    }
                    obj = new HTMLImageObjectImpl(uri.toURL(), updater);
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (MalformedURLException malformedURLException) {}
        if (obj == null) {
            IPath path = pathResolver != null ? pathResolver.getPath((PathContext)context, url, tagName, attrName) : null;
            String absPath = null;
            if (path != null && (absPath = path.toFile().getAbsolutePath()) != null && (absPath.startsWith("//") || absPath.startsWith("\\\\")) && url.startsWith("//")) {
                absPath = null;
            }
            obj = new HTMLImageObjectImpl(absPath);
        }
        if (this.mapObjectCache != null) {
            obj.addRef();
            this.mapObjectCache.put(objKey, obj);
        }
        return obj;
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.caret != null) {
            UpdateManager um = this.getLightweightSystem().getUpdateManager();
            if (um != null && um instanceof RangeUpdateManager) {
                ((RangeUpdateManager)um).setCaret(null);
            }
            this.caret.dispose();
            this.caret = null;
        }
        if (this.highlighterMap != null) {
            IFigure layer = this.getLayerManager().getLayer((Object)"Feedback Layer");
            Set keys = this.highlighterMap.keySet();
            Iterator itr = keys.iterator();
            while (itr.hasNext()) {
                ElementHighlighter highlighter = (ElementHighlighter)this.highlighterMap.get(itr.next());
                layer.remove((IFigure)highlighter);
                highlighter.setEditPart(null);
                highlighter.dispose();
            }
            this.highlighterMap.clear();
        }
        this.highlighterMap = null;
        this.highlighterProto = null;
        super.handleDispose(e);
        if (this.containerStyle != null && this.containerStyle instanceof HTMLContainerStyle) {
            ((HTMLContainerStyle)this.containerStyle).dispose();
            this.containerStyle = null;
        }
        if (this.policyFactoryReg != null) {
            this.policyFactoryReg.unregisterAllFactories();
            this.policyFactoryReg = null;
        }
        if (this.decoratorFactory != null) {
            this.decoratorFactory.dispose();
        }
    }

    protected void expose(EditPart part) {
    }

    protected LightweightSystem createLightweightSystem() {
        return new LightweightSystem(){

            protected void init() {
                this.setUpdateManager((UpdateManager)new RangeUpdateManager());
                super.init();
            }
        };
    }

    public Caret getCaret() {
        if (this.caret == null) {
            Viewport viewport;
            Canvas canvas = (Canvas)this.getControl();
            if (canvas == null || canvas.isDisposed()) {
                return null;
            }
            this.caret = BidiTool.getInstance().isBidiPlatform() ? BidiTool.getInstance().createBidiCaret(canvas, new BidiCaretUpdater(){

                public void directionChanged() {
                    HTMLGraphicalViewerImpl.this.updateBidiCaretDirection();
                }
            }) : new Caret(canvas, 0);
            UpdateManager um = this.getLightweightSystem().getUpdateManager();
            if (um != null && um instanceof RangeUpdateManager) {
                ((RangeUpdateManager)um).setCaret(this.caret);
            }
            if ((viewport = this.getViewport()) != null) {
                viewport.getHorizontalRangeModel().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getSource() instanceof RangeModel && (event.getPropertyName().equals("value") || event.getPropertyName().equals("extent"))) {
                            HTMLGraphicalViewerImpl.this.updateCaret();
                        }
                    }
                });
                viewport.getVerticalRangeModel().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getSource() instanceof RangeModel && (event.getPropertyName().equals("value") || event.getPropertyName().equals("extent"))) {
                            HTMLGraphicalViewerImpl.this.updateCaret();
                        }
                    }
                });
            }
        }
        return this.caret;
    }

    public List getNodeRects(Object node) {
        IFigure fig;
        EditPart target = this.getActiveEditPartFor(node);
        if (target != null && target instanceof VisibleNodeEditPart && (fig = ((VisibleNodeEditPart)target).getFigure()) != null) {
            if (fig instanceof IFlowFigure) {
                List fragments = ((IFlowFigure)fig).getFragments();
                return Collections.unmodifiableList(fragments);
            }
            Rectangle rect = fig.getBounds();
            Vector<Rectangle> l = new Vector<Rectangle>(1);
            l.add(rect);
            return l;
        }
        return null;
    }

    public ImageObjectFactory getImageObjectFactory() {
        return this;
    }

    public final XMLStyleFactory getStyleFactory() {
        if (this.styleFactory == null) {
            this.styleFactory = this.createStyleFactory((Canvas)this.getControl());
        }
        return this.styleFactory;
    }

    protected XMLStyleFactory createStyleFactory(Canvas canvas) {
        return new HTMLStyleFactoryImpl((Scrollable)canvas);
    }

    public final RenderOption getRenderOption() {
        return this.getViewOption();
    }

    @Override
    public ViewOption getViewOption() {
        return null;
    }

    public SelectionHandlerFactory getSelectionHandlerFactory() {
        return null;
    }

    public Point scrollBy(int deltaX, int deltaY) {
        UpdateManager um;
        Point point = new Point(0, 0);
        if (this.caret == null) {
            return point;
        }
        Viewport viewport = this.getViewport();
        if (viewport == null || !viewport.isEnabled() || !viewport.isVisible()) {
            return point;
        }
        Rectangle bounds = viewport.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return point;
        }
        if (deltaX != 0) {
            int curX;
            int caretX = this.caret.getBounds().x + this.caret.getBounds().width;
            int newX = curX = viewport.getViewLocation().x;
            int minX = 0;
            int maxX = viewport.getHorizontalRangeModel().getMaximum();
            if ((newX += deltaX) + caretX < minX) {
                newX = minX;
            } else if (newX + caretX > maxX) {
                newX = maxX;
            }
            if (viewport.getHorizontalRangeModel().getValue() != newX) {
                viewport.getHorizontalRangeModel().setValue(newX);
                point.x = viewport.getHorizontalRangeModel().getValue() - curX;
            }
        }
        if (deltaY != 0) {
            int curY;
            int caretY = this.caret.getBounds().y + this.caret.getBounds().height;
            int newY = curY = viewport.getViewLocation().y;
            int minY = 0;
            int maxY = viewport.getVerticalRangeModel().getMaximum();
            if ((newY += deltaY) + caretY < minY) {
                newY = minY;
            } else if (newY + caretY > maxY) {
                newY = maxY;
            }
            if (viewport.getVerticalRangeModel().getValue() != newY) {
                viewport.getVerticalRangeModel().setValue(newY);
                point.y = viewport.getVerticalRangeModel().getValue() - curY;
            }
        }
        if ((point.x != 0 || point.y != 0) && (um = this.getLightweightSystem().getUpdateManager()) != null) {
            um.performUpdate();
        }
        return point;
    }

    protected void updateCaret() {
    }

    protected void updateBidiCaretDirection() {
    }

    @Override
    public void updateSelection() {
    }

    public void updateView(int v) {
        this.visibility = v;
        this.updateView(true);
    }

    @Override
    public void updateView() {
        this.updateView(true);
    }

    @Override
    public void updateView(boolean update_structure) {
        this.clearObjectCache();
        EditPart root = this.getContents();
        if (root != null) {
            DocumentEditPart part;
            try {
                part = (DocumentEditPart)root;
            }
            catch (ClassCastException classCastException) {
                part = null;
            }
            if (part != null) {
                ContainerStyle cs = this.getContainerStyle();
                if (cs != null && cs instanceof HTMLContainerStyle) {
                    ((HTMLContainerStyle)cs).update(true);
                }
                this.updateVisual(update_structure);
            }
        }
    }

    public void updateVisual() {
        this.updateVisual(true);
    }

    protected void updateVisual(final boolean update_structure) {
        if (this.runnable != null) {
            return;
        }
        this.runnable = new Runnable(){

            @Override
            public void run() {
                HTMLGraphicalViewerImpl.this.runnable = null;
                EditPart part = HTMLGraphicalViewerImpl.this.getContents();
                if (part == null || !(part instanceof DocumentEditPart)) {
                    return;
                }
                ((DocumentEditPart)part).updateVisual(true, true, update_structure, true);
            }
        };
        if (Display.getCurrent() != Display.getDefault()) {
            Display.getDefault().syncExec(this.runnable);
        } else {
            this.runnable.run();
        }
    }

    @Override
    public CSSStyleDeclaration getDefaultStyle(Element element) {
        return null;
    }

    protected void createDefaultRoot() {
        this.setRootEditPart((RootEditPart)new HTMLGraphicalRootEditPart());
    }

    public org.eclipse.swt.graphics.Point getExt(int w, int h) {
        ScrollBar sb;
        IFigure fff;
        Viewport v;
        EditPart editPart = this.getContents();
        if (editPart == null) {
            return null;
        }
        List children = editPart.getChildren();
        if (children == null) {
            return null;
        }
        editPart = (EditPart)children.get(0);
        if (!(editPart instanceof ElementEditPart)) {
            return null;
        }
        XMLStyle s = ((ElementEditPart)editPart).getStyle();
        if (s == null) {
            return null;
        }
        CSSFont cssFont = s.getCSSFont();
        if (cssFont == null) {
            return null;
        }
        Font f = cssFont.getDefaultSwtFont();
        if (f == null) {
            return null;
        }
        char[] sss = new char[w];
        int i = 0;
        while (i < w) {
            sss[i] = 109;
            ++i;
        }
        String str = new String(sss);
        GC gc = new GC((Drawable)this.getControl());
        gc.setFont(f);
        org.eclipse.swt.graphics.Point ext = gc.textExtent(str);
        gc.dispose();
        ext.y *= h;
        Length l = s.getLength(25);
        if (l != null) {
            ext.x += LengthUtil.getLengthByPixel((int)25, (int)0, (int)0, (Length)l, (CSSFont)cssFont);
        }
        if ((l = s.getLength(26)) != null) {
            ext.x += LengthUtil.getLengthByPixel((int)26, (int)0, (int)0, (Length)l, (CSSFont)cssFont);
        }
        if ((l = s.getLength(23)) != null) {
            ext.y += LengthUtil.getLengthByPixel((int)23, (int)0, (int)0, (Length)l, (CSSFont)cssFont);
        }
        if ((l = s.getLength(24)) != null) {
            ext.y += LengthUtil.getLengthByPixel((int)24, (int)0, (int)0, (Length)l, (CSSFont)cssFont);
        }
        if ((v = this.getViewport()) != null && (fff = v.getParent()) != null && fff instanceof ScrollPane && (sb = ((ScrollPane)fff).getVerticalScrollBar()) != null) {
            Dimension size = sb.getSize();
            ext.x += size.width;
            ext.y += size.height;
        }
        if (w < 0) {
            ext.x = -1;
        }
        if (h < 0) {
            ext.y = -1;
        }
        return ext;
    }

    public void setIMCaretHeight(int height) {
    }

    protected final ContainerStyle getContainerStyle() {
        return this.containerStyle;
    }

    public void updateMargins(int h, boolean hs, int v, boolean vs) {
        EditPart root = this.getContents();
        if (root != null) {
            DocumentEditPart part;
            try {
                part = (DocumentEditPart)root;
            }
            catch (ClassCastException classCastException) {
                part = null;
            }
            if (part != null) {
                ContainerStyle cs = this.getContainerStyle();
                if (cs == null || !(cs instanceof HTMLContainerStyle)) {
                    return;
                }
                HTMLContainerStyle container_style = (HTMLContainerStyle)cs;
                container_style.setHorizontalMarginPixel(h, hs);
                container_style.setVerticalMarginPixel(v, vs);
                container_style.update(false);
                part.updateContainer(container_style);
            }
        }
    }

    public EditPolicyFactoryRegistry getPolicyFactoryRegistry() {
        if (this.policyFactoryReg == null) {
            this.policyFactoryReg = new EditPolicyFactoryRegistry();
        }
        return this.policyFactoryReg;
    }

    public DragTrackerProvider getDragTrackerProvider() {
        return this.trackerProvider;
    }

    public void setDragTrackerProvider(DragTrackerProvider trackerProvider) {
        this.trackerProvider = trackerProvider;
    }

    public DesignTimeTagManager getDesignTimeTagManager() {
        return this.designTimeTagManager;
    }

    public void setDesignTimeTagManager(DesignTimeTagManager designTimeTagManager) {
        this.designTimeTagManager = designTimeTagManager;
    }

    public boolean isNeededRereshChildren() {
        return this.isNeededRefresh;
    }

    public void setRefreshChildrenFlag(boolean isNeededRefresh) {
        this.isNeededRefresh = isNeededRefresh;
    }

    public boolean isStructureChanged() {
        return this.isStructureChanged;
    }

    public void setStructureChangedFlag(boolean isStructureChanged) {
        this.isStructureChanged = isStructureChanged;
    }

    public ElementHighlighter getElementHighligher(EditPart part) {
        ElementHighlighter highlighter;
        if (this.getControl().isDisposed() || this.highlighterProto == null) {
            return null;
        }
        if (part == null) {
            return this.highlighterProto;
        }
        if (this.highlighterMap == null) {
            this.highlighterMap = new HashMap();
        } else if (this.highlighterMap.containsKey(part)) {
            return (ElementHighlighter)this.highlighterMap.get(part);
        }
        boolean isSingle = this.highlighterProto.isSingle();
        ElementHighlighter elementHighlighter = highlighter = isSingle ? this.highlighterProto : this.highlighterProto.getCopy();
        if (highlighter != null) {
            IFigure layer = this.getLayerManager().getLayer((Object)"Feedback Layer");
            highlighter.setupEditPart(part);
            boolean isNew = true;
            if (isSingle) {
                List children = layer.getChildren();
                if (children.contains(highlighter)) {
                    isNew = false;
                }
                highlighter.setVisible(true);
            }
            if (isNew) {
                layer.add((IFigure)highlighter);
            }
            if (!isSingle) {
                this.highlighterMap.put(part, highlighter);
            }
            if (layer instanceof ClippableLayer) {
                ((ClippableLayer)layer).setClip(highlighter.getClip());
            }
            if ((layer = this.getLayerManager().getLayer((Object)"Handle Layer")) instanceof ClippableLayer) {
                ((ClippableLayer)layer).setClip(highlighter.getClip());
            }
        }
        return highlighter;
    }

    public ElementHighlighter removeElementHighligher(EditPart part) {
        if (this.highlighterProto != null && this.highlighterProto.isSingle()) {
            this.highlighterProto.setVisible(false);
        } else if (part != null && this.highlighterMap != null && this.highlighterMap.containsKey(part)) {
            ElementHighlighter highlighter = (ElementHighlighter)this.highlighterMap.remove(part);
            highlighter.setVisible(false);
            highlighter.setEditPart(null);
            IFigure layer = this.getLayerManager().getLayer((Object)"Feedback Layer");
            layer.remove((IFigure)highlighter);
            highlighter.dispose();
            return highlighter;
        }
        return null;
    }

    public void setElementHighligher(ElementHighlighter hl) {
        if (this.highlighterProto == hl) {
            return;
        }
        this.highlighterProto = hl;
        if (this.highlighterMap != null) {
            this.highlighterMap.clear();
        }
    }

    public void updateElementHighlighter() {
        if (this.highlighterProto == null) {
            return;
        }
        if (this.highlighterMap == null || this.highlighterMap.isEmpty()) {
            return;
        }
        Collection highlighters = this.highlighterMap.values();
        for (ElementHighlighter hl : highlighters) {
            if (hl == null) continue;
            hl.update(this.highlighterProto);
        }
    }

    public void addFocusTargetListener(FocusChangeListener listener) {
        if (this.focusTargetListeners == null) {
            this.focusTargetListeners = new ArrayList(1);
        }
        this.focusTargetListeners.add(listener);
    }

    public void removeFocusTargetListener(FocusChangeListener listener) {
        if (this.focusTargetListeners != null && this.focusTargetListeners.contains(listener)) {
            this.focusTargetListeners.remove(listener);
        }
    }

    void focusTargetChanged(EditPart part, boolean enable) {
        if (this.focusTargetListeners != null) {
            for (FocusChangeListener listener : this.focusTargetListeners) {
                listener.focusChanged(part, enable);
            }
        }
    }

    @Override
    public PartTypeManager getPartTypeManager() {
        return this.partTypeManager;
    }

    public void setPartTypeManager(PartTypeManager flm) {
        this.partTypeManager = flm;
    }

    protected void unhookControl() {
        super.unhookControl();
        this.clearObjectCache();
    }

    protected final boolean calculateNeedsEncoding(IDOMModel model) {
        return model != null ? LinkUtil.needsEncoding(model) : false;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public SubModelOwner getSubModelOwner() {
        return null;
    }

    @Override
    public DocumentEditPart getActiveDocumentEditPart() {
        return this.activeDocumentEditPart;
    }

    public void setActiveDocumentEditPart(DocumentEditPart newPart) {
        this.changeSubModelHighlighterState(this.activeDocumentEditPart, false);
        this.activeDocumentEditPart = newPart;
        this.changeSubModelHighlighterState(this.activeDocumentEditPart, true);
        SubModelOwner subModelOwner = this.getSubModelOwner();
        if (subModelOwner != null) {
            Node node;
            Node node2 = node = this.activeDocumentEditPart != null ? this.activeDocumentEditPart.getNode() : null;
            if (node instanceof IDOMNode) {
                subModelOwner.subModelActivated(((IDOMNode)node).getModel(), this);
            }
        }
    }

    private void changeSubModelHighlighterState(DocumentEditPart activePart, boolean editingState) {
        if (activePart == null || !activePart.isEmbeddedDocument()) {
            return;
        }
        EditPart parentPart = activePart.getParent();
        SubModelHighlighter subModelHighlighter = this.getExistingSubModelHighlighter(parentPart);
        if (subModelHighlighter != null) {
            subModelHighlighter.setEditingState(editingState);
        }
    }

    public SubModelHighlighter getExistingSubModelHighlighter(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        SubModelDecoratorFactory factory = this.getSubModelDecoratorFactory();
        if (factory != null && PartAnalyzer.isSubModelContainer(editPart)) {
            return factory.getExistingSubModelHighlighter(editPart);
        }
        return null;
    }

    @Override
    public EditPart getEditPartFor(DocumentEditPart doc, Object node) {
        if (node == null || doc == null) {
            return null;
        }
        try {
            if (doc == this.getContents()) {
                return (EditPart)this.getEditPartRegistry().get(node);
            }
            Object model = doc.getNodeWrapperRegistry().get(node);
            return (EditPart)this.getEditPartRegistry().get(model);
        }
        catch (NullPointerException e) {
            Logger.log(e);
        }
        catch (ClassCastException e) {
            Logger.log(e);
        }
        return null;
    }

    @Override
    public EditPart getActiveEditPartFor(Object node) {
        return this.getEditPartFor(this.activeDocumentEditPart, node);
    }

    @Override
    public List getEditPartsFor(Object node) {
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        List parts = this.getAllDocumentEditParts();
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        try {
            for (DocumentEditPart documentEditPart : parts) {
                EditPart editPart;
                if (documentEditPart == this.getContents()) {
                    editPart = (EditPart)this.getEditPartRegistry().get(node);
                } else {
                    Object model = documentEditPart.getNodeWrapperRegistry().get(node);
                    editPart = (EditPart)this.getEditPartRegistry().get(model);
                }
                if (editPart == null) continue;
                list.add(editPart);
            }
        }
        catch (NullPointerException e) {
            Logger.log(e);
        }
        catch (ClassCastException e) {
            Logger.log(e);
        }
        return list;
    }

    public void setContents(EditPart editpart) {
        super.setContents(editpart);
        this.setContainerStyle();
        if (editpart instanceof DocumentEditPart) {
            this.setActiveDocumentEditPart((DocumentEditPart)editpart);
        }
    }

    protected void setContainerStyle() {
        EditPart contents = this.getContents();
        if (contents == null) {
            return;
        }
        IFlowContainer flowContainer = null;
        try {
            flowContainer = (IFlowContainer)((DocumentEditPart)contents).getFigure();
            if (flowContainer != null) {
                this.containerStyle = this.createContainerStyle();
                flowContainer.setContainerStyle(this.containerStyle);
            }
        }
        catch (ClassCastException e) {
            Logger.log(e);
        }
    }

    protected ContainerStyle createContainerStyle() {
        if (this.getStyleFactory() instanceof AbstractHTMLStyleFactory) {
            return ((AbstractHTMLStyleFactory)this.getStyleFactory()).createDefaultContainerStyle();
        }
        return null;
    }

    @Override
    public List getAllDocumentEditParts() {
        EditPart rootDocumentEditPart = this.getContents();
        if (!(rootDocumentEditPart instanceof DocumentEditPart)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList editParts = new ArrayList();
        ((DocumentEditPart)rootDocumentEditPart).getAllDocumentEditParts(editParts);
        return editParts;
    }

    @Override
    public GraphicalDocumentCSS getDocumentCSS() {
        GraphicalDocumentCSS docCss = null;
        try {
            docCss = (GraphicalDocumentCSS)this.getRootEditPart();
        }
        catch (ClassCastException classCastException) {}
        return docCss;
    }

    public SubModelDecoratorFactory getSubModelDecoratorFactory() {
        if (this.decoratorFactory == null) {
            this.decoratorFactory = new SubModelDecoratorFactory(this);
        }
        return this.decoratorFactory;
    }

    public Object getAdapter(Class adapter) {
        if (OptionSet.class.equals((Object)adapter)) {
            return this.optionSet;
        }
        return null;
    }

    public EditPartFactory getEditPartFactory() {
        EditPartFactory factory = super.getEditPartFactory();
        if (factory == null) {
            factory = new NodeEditPartFactory();
            this.setEditPartFactory(factory);
        }
        return factory;
    }

    protected boolean showsThisImage(IResource resource) {
        if (this.mapObjectCache == null) {
            return false;
        }
        if (resource == null) {
            return false;
        }
        IPath targetImagePath = resource.getLocation();
        if (targetImagePath == null) {
            return false;
        }
        for (ImageObjectImpl imageObj : this.mapObjectCache.values()) {
            Path innerImagePath;
            if (imageObj == null || imageObj.getUrl() == null || !targetImagePath.equals((Object)(innerImagePath = new Path(imageObj.getUrl())))) continue;
            return true;
        }
        return false;
    }

    public LayoutManagerFactory getLayoutManagerFactory() {
        return HTMLLayoutManagerFactory.getInstance();
    }

    public FigureFactory getFigureFactory() {
        return HTMLFigureFactory.getInstance();
    }

    public PainterFactory getPainterFactory() {
        return HTMLPainterFactory.getInstance();
    }

    public PathContextFactory getPathContextFactory() {
        if (this.pathContextFactory == null) {
            this.pathContextFactory = new PathContextFactoryImpl();
        }
        return this.pathContextFactory;
    }

    public PathResolverFactory getPathResolverFactory() {
        if (this.pathResolverFactory == null) {
            this.pathResolverFactory = new PathResolverFactoryImpl();
        }
        return this.pathResolverFactory;
    }

    public SubModelContribution getSubModelContribution() {
        return null;
    }

    class HTMLImageObjectImpl
    extends ImageObjectImpl {
        private ImageAgent agent;

        public HTMLImageObjectImpl(URL url, ImageUpdater updater) {
            super(url, updater);
        }

        public HTMLImageObjectImpl(InputStream is) {
            super(is);
        }

        public HTMLImageObjectImpl(String url) {
            super(url);
        }

        private void initImageAgent() {
            if (this.agent == null) {
                try {
                    if (this.getUrl() != null) {
                        this.agent = new ImageAgent(this.getUrl(), true);
                    } else if (this.is != null) {
                        this.agent = new ImageAgent(this.is, true);
                    }
                }
                catch (SWTException sWTException) {
                    this.agent = null;
                }
                catch (IOException iOException) {
                    this.agent = null;
                }
                catch (ImageException imageException) {
                    this.agent = null;
                }
            }
        }

        private ImageData getWBMPImageData() {
            this.initImageAgent();
            if (this.agent != null && this.agent.getImageFormat() == 17) {
                return this.agent.createImageData();
            }
            return null;
        }

        protected Image getStaticImageFromExtraLoader() {
            ImageData id = this.getWBMPImageData();
            if (id != null) {
                Display disp = Display.getDefault();
                return new Image((Device)disp, id);
            }
            return null;
        }
    }

    private class PathContextFactoryImpl
    extends AbstractPathContextFactory {
        private PathContextFactoryImpl() {
        }

        public PathContext createPathContext(Node node, ViewNode viewNode) {
            EditPart editPart = null;
            if (viewNode instanceof EditPart) {
                editPart = (EditPart)viewNode;
            } else if (viewNode instanceof ViewNodeImpl) {
                editPart = ((ViewNodeImpl)viewNode).getCorrespondingEditPart();
            }
            if (editPart instanceof HTMLStyleOwner) {
                return ((HTMLStyleOwner)editPart).getURLContext();
            }
            return editPart != null ? ContextUtil.getURLContext(editPart) : null;
        }

        public PathContext createPathContext(String namespace, Document document, ViewNode viewDoc) {
            return this.createPathContext(document, viewDoc);
        }
    }

    private class PathResolverFactoryImpl
    extends AbstractPathResolverFactory {
        private PathResolver resolver;

        public PathResolverFactoryImpl() {
            this.resolver = new PathResolverImpl();
        }

        public PathResolver createPathResolver(Node node, ViewNode viewNode) {
            return this.resolver;
        }
    }

    private class PathResolverImpl
    extends AbstractPathResolver {
        private PathResolverImpl() {
        }

        public IPath getPath(PathContext context, String url, String tagName, String attrName) {
            return LinkUtil.getFilePath(context instanceof URLContext ? (URLContext)context : null, url, tagName, attrName, false);
        }
    }
}

