/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.ClippableLayer;
import com.ibm.etools.webedit.editparts.ContextUtil;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.OffRenderingEditPart;
import com.ibm.etools.webedit.editparts.style.CSSGraphicalQueryTraverser;
import com.ibm.etools.webedit.editparts.style.CSSMediaType;
import com.ibm.etools.webedit.editparts.style.DocumentStyleSheetList;
import com.ibm.etools.webedit.editparts.style.EditPartStyleUpdater;
import com.ibm.etools.webedit.editparts.style.GraphicalDocumentCSS;
import com.ibm.etools.webedit.editparts.style.GraphicalStyleSheetList;
import com.ibm.etools.webedit.editparts.style.LinkStyleStore;
import com.ibm.etools.webedit.editparts.style.LinkStyleStoreForLink;
import com.ibm.etools.webedit.editparts.style.LinkStyleStoreForStyle;
import com.ibm.etools.webedit.editparts.style.StylesheetListListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class HTMLGraphicalRootEditPart
extends ScalableRootEditPart
implements GraphicalDocumentCSS {
    private List styleSheetOwners;
    private EditPartStyleUpdater styleListener = new EditPartStyleUpdater(this);
    private List stylesheetListListeners;
    private boolean initialStyleUpdateCompleted;
    private CSSGraphicalQueryTraverser query = null;

    protected LayeredPane createPrintableLayers() {
        return new LayeredPane();
    }

    protected void createLayers(LayeredPane layeredPane) {
        Layer layer = new Layer();
        layer.setLayoutManager((LayoutManager)new StackLayout());
        layeredPane.add((IFigure)layer, (Object)"Primary Layer");
        layer = new ConnectionLayer();
        layer.setPreferredSize(new Dimension(5, 5));
        layeredPane.add((IFigure)layer, (Object)"Connection Layer");
        layer = new ClippableLayer();
        layer.setPreferredSize(new Dimension(5, 5));
        layeredPane.add((IFigure)layer, (Object)"Handle Layer");
        layer = new FeedbackLayer();
        layer.setPreferredSize(new Dimension(5, 5));
        layeredPane.add((IFigure)layer, (Object)"Feedback Layer");
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(ElementEditPart part, String pseudoElt) {
        if (part == null) {
            return null;
        }
        return this.getCSSGraphicalQueryTraverser().getDeclaration(part, pseudoElt, ContextUtil.getURLContext((EditPart)part));
    }

    public long getCSSGraphicalQueryTraverserSize() {
        if (this.query == null) {
            return 0L;
        }
        return this.query.getCacheCount() * 32 + 56;
    }

    public void clearCSSGraphicalQueryTraverser() {
        this.query = null;
    }

    private CSSGraphicalQueryTraverser getCSSGraphicalQueryTraverser() {
        block4: {
            if (this.query != null) break block4;
            StyleSheetList ssl = this.getStyleSheets();
            int numStyles = ssl.getLength();
            MyStyleSheetList dssl = null;
            if (ssl instanceof MyStyleSheetList) {
                dssl = (MyStyleSheetList)ssl;
            }
            CSSGraphicalQueryTraverser newQuery = new CSSGraphicalQueryTraverser();
            newQuery.setTraverseImported(true);
            newQuery.setTraverseImportFirst(true);
            int i = 0;
            while (i < numStyles) {
                block6: {
                    StyleSheet ss;
                    block7: {
                        block5: {
                            ss = ssl.item(i);
                            if (dssl == null) break block5;
                            if (!dssl.containsScreenMedium(i)) break block6;
                            OffRenderingEditPart linkPart = dssl.getRawOwner(i).getPart();
                            newQuery.setUrlContext(ContextUtil.getURLContext((EditPart)linkPart));
                            break block7;
                        }
                        newQuery.setUrlContext(ContextUtil.getURLContext(this.getContents()));
                    }
                    try {
                        newQuery.apply((ICSSNode)ss);
                    }
                    catch (ClassCastException classCastException) {}
                }
                ++i;
            }
            this.query = newQuery;
        }
        return this.query;
    }

    @Override
    public StyleSheetList getStyleSheets() {
        return this.getDocumentStyleSheets();
    }

    @Override
    public DocumentStyleSheetList getDocumentStyleSheets() {
        int owners = this.styleSheetOwners != null ? this.styleSheetOwners.size() : 0;
        MyStyleSheetList ssList = new MyStyleSheetList(owners);
        int i = 0;
        while (i < owners) {
            ssList.add(this.styleSheetOwners.get(i));
            ++i;
        }
        return ssList;
    }

    public void setContents(EditPart editpart) {
        this.initialStyleUpdateCompleted = false;
        this.resetStyleSheetList();
        super.setContents(editpart);
        this.initialStyleUpdateCompleted = true;
    }

    public void deactivate() {
        super.deactivate();
        this.resetStyleSheetList();
    }

    public void resetStyleSheetList() {
        if (this.styleSheetOwners != null) {
            int size = this.styleSheetOwners.size();
            int i = 0;
            while (i < size) {
                ((LinkStyleStore)this.styleSheetOwners.get(i)).dispose();
                ++i;
            }
            this.styleSheetOwners.clear();
        }
    }

    private List getStyleSheetOwners() {
        if (this.styleSheetOwners == null) {
            this.styleSheetOwners = new ArrayList();
        }
        return this.styleSheetOwners;
    }

    public void registerStyle(OffRenderingEditPart part) {
        String nodeName;
        if (part != null && part.getNode() instanceof Element && ((nodeName = ((Element)part.getNode()).getNodeName()).equalsIgnoreCase("LINK") || nodeName.equalsIgnoreCase("STYLE"))) {
            this.insertStyle(part);
        }
    }

    private void insertStyle(OffRenderingEditPart part) {
        List list = this.getStyleSheetOwners();
        int i = 0;
        while (i < list.size()) {
            OffRenderingEditPart current = ((LinkStyleStore)list.get(i)).getPart();
            int ret = this.compare((EditPart)current, (EditPart)part);
            if (ret > 0) {
                LinkStyleStore store = this.createLinkStyleStore(part);
                if (store != null) {
                    store.setMediaScreen(CSSMediaType.isMediaScreen(part.getNode()));
                    store.getModel();
                }
                list.add(i, store);
                return;
            }
            if (ret == 0) {
                return;
            }
            ++i;
        }
        LinkStyleStore store = this.createLinkStyleStore(part);
        if (store != null) {
            store.setMediaScreen(CSSMediaType.isMediaScreen(part.getNode()));
            store.getModel();
        }
        list.add(store);
        this.fireStylesheetListChanged();
    }

    private int compare(EditPart part1, EditPart part2) {
        if (part1.getParent().equals(part2.getParent())) {
            return HTMLGraphicalRootEditPart.compareSibling(part1, part2);
        }
        EditPart[] chain1 = HTMLGraphicalRootEditPart.getChain(part1);
        EditPart[] chain2 = HTMLGraphicalRootEditPart.getChain(part2);
        for (int i = 0; i < chain1.length && i < chain2.length; ++i) {
            if (chain1[i] == chain2[i]) {
                continue;
            }
            if (i == 0) {
                return chain1[i] == this ? 1 : -1;
            }
            return HTMLGraphicalRootEditPart.compareSibling(chain1[i], chain2[i]);
        }
        return chain1.length - chain2.length;
    }

    private static int compareSibling(EditPart part1, EditPart part2) {
        int index1 = part1.getParent().getChildren().indexOf(part1);
        int index2 = part2.getParent().getChildren().indexOf(part2);
        return index1 - index2;
    }

    private static EditPart[] getChain(EditPart part) {
        ArrayList<EditPart> chain = new ArrayList<EditPart>();
        while (part != null) {
            chain.add(0, part);
            part = part.getParent();
        }
        EditPart[] parts = new EditPart[chain.size()];
        chain.toArray(parts);
        return parts;
    }

    public void unregisterStyle(OffRenderingEditPart part) {
        if (this.styleSheetOwners != null) {
            for (LinkStyleStore store : this.getStyleSheetOwners()) {
                if (store.getPart() != part) continue;
                this.styleSheetOwners.remove(store);
                store.dispose();
                this.fireStylesheetListChanged();
                break;
            }
        }
    }

    public void updateStyle(OffRenderingEditPart part, Object changedFeature, Object oldValue, Object newValue) {
        if (this.styleSheetOwners != null && changedFeature instanceof Attr && "media".equalsIgnoreCase(((Attr)changedFeature).getName())) {
            for (LinkStyleStore store : this.getStyleSheetOwners()) {
                if (store.getPart() != part || store.isMediaScreen() == CSSMediaType.isMediaScreen(part.getNode())) continue;
                this.styleSheetOwners.remove(store);
                store.dispose();
                this.insertStyle(part);
            }
        }
    }

    private LinkStyleStore createLinkStyleStore(OffRenderingEditPart part) {
        if (part.getNode().getNodeName().equalsIgnoreCase("LINK")) {
            return new LinkStyleStoreForLink(part, this.styleListener, this.initialStyleUpdateCompleted);
        }
        if (part.getNode().getNodeName().equalsIgnoreCase("STYLE")) {
            return new LinkStyleStoreForStyle(part, this.styleListener, this.initialStyleUpdateCompleted);
        }
        return null;
    }

    public void addStylesheetListListener(StylesheetListListener listener) {
        if (this.stylesheetListListeners == null) {
            this.stylesheetListListeners = new ArrayList();
        }
        if (!this.stylesheetListListeners.contains(listener)) {
            this.stylesheetListListeners.add(listener);
        }
    }

    public void removeStylesheetListListener(StylesheetListListener listener) {
        if (this.stylesheetListListeners != null) {
            this.stylesheetListListeners.remove(listener);
        }
    }

    public void fireStylesheetListChanged() {
        this.clearCSSGraphicalQueryTraverser();
        if (this.stylesheetListListeners != null) {
            for (StylesheetListListener listener : this.stylesheetListListeners) {
                listener.stylesheetListChanged();
            }
        }
    }

    class FeedbackLayer
    extends ClippableLayer {
        FeedbackLayer() {
        }

        public IFigure findFigureAtExcluding(int x, int y, TreeSearch c) {
            return null;
        }
    }

    static class MyStyleSheetList
    extends ArrayList
    implements GraphicalStyleSheetList {
        private static final long serialVersionUID = 1L;

        public MyStyleSheetList() {
        }

        public MyStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public int getLength() {
            return this.size();
        }

        @Override
        public StyleSheet item(int index) {
            if (index < 0 || this.size() <= index) {
                return null;
            }
            LinkStyle source = (LinkStyle)this.get(index);
            return source.getSheet();
        }

        @Override
        public Document itemOwner(int index) {
            if (index < 0 || this.size() <= index) {
                return null;
            }
            Node node = ((LinkStyleStore)this.get(index)).getPart().getNode();
            return node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        }

        @Override
        public LinkStyleStore getRawOwner(int index) {
            if (index < 0 || this.size() <= index) {
                return null;
            }
            return (LinkStyleStore)this.get(index);
        }

        public boolean containsScreenMedium(int index) {
            if (index < 0 || this.size() <= index) {
                return false;
            }
            return CSSMediaType.isMediaScreen(((LinkStyleStore)this.get(index)).getPart().getNode());
        }
    }
}

