/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.render.internal.figures.CssScrollingFigure;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;

public abstract class ElementHighlighter
extends Figure
implements Cloneable {
    private ElementEditPart editPart = null;
    private FigureListener figureListener = null;
    private Rectangle clip = null;

    public final ElementHighlighter getCopy() {
        try {
            ElementHighlighter highlighter = (ElementHighlighter)this.clone();
            highlighter.bounds = new Rectangle(0, 0, 0, 0);
            highlighter.figureListener = null;
            highlighter.setupEditPart(null);
            return highlighter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final void setupEditPart(EditPart part) {
        if (part instanceof ElementEditPart) {
            if (this.figureListener == null) {
                this.figureListener = new FigureListener(){

                    public void figureMoved(IFigure source) {
                        if (ElementHighlighter.this.editPart != null) {
                            ElementHighlighter.this.editPartMoved(ElementHighlighter.this.editPart);
                        }
                    }
                };
            }
            if (this.editPart != null) {
                this.editPart.getFigure().removeFigureListener(this.figureListener);
            }
            this.editPart = (ElementEditPart)part;
            if (this.editPart != null) {
                this.editPart.getFigure().addFigureListener(this.figureListener);
            }
            this.setEditPart(this.editPart);
            this.setClip(this.editPart);
        }
    }

    public boolean isSingle() {
        return false;
    }

    private void setClip(ElementEditPart editPart) {
        this.clip = null;
        if (editPart == null) {
            return;
        }
        IFigure f = editPart.getFigure();
        while (f != null) {
            if (f instanceof CssScrollingFigure) {
                this.clip = ((CssScrollingFigure)f).getContentArea();
                break;
            }
            f = f.getParent();
        }
    }

    protected Rectangle getClip() {
        return this.clip;
    }

    public void dispose() {
    }

    public boolean setTargetPosition(Point point) {
        return false;
    }

    public void editPartMoved(ElementEditPart part) {
        this.setClip(part);
    }

    public void update(ElementHighlighter highlighterProto) {
    }

    public boolean containsPoint(int arg0, int arg1) {
        return false;
    }

    public abstract void setEditPart(ElementEditPart var1);
}

