/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.view;

import com.ibm.etools.palette.PaletteReader;
import com.ibm.etools.palette.model.PaletteItemDataImpl;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteHandler;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteTarget;
import com.ibm.etools.webedit.palette.Feedback;
import com.ibm.etools.webedit.palette.HTMLPaletteLowMemoryListener;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.PaletteItemInfoRegistry;
import com.ibm.etools.webedit.palette.PalettePlugin;
import com.ibm.etools.webedit.palette.ResourceHandler;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteCustomizer;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteViewerPreferences;
import com.ibm.etools.webedit.palette.model.PaletteCategory;
import com.ibm.etools.webedit.palette.model.PaletteItem;
import com.ibm.etools.webedit.palette.view.HTMLPaletteCustomizerDialog;
import com.ibm.etools.webedit.palette.view.HTMLPaletteTransferDragSourceListener;
import com.ibm.etools.webedit.palette.view.PaletteSelectionTool;
import java.util.List;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

class HTMLPaletteViewerImpl
extends PaletteViewer
implements HTMLPaletteViewer,
HTMLPaletteHandler {
    private boolean contentsCreated;
    private HTMLPaletteTarget paletteTarget;
    private int deselectTimerValue = 1000;
    private boolean isGTK;
    private boolean lockCreation;
    private EditPart lockedPart;
    protected PaletteRoot myRoot = null;
    protected HTMLEditDomain editDomain = null;
    private PaletteCustomizerDialog customizerDialog = null;

    public HTMLPaletteViewerImpl(HTMLEditDomain editDomain) {
        EditDomain domain = this.getEditDomain();
        if (domain != null) {
            domain.setDefaultTool((Tool)new PaletteSelectionTool());
            Tool tool = domain.getDefaultTool();
            if (tool != null) {
                domain.setActiveTool(tool);
            }
        }
        this.isGTK = false;
        String s = SWT.getPlatform();
        if (s != null && s.equalsIgnoreCase("gtk")) {
            this.isGTK = true;
        }
        this.editDomain = editDomain;
    }

    void setPaletteTarget(HTMLPaletteTarget target) {
        this.paletteTarget = target;
    }

    @Override
    public HTMLPaletteTarget getPaletteTarget() {
        return this.paletteTarget;
    }

    @Override
    public void deselectAllEntries() {
        List v = this.getSelectedEditParts();
        if (v != null) {
            int max = v.size();
            int i = 0;
            while (i < max) {
                IFigure fig;
                Object obj = v.get(i);
                if (obj instanceof GraphicalEditPart && (fig = ((GraphicalEditPart)obj).getFigure()) instanceof Clickable) {
                    ((Clickable)fig).getModel().setArmed(false);
                    ((Clickable)fig).getModel().setPressed(false);
                    ((Clickable)fig).getModel().setSelected(false);
                }
                ++i;
            }
        }
        this.setActiveTool(null);
    }

    @Override
    public void deselect(EditPart part) {
        IFigure fig;
        if (part instanceof GraphicalEditPart && (fig = ((GraphicalEditPart)part).getFigure()) instanceof Clickable) {
            ((Clickable)fig).getModel().setArmed(false);
            ((Clickable)fig).getModel().setPressed(false);
            ((Clickable)fig).getModel().setSelected(false);
        }
        if (part != null) {
            Object obj = part.getModel();
            ToolEntry entry = super.getActiveTool();
            if (obj != null && entry != null && obj.equals(entry)) {
                this.setActiveTool(null);
            }
        }
    }

    @Override
    public void setOpaqueActiveEntry() {
        List v = this.getSelectedEditParts();
        if (v != null) {
            int max = v.size();
            int i = 0;
            while (i < max) {
                IFigure fig;
                Object obj = v.get(i);
                if (obj instanceof GraphicalEditPart && (fig = ((GraphicalEditPart)obj).getFigure()) instanceof Clickable) {
                    ((Clickable)fig).setSelected(true);
                    fig.setOpaque(true);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean checkActivation() {
        Feedback f;
        PaletteItemDataImpl data = this.getSelectedItem();
        if (data != null && (f = data.getFeedback()) != null) {
            switch (f.getActivationFreedback()) {
                case 2: {
                    this.setDeselectTimer(this.getFocusEditPart());
                    this.showMessageBox(f.getDisabledMessage());
                    return false;
                }
                case 1: {
                    this.setDeselectTimer(this.getFocusEditPart());
                    return false;
                }
            }
        }
        return true;
    }

    private PaletteItemDataImpl getSelectedItem() {
        List items = this.getSelectedEditParts();
        if (items != null) {
            int max = items.size();
            int i = 0;
            while (i < max) {
                EditPart part;
                Object obj = items.get(i);
                if (obj instanceof EditPart && (obj = (part = (EditPart)obj).getModel()) instanceof PaletteItem && (obj = ((PaletteItem)obj).getTemplate()) instanceof PaletteItemDataImpl) {
                    return (PaletteItemDataImpl)obj;
                }
                ++i;
            }
        }
        return null;
    }

    private EditPart getSelectedPart() {
        List items = this.getSelectedEditParts();
        if (items != null) {
            int max = items.size();
            int i = 0;
            while (i < max) {
                EditPart part;
                Object obj = items.get(i);
                if (obj instanceof EditPart && (obj = (part = (EditPart)obj).getModel()) instanceof PaletteItem) {
                    return part;
                }
                ++i;
            }
        }
        return null;
    }

    private void showMessageBox(String s) {
        Shell shell;
        Display d;
        if (s == null || s.length() <= 0) {
            s = ResourceHandler._UI_Selected_item_can_not_be_inserted__1;
        }
        if ((d = Display.getCurrent()) != null && (shell = d.getActiveShell()) != null) {
            MessageDialog.openWarning((Shell)shell, (String)ResourceHandler._UI_Not_allowed_2, (String)s);
        }
    }

    private void setDeselectTimer(EditPart p) {
        Display d;
        if (p != null && (d = Display.getCurrent()) != null) {
            d.timerExec(this.deselectTimerValue, (Runnable)new DeselectTimer(p));
        }
    }

    @Override
    public boolean isSelectionChanged() {
        ToolEntry entry;
        PaletteItemDataImpl data = this.getSelectedItem();
        return data == null || !((entry = super.getActiveTool()) instanceof PaletteItem) || !data.equals(((PaletteItem)entry).getTemplate());
    }

    public void setActiveTool(ToolEntry newMode) {
        if (newMode == null && this.lockCreation) {
            return;
        }
        if (newMode instanceof PaletteItem) {
            if (((PaletteItem)newMode).isDropOnly()) {
                this.deselect(this.getFocusEditPart());
                return;
            }
            ((PaletteItem)newMode).setViewer(this);
            ((PaletteItem)newMode).setTarget(this.paletteTarget);
            if (!this.checkActivation()) {
                return;
            }
        }
        super.setActiveTool(newMode);
    }

    private boolean invokeQuickAction(PaletteItem item) {
        boolean done = false;
        String idItem = item.getId();
        String idCategory = null;
        PaletteCategory cat = item.getCategory();
        if (cat != null) {
            idCategory = cat.getId();
        }
        if (this.paletteTarget == null || !this.paletteTarget.shouldDelegateAction(idCategory, idItem)) {
            IAction action;
            EditPart part = this.getFocusEditPart();
            PaletteItemDataImpl template = (PaletteItemDataImpl)item.getTemplate();
            if (template != null && (action = template.getAction()) != null) {
                PaletteItemInfoRegistry.getInstance().put(action, template, null, null, true);
                action.run();
                PaletteItemInfoRegistry.getInstance().remove(action);
            }
            this.deselect(part);
            done = true;
        }
        return done;
    }

    @Override
    public boolean invokeQuickAction() {
        ToolEntry entry = this.getActiveTool();
        return entry instanceof PaletteItem && this.invokeQuickAction((PaletteItem)entry);
    }

    @Override
    public void setCreationLock(boolean lock) {
        if (this.isGTK && this.lockCreation != lock) {
            this.lockCreation = lock;
            if (lock) {
                this.lockedPart = this.getSelectedPart();
            } else {
                this.deselect(this.lockedPart);
                this.lockedPart = null;
            }
        }
    }

    EditPart getLockedPart() {
        if (this.isGTK) {
            return this.lockedPart;
        }
        return null;
    }

    public void setPaletteRoot(PaletteRoot root) {
        this.myRoot = root;
        PaletteViewerPreferences prefs = this.getPaletteViewerPreferences();
        if (prefs instanceof HTMLPaletteViewerPreferences) {
            ((HTMLPaletteViewerPreferences)prefs).setHTMLPaletteViewer(this);
            ((HTMLPaletteViewerPreferences)prefs).setPaletteRoot(root);
        }
        super.setPaletteRoot(root);
    }

    public void setPaletteViewerPreferences(PaletteViewerPreferences prefs) {
        super.setPaletteViewerPreferences(prefs);
        if (prefs instanceof HTMLPaletteViewerPreferences) {
            ((HTMLPaletteViewerPreferences)prefs).setPaletteRoot(this.myRoot);
            if (this.getCustomizer() != null) {
                ((HTMLPaletteCustomizer)this.getCustomizer()).setPreferences((HTMLPaletteViewerPreferences)prefs);
            }
        }
    }

    public void setCustomizer(PaletteCustomizer customizer) {
        super.setCustomizer(customizer);
        if (customizer instanceof HTMLPaletteCustomizer && this.getPaletteViewerPreferences() instanceof HTMLPaletteViewerPreferences) {
            ((HTMLPaletteCustomizer)customizer).setPreferences((HTMLPaletteViewerPreferences)this.getPaletteViewerPreferences());
        }
    }

    public String getContext() {
        PaletteViewerPreferences prefs = this.getPaletteViewerPreferences();
        if (prefs instanceof HTMLPaletteViewerPreferences) {
            return ((HTMLPaletteViewerPreferences)prefs).getContext();
        }
        return null;
    }

    public boolean setContext(String newContext) {
        PaletteViewerPreferences prefs = this.getPaletteViewerPreferences();
        if (prefs instanceof HTMLPaletteViewerPreferences) {
            ((HTMLPaletteViewerPreferences)prefs).setContext(newContext);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createContents() {
        if (this.contentsCreated) return;
        Class<HTMLPaletteViewerImpl> clazz = HTMLPaletteViewerImpl.class;
        synchronized (HTMLPaletteViewerImpl.class) {
            if (this.contentsCreated) return;
            this.contentsCreated = true;
            this.setPaletteRoot(PalettePlugin.getDefault().getRoot());
            this.addDragSourceListener((TransferDragSourceListener)new HTMLPaletteTransferDragSourceListener((EditPartViewer)this));
            this.getControl().update();
            HTMLPaletteLowMemoryListener.setPaletteIsUp(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void updateModel() {
        PaletteReader.getInstance().addDefinitions(this.getHtmlEditDomain());
    }

    void initialize(boolean synchronous) {
        if (synchronous) {
            this.updateModel();
            this.createContents();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    HTMLPaletteViewerImpl.this.updateModel();
                    HTMLPaletteViewerImpl.this.createContents();
                }
            });
        }
    }

    protected void handleFocusGained(FocusEvent fe) {
        if (!this.contentsCreated) {
            this.initialize(true);
        }
        super.handleFocusGained(fe);
    }

    @Override
    public IEditorInput getContributingEditorInput() {
        IWorkbenchPart part;
        if (this.paletteTarget != null && (part = this.paletteTarget.getWorkbenchPart()) instanceof IEditorPart) {
            return ((IEditorPart)part).getEditorInput();
        }
        return null;
    }

    @Override
    public HTMLEditDomain getHtmlEditDomain() {
        return this.editDomain;
    }

    protected void handleDispose(DisposeEvent e) {
        super.handleDispose(e);
        HTMLPaletteLowMemoryListener.setPaletteIsUp(false);
    }

    @Override
    public void refreshView() {
        this.setPaletteRoot(PalettePlugin.getDefault().getRoot());
        this.getControl().update();
        this.customizerDialog = null;
    }

    public PaletteCustomizerDialog getCustomizerDialog() {
        if (this.customizerDialog == null) {
            this.customizerDialog = new HTMLPaletteCustomizerDialog(this.getControl().getShell(), this.getCustomizer(), this.getPaletteRoot());
        }
        return this.customizerDialog;
    }

    @Override
    public void refreshModel() {
        this.updateModel();
    }

    private class DeselectTimer
    implements Runnable {
        EditPart part;

        public DeselectTimer(EditPart part) {
            this.part = part;
        }

        @Override
        public void run() {
            HTMLPaletteViewerImpl.this.deselect(this.part);
        }
    }
}

