/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.view;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteSource;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteTarget;
import com.ibm.etools.webedit.palette.PaletteContextRegistryReader;
import com.ibm.etools.webedit.palette.PalettePlugin;
import com.ibm.etools.webedit.palette.PaletteRefresher;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteCustomizer;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteViewerPreferences;
import com.ibm.etools.webedit.palette.customize.PaletteContextContextMenuProvider;
import com.ibm.etools.webedit.palette.view.HTMLPaletteSourceImpl;
import com.ibm.etools.webedit.palette.view.HTMLPaletteViewerImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class HTMLPalettePage
extends Page
implements PalettePage,
IAdaptable {
    protected HTMLPaletteViewerImpl viewer;
    protected HTMLEditDomain editDomain;
    protected Composite myParent;
    protected Control paletteControl;
    protected DefaultPaletteViewerPreferences preferencesSource;
    private DelegatingSelectionProvider selectionProvider = new DelegatingSelectionProvider();
    protected HTMLPaletteViewerPreferences preference;

    public HTMLPalettePage(HTMLEditDomain editDomain) {
        this.editDomain = editDomain;
    }

    public void createControl(Composite parent) {
        if (parent != this.myParent || this.paletteControl == null || this.paletteControl.isDisposed()) {
            IProject project;
            IFile file;
            IEditorInput input;
            this.viewer = new HTMLPaletteViewerImpl(this.editDomain);
            PaletteRefresher.getInstance().addViewer(this.viewer);
            this.paletteControl = this.viewer.createControl(parent);
            this.viewer.setCustomizer(new HTMLPaletteCustomizer());
            this.viewer.setContextMenu((MenuManager)new PaletteContextContextMenuProvider(this.viewer));
            this.preference = new HTMLPaletteViewerPreferences();
            this.viewer.setPaletteViewerPreferences(this.preference);
            HTMLPaletteSourceImpl source = new HTMLPaletteSourceImpl(this.viewer);
            HTMLPaletteTarget target = this.editDomain.hookPalette((HTMLPaletteSource)source);
            source.setPaletteTarget(target);
            this.viewer.setPaletteTarget(target);
            if (this.viewer != null && (input = this.viewer.getContributingEditorInput()) != null && (file = (IFile)input.getAdapter(IFile.class)) != null && (project = file.getProject()) != null) {
                this.preference.setContext(PaletteContextRegistryReader.getActiveContext(project, this.editDomain));
            }
            this.viewer.initialize(false);
            this.myParent = parent;
        }
    }

    public DefaultPaletteViewerPreferences getPreferencesSource() {
        if (this.preferencesSource == null) {
            this.preferencesSource = new DefaultPaletteViewerPreferences(PalettePlugin.getDefault().getPreferenceStore());
        }
        return this.preferencesSource;
    }

    public Control getControl() {
        return this.paletteControl;
    }

    public void setFocus() {
    }

    private IWorkbenchPart getContributingEditor() {
        HTMLPaletteTarget target;
        if (this.viewer != null && (target = this.viewer.getPaletteTarget()) != null) {
            return target.getWorkbenchPart();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return HTMLPalettePage.this.getContributingEditor();
                }
            };
        }
        return null;
    }

    private ISelection getDelegatingSelection(IWorkbenchPart part) {
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    public void dispose() {
        IPageSite site = this.getSite();
        if (site != null) {
            site.setSelectionProvider(null);
        }
        if (this.preference != null) {
            this.preference.releaseListeners();
        }
        PaletteRefresher.getInstance().removeViewer(this.viewer);
        super.dispose();
    }

    private class DelegatingSelectionProvider
    implements ISelectionProvider {
        private DelegatingSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return HTMLPalettePage.this.getDelegatingSelection(HTMLPalettePage.this.getContributingEditor());
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

