/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.model;

import com.ibm.etools.palette.model.PaletteItemDataImpl;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteTarget;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.model.PaletteCategory;
import com.ibm.etools.webedit.palette.model.PaletteCategoryItem;
import com.ibm.etools.webedit.palette.model.PaletteCreationTool;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteItem
extends CombinedTemplateCreationEntry
implements PaletteCategoryItem {
    protected PaletteCategory fCategory;
    protected String fIconName;
    protected PaletteItemDataImpl fTemplate;
    protected PaletteViewer viewer;
    protected HTMLPaletteTarget target;

    public PaletteItem(String arg0, String arg1, Object arg2, CreationFactory arg3, ImageDescriptor arg4, ImageDescriptor arg5) {
        super(arg0, arg1, arg2, arg3, arg4, arg5);
        this.setUserModificationPermission(7);
    }

    public void setLabel(String s) {
        super.setLabel(s);
        if (this.fTemplate != null) {
            this.fTemplate.setLabel(s);
        }
    }

    public void setDescription(String s) {
        super.setDescription(s);
        if (this.fTemplate != null) {
            this.fTemplate.setDescription(s);
        }
    }

    @Override
    public void setVisible(boolean newVal) {
        super.setVisible(newVal);
        this.fTemplate.setVisible(newVal);
    }

    @Override
    public String getCategoryName() {
        if (this.fCategory == null) {
            return this.fTemplate.getCategory().getId();
        }
        return this.fCategory.getId();
    }

    @Override
    public void setCategoryName(String categoryName) {
        this.fTemplate.getCategory().setId(categoryName);
    }

    @Override
    public PaletteCategory getCategory() {
        return this.fCategory;
    }

    @Override
    public void setCategory(PaletteCategory category) {
        this.fCategory = category;
        this.setParent((PaletteContainer)category);
        if (this.fCategory == null) {
            this.setCategoryName(null);
        } else {
            this.setCategoryName(this.fCategory.getId());
        }
    }

    public String getIconName() {
        return this.fIconName;
    }

    public void setIconName(String iconName) {
        this.fIconName = iconName;
    }

    @Override
    public String getId() {
        return this.fTemplate.getId();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (this.fTemplate != null) {
            this.fTemplate.setId(id);
        }
    }

    public ImageDescriptor getSmallIcon() {
        ImageDescriptor icon = super.getSmallIcon();
        return icon;
    }

    @Override
    public void setTemplate(Object template) {
        this.fTemplate = template instanceof PaletteItemDataImpl ? (PaletteItemDataImpl)template : null;
        super.setTemplate(template);
    }

    public Tool createTool() {
        PaletteCreationTool tool = null;
        if (this.viewer instanceof HTMLPaletteViewer) {
            tool = new PaletteCreationTool(this.getTemplate(), this.viewer, this.target);
            tool.setFeedback(this.fTemplate.getFeedback());
        }
        return tool;
    }

    public boolean isDropOnly() {
        return this.fTemplate != null && this.fTemplate.isDropOnly();
    }

    public void setParent(PaletteContainer newParent) {
        super.setParent(newParent);
        if (newParent instanceof PaletteCategory) {
            this.setCategoryName(((PaletteCategory)newParent).getId());
        }
    }

    public void setViewer(PaletteViewer viewer) {
        this.viewer = viewer;
    }

    public void setTarget(HTMLPaletteTarget target) {
        this.target = target;
    }

    @Override
    public void setVisible(boolean newVal, String context) {
        super.setVisible(newVal);
        if (this.fTemplate != null) {
            this.fTemplate.setVisible(newVal, context);
        }
    }

    @Override
    public void updateVisible(String context, HTMLPaletteViewer viewer) {
        boolean isVisible = true;
        if (this.fTemplate != null) {
            isVisible = this.fTemplate.isVisible(context, viewer);
        }
        super.setVisible(isVisible);
    }
}

