/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.model;

import com.ibm.etools.palette.model.PaletteItemDataImpl;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteTarget;
import com.ibm.etools.webedit.palette.Feedback;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.PaletteItemInfoRegistry;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Cursor;

public class PaletteCreationTool
extends CreationTool {
    private Object template;
    private PaletteViewer viewer;
    private HTMLPaletteTarget target;
    private Rectangle lastRect;
    private boolean enableCursor = true;
    private Feedback feedback;

    public PaletteCreationTool(Object template, PaletteViewer viewer, HTMLPaletteTarget target) {
        this.template = template;
        this.viewer = viewer;
        this.target = target;
    }

    protected void performCreation(int button) {
        CreateRequest req = this.getCreateRequest();
        if (req != null && this.enableCursor) {
            Point pt = req.getLocation();
            Dimension sz = req.getSize();
            this.executeCurrentCommand();
            this.invokeAction(pt, sz);
        }
        if (this.viewer instanceof HTMLPaletteViewer) {
            ((HTMLPaletteViewer)this.viewer).setCreationLock(false);
        }
    }

    private void invokeAction(Point pt, Dimension sz) {
        IAction action;
        PaletteItemDataImpl data;
        if (this.template != null && pt != null && this.target != null && (pt = this.target.translateToGlobal(pt)) != null && (data = (PaletteItemDataImpl)this.template) != null && (action = data.getAction()) != null) {
            PaletteItemInfoRegistry.getInstance().put(action, data, pt, sz, false);
            this.target.delegateActionRun(action);
            PaletteItemInfoRegistry.getInstance().remove(action);
        }
    }

    protected boolean handleEnteredEditPart() {
        return true;
    }

    protected void handleFinished() {
        super.handleFinished();
        if (this.viewer instanceof HTMLPaletteViewer) {
            HTMLPaletteTarget paletteTarget = ((HTMLPaletteViewer)this.viewer).getPaletteTarget();
            if (paletteTarget != null) {
                paletteTarget.loadDefaultTool();
            }
            ((HTMLPaletteViewer)this.viewer).deselectAllEntries();
        }
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest((Object)"create from palette");
        request.setFactory(this.getFactory());
        return request;
    }

    protected void updateTargetRequest() {
        Dimension sz;
        CreateRequest req;
        super.updateTargetRequest();
        this.enableCursor = true;
        if (this.isInState(4) && this.viewer instanceof HTMLPaletteViewer && (req = this.getCreateRequest()) != null && (sz = req.getSize()) != null) {
            HTMLPaletteTarget paletteTarget;
            Point pt = req.getLocation();
            EditPartViewer cviewer = this.getCurrentViewer();
            if (pt != null && cviewer != null && (paletteTarget = ((HTMLPaletteViewer)this.viewer).getPaletteTarget()) != null) {
                Rectangle r = null;
                r = this.feedback != null && this.feedback.getActivationFreedback() == 3 ? paletteTarget.delegateCreationFeedback(new Rectangle(pt, sz), cviewer, this.getCurrentInput().isShiftKeyDown(), true) : paletteTarget.delegateCreationFeedback(new Rectangle(pt, sz), cviewer, this.getCurrentInput().isShiftKeyDown(), false);
                if (r != null) {
                    this.lastRect = r;
                }
            }
            if (this.lastRect == null) {
                req.setSize(null);
                this.enableCursor = false;
            } else if (this.lastRect.width < 0 || this.lastRect.height < 0) {
                this.lastRect = null;
                req.setSize(null);
            } else {
                req.setLocation(this.lastRect.getLocation());
                req.setSize(this.lastRect.getSize());
            }
        }
        if (this.feedback == null) {
            return;
        }
    }

    protected Cursor calculateCursor() {
        if (this.isInState(0x40000000)) {
            return null;
        }
        return this.enableCursor ? this.getDefaultCursor() : this.getDisabledCursor();
    }

    protected boolean handleButtonDown(int button) {
        Point pt;
        super.handleButtonDown(button);
        CreateRequest req = this.getCreateRequest();
        if (req != null && (pt = req.getLocation()) != null) {
            this.target.delegateCaretUpdate(pt);
        }
        return true;
    }

    public void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }
}

